//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
/** Shockwave that eminates from a Strangelove detonation.
*/
class StrangeWaveb expands Strangewave config (RX6T4);

#exec TEXTURE IMPORT NAME=ThermoflareB FILE=Textures\ThermoflareB.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=ThermoflareB FILE=Textures\ThermoflareB.pcx GROUP=Skins PALETTE=ThermoflareB

#exec AUDIO IMPORT FILE="Sounds\ExplosionSound2.wav" NAME="ExplosionSound2" GROUP="RX6T4Sounds"

var() Sound detonateSound;
var() config float shockMult;

// Mesh radius.
var() float meshr;
var() localized string deathStr, deathSelfStr;
var() name dtype;
var ThermoWaveb slave;

// Slave is upside down?
var bool bSlaveDown;

var Util u;


simulated function postBeginPlay() {
	local Actor a;
	local vector hl, hn;

	u = spawn(Class'Util', self);
	u.setDebugLevel(DL_Verbose);

	a = trace(hl, hn, (location + vect(0, 0, -1) * 125), location, false);
	if (a != none) {
		// Set it on the ground. Looks stupid hovering!
		setLocation(hl);
		setRotation(rotator(hn) + rot(-16384, 0, 0));
	}

	if (!level.bDropDetail && level.netmode != NM_DedicatedServer) {
		slave = spawn(Class'ThermoWaveB');

		// If we're above flat ground, generate another hemisphere.
		if (a == none) {
			// Turn it upside down.
			slave.setRotation(rot(0, 0, -32768));
			//slave.setLocation(location + vect(0, 0, 1) * 20);
			bSlaveDown = true;
		}
	}

	loopAnim('rotate', 3.7);
	super.postBeginPlay();
}

/** Called from postBeginPlay().
*/
simulated function spawnEffects() {
	local float v;

	v = 9.0 * (shockMult / default.shockMult);
        spawn(class'RX6T4.XShockb',,, location);
	spawn(class'RX6T4.RedeemerBurnFlareb',,, location); 
	playSound(detonateSound, SLOT_None, v);
	//playSound(detonateSound, SLOT_Interface, v);
	playSound(detonateSound, SLOT_Misc, v);
	//playSound(detonateSound, SLOT_Talk, v);
}


simulated function setRadius() {
	shockSize = cos(lifespan) * shockMult;
}


/** This is really for looks. The dedicated server calculates the
	radius in timer (that's when the real work is done).
*/
simulated function tick(float delta) {
	if (level.netmode != NM_DedicatedServer) {
		setRadius();

		scaleGlow = lifespan;
		ambientGlow = default.ambientGlow * (lifespan / default.lifespan);
		drawScale = shockSize;
	if (slave != none) {
			slave.scaleGlow = scaleGlow;
			slave.ambientGlow = slave.default.ambientGlow * (lifespan / default.lifespan);
			slave.drawScale = drawScale;
			if (!bSlaveDown)
				slave.drawScale *= 0.75;
		}


	}
}


simulated function timer() {
	local int i;
	local vector dir;
	//local StrangeExplb exp;
	local DamagePuff puff;

	if (level.netmode == NM_DedicatedServer) {
		setRadius();
	} else {
		// Effects.
		if (level.bHighDetailMode && !level.bDropDetail) {
			for (i = 0; i < (shockMult * 0.5); i++) {
				dir = vrand();
				dir.z *= 0.2;
				//exp = spawn(class'StrangeExplb',,, location + (dir * meshr * shocksize));
				//exp.remoteRole = ROLE_None;
			}
		}
	}

	//if (role == ROLE_Authority)
		vaporize();
}


/** Carcass chunks are the authority on the client.
*/

/*
simulated function vaporize() {
     local Actor victim;
     local float damageScale, dist, moscale;
     local vector dir;
     local strangeshell sl;
     local bool bFlying;

     foreach visibleCollidingActors(class 'Actor', victim, shockSize * meshr, location) {
          if (victim.role == ROLE_Authority) {
	  bFlying=False;
	  sl=None;

               // Maybe someday I'll figure this out.
               //if (level.netmode == NM_Client)
                 //   u.debug("vaporize(): victim has authority: " $ u.sname(victim));



	if(!bTeamExplosionDamage)
	{
			if(victim.IsA('Antislv'))     //always destroy missiles
			{
               dir = victim.location - location;
               dist = fmax(1, vsize(dir));
               dir = dir/dist + vect(0, 0, 0.3);
               if ((dist > oldShockDistance) || (dir dot victim.velocity <= 0)) {
                    moscale = fmax(0, 1100 - 1.1 * dist);

                    // Non-pawns don't need death messages.
                    if (role == ROLE_Authority && victim.bIsPawn) {
                         Pawn(victim).addVelocity(dir * (moscale + 20));

                         if (victim == instigator)
                              u.setDamageString(deathSelfStr, instigator, victim);
                         else
                              u.setDamageString(deathStr, instigator, victim);
                    } else {
                         victim.velocity = victim.velocity + dir * (moscale + 20);
                    }
					victim.takedamage(moscale, instigator, victim.location - 0.5 * (victim.collisionHeight + victim.collisionRadius) * dir, (1000 * dir), dtype);
		}
			}
			else if(victim.IsA('strangeshell'))
			{
				if(strangeshell(victim).Team!=Instigator.PlayerReplicationInfo.Team || strangeshell(victim).Pilot==Instigator || strangeshell(victim).Pilot==None)
				{
               dir = victim.location - location;
               dist = fmax(1, vsize(dir));
               dir = dir/dist + vect(0, 0, 0.3);
               if ((dist > oldShockDistance) || (dir dot victim.velocity <= 0)) {
                    moscale = fmax(0, 1100 - 1.1 * dist);

                    // Non-pawns don't need death messages.
                    if (role == ROLE_Authority && victim.bIsPawn) {
                         Pawn(victim).addVelocity(dir * (moscale + 20));

                         if (victim == instigator)
                              u.setDamageString(deathSelfStr, instigator, victim);
                         else
                              u.setDamageString(deathStr, instigator, victim);
                    } else {
                         victim.velocity = victim.velocity + dir * (moscale + 20);
                    }
					victim.takedamage(moscale, instigator, victim.location - 0.5 * (victim.collisionHeight + victim.collisionRadius) * dir, (1000 * dir), dtype);
		}
				}
			}
			else if(victim.IsA('Pawn'))
			{
				if(Pawn(victim)!=Instigator && Pawn(victim)!=LastGunner)
				{
					ForEach AllActors(Class'strangeshell', sl)
					{
						if(sl.Pilot==Pawn(victim) || sl.Gunner==Pawn(victim))
						{
							bFlying=True;     //is our victim flying in s jet?
							break;
						}
					}
				}
				if(!bFlying)
				{
               dir = victim.location - location;
               dist = fmax(1, vsize(dir));
               dir = dir/dist + vect(0, 0, 0.3);
               if ((dist > oldShockDistance) || (dir dot victim.velocity <= 0)) {
                    moscale = fmax(0, 1100 - 1.1 * dist);

                    // Non-pawns don't need death messages.
                    if (role == ROLE_Authority && victim.bIsPawn) {
                         Pawn(victim).addVelocity(dir * (moscale + 20));

                         if (victim == instigator)
                              u.setDamageString(deathSelfStr, instigator, victim);
                         else
                              u.setDamageString(deathStr, instigator, victim);
                    } else {
                         victim.velocity = victim.velocity + dir * (moscale + 20);
                    }
					victim.takedamage(moscale, instigator, victim.location - 0.5 * (victim.collisionHeight + victim.collisionRadius) * dir, (1000 * dir), dtype);
		}
				}
			} else {
               dir = victim.location - location;
               dist = fmax(1, vsize(dir));
               dir = dir/dist + vect(0, 0, 0.3);
               if ((dist > oldShockDistance) || (dir dot victim.velocity <= 0)) {
                    moscale = fmax(0, 1100 - 1.1 * dist);

                    // Non-pawns don't need death messages.
                    if (role == ROLE_Authority && victim.bIsPawn) {
                         Pawn(victim).addVelocity(dir * (moscale + 20));

                         if (victim == instigator)
                              u.setDamageString(deathSelfStr, instigator, victim);
                         else
                              u.setDamageString(deathStr, instigator, victim);
                    } else {
                         victim.velocity = victim.velocity + dir * (moscale + 20);
                    }
			}
			}
	} else {
               dir = victim.location - location;
               dist = fmax(1, vsize(dir));
               dir = dir/dist + vect(0, 0, 0.3);
               if ((dist > oldShockDistance) || (dir dot victim.velocity <= 0)) {
                    moscale = fmax(0, 1100 - 1.1 * dist);

                    // Non-pawns don't need death messages.
                    if (role == ROLE_Authority && victim.bIsPawn) {
                         Pawn(victim).addVelocity(dir * (moscale + 20));

                         if (victim == instigator)
                              u.setDamageString(deathSelfStr, instigator, victim);
                         else
                              u.setDamageString(deathStr, instigator, victim);
                    } else {
                         victim.velocity = victim.velocity + dir * (moscale + 20);
                    }
     	}
		}
     }
	}
     oldShockDistance = shockSize * meshr;
}

*/
simulated function destroyed() {
	local vector loc;

	if (level.netmode != NM_DedicatedServer) {
		if (!level.bDropDetail)
			spawn(Class'BlackCloud');
	}
	super.destroyed();
}



// end

defaultproperties
{
    detonateSound=Sound'RX6T4Sounds.ExplosionSound2'
    shockMult=9.00
    meshr=50.00
    deathStr="%o Got Pwned by %k"
    deathSelfStr="%k Vaporised %kopself into molecules"
    dtype=SpecialDamage
    Texture=Texture'X7.b1'
    Skin=Texture'X7.b1'
}
