//=====================================================================
// RX5v2.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//          Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================

class strangeMutator extends Mutator Config (RX6T4);

// These are set in the client options window.
var() config bool bRandomPlacement;     // Enable random konglauncher around the flag.
//var() config bool bRandomOldStyle;
var() config int maxNumSLSpawns; // Max number of RX spawn points around the flag
var() config bool bRandomFuelNearKong;
var() config bool bMaxAmmo;
var() config int randSpawnDist;  // Max distance for Konglauncher to spawn around the flag.
//var() config int randSpawnDistOldStyle;
var() config int randFuelNearKong;
var bool bExpired;
var Util u;

#exec OBJ LOAD FILE=..\System\X6RP.u PACKAGE=X6RP
#exec OBJ LOAD FILE=..\System\SLV2Models.u PACKAGE=SLV2Models
#exec OBJ LOAD FILE=..\Textures\SLV2TexTures.utx PACKAGE=SLV2TexTures
#exec OBJ LOAD FILE=..\Textures\SLV2Fonts.utx PACKAGE=SLV2Fonts
#exec OBJ LOAD FILE=..\Sounds\SLV2Sounds.uax PACKAGE=SLV2Sounds
#exec OBJ LOAD FILE=..\Sounds\NemesisWS.uax PACKAGE=NemesisWS
#exec OBJ LOAD FILE=..\Textures\RXHOFXHAIR.utx PACKAGE=RXHOFXHAIR
#exec OBJ LOAD FILE=..\Textures\X7.utx PACKAGE=X7


function PreBeginPlay ()
{
	bExpired = Class'Util'.static.expiredBeta(Level);
	 Super.PreBeginPlay();
}

function PostBeginPlay ()
{
	 if ( !bExpired )
	 {
		  Spawn(Class'ProjectileSN');
		  SetTimer(0.10,False);
	 }
	 Super.PostBeginPlay();
}

function timer() {
	 if (bRandomPlacement)
			spawnRandSL(randSpawnDist);

  //  if (bRandomOldStyle)
	//    spawnRandOldStyle(randSpawnDistOldStyle);

		if (bRandomFuelNearKong)
			   spawnFuelNearKong(randFuelNearKong);



}

function spawnRandSL(int dist) {
local FlagBase fb;
local PathNode pn;
local int i;

foreach AllActors(Class'FlagBase', fb) {
// spawn it at all points within the radius
i=1;
foreach RadiusActors(Class'PathNode', pn, dist, fb.location) {
spawn(Class'Konglauncher',,, pn.location);
if (i==maxNumSLSpawns) {
break;
}
i++;
}
}
}

/////////////////////////////////////////////////////
function spawnFuelNearKong(int dist) {
	 local Konglauncher kl;

	 local PathNode pn;
	 local int numk, spawnindex;

	 foreach AllActors(Class'Konglauncher', kl) {
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   numk++;
		  }

		  // Pick a random node and spawn it at that point.
		  spawnindex = rand(numk);
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   if (spawnindex == numk) {
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		  }
		}
	 foreach AllActors(Class'Konglauncher', kl) {
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   numk++;
		  }

		  // Pick a random node and spawn it at that point.
		  spawnindex = rand(numk);
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   if (spawnindex == numk) {
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		  }
		}
	 foreach AllActors(Class'Konglauncher', kl) {
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   numk++;
		  }

		  // Pick a random node and spawn it at that point.
		  spawnindex = rand(numk);
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   if (spawnindex == numk) {
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		  }
	}
	 foreach AllActors(Class'Konglauncher', kl) {
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   numk++;
		  }

		  // Pick a random node and spawn it at that point.
		  spawnindex = rand(numk);
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   if (spawnindex == numk) {
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		  }
	 }

	 foreach AllActors(Class'Konglauncher', kl) {
		  numk = 0;

		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   numk++;
		  }

		  // Pick a random node and spawn it at that point.
		  spawnindex = rand(numk);
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   if (spawnindex == numk) {
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		  }
		}
	 foreach AllActors(Class'Konglauncher', kl) {
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   numk++;
		  }

		  // Pick a random node and spawn it at that point.
		  spawnindex = rand(numk);
		  numk = 0;
		  foreach RadiusActors(Class'PathNode', pn, dist, kl.location) {
			   if (spawnindex == numk) {
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		  }
	 }
}

function bool checkReplacement(Actor o, out byte bSuperRelevant) {
	//if (bExpired)
	//	return true;
	

		if (o.isA('WarheadLauncher') ) {
		replaceWith(o, "RX6T4.Konglauncher");
		return false;
	}

	return true;
}

function bool alwaysKeep(Actor o) {
	// if (bExpired)
		//  return false;

	 if (bMaxAmmo && o.isA('SLWeapon'))
		  SLWeapon(o).maxOut();

		return super.alwaysKeep(o);
}


// Added rotation rate fix. Otherwise exactly the same as the super.
function bool ReplaceWith(actor Other, string aClassName) {
	 local Actor A;
	 local class<Actor> aClass;

	 if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		  return false;

	 aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	 if ( aClass != None )
		  A = Spawn(aClass,,Other.tag,Other.Location, Other.Rotation);
	 if ( Other.IsA('Inventory') )
	 {
		  if ( Inventory(Other).MyMarker != None )
		  {
			   Inventory(Other).MyMarker.markedItem = Inventory(A);
			   if ( Inventory(A) != None )
			   {
					Inventory(A).MyMarker = Inventory(Other).MyMarker;
					A.SetLocation(A.Location
						 + (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			   }
			   Inventory(Other).MyMarker = None;
		  }
		  else if ( A.IsA('Inventory') )
		  {
			   Inventory(A).bHeldItem = true;
			   Inventory(A).Respawntime = 0.0;
		  }
	 }
	 if ( A != None )
	 {
		  A.event = Other.event;
		  A.tag = Other.tag;

		  // All that for this!
		  A.rotationRate = Other.rotationRate;

		  return true;
	 }

	 return false;
}

defaultproperties
{
    bRandomPlacement=True
    maxNumSLSpawns=2
    bRandomFuelNearKong=True
    bMaxAmmo=True
    randSpawnDist=1200
    randFuelNearKong=300
}
