//=============================================================================
// XShock.
//=============================================================================
//effects class...does no damage.//
//===============================//

#exec TEXTURE IMPORT NAME=AirTex FILE=Textures\AirTex.pcx GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=AirTex FILE=Textures\AirTex.pcx GROUP=Skins PALETTE=AirTex

class XShock extends Effects; 

simulated function PostBeginPlay()
{
	local Actor a;
	local vector hl, hn;

	super.PostBeginPlay();
	if ( !Level.bHighDetailMode || Level.bDropDetail )
		LightType = LT_None;

	a = trace(hl, hn, (location + vect(0, 0, -1) * 125), location, false);
	if (a != none) {
		// Set it on the ground. Looks stupid hovering!
		setLocation(hl);
		setRotation(rotator(hn) + rot(-16384, 0, 0));



    }
	loopAnim('rotate', 3.7);
}


simulated function Tick( float DeltaTime )
{
	local float ShockSize;

	ShockSize = 5.7/(ScaleGlow+0.05);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		ScaleGlow = (Lifespan/Default.Lifespan);
		AmbientGlow = ScaleGlow * 255;
		DrawScale = ShockSize;
	}
}

defaultproperties
{
    RemoteRole=2
    LifeSpan=0.40
    DrawType=2
    Style=3
    Texture=Texture'Skins.AirTex'
    Skin=Texture'Skins.AirTex'
    Mesh=SkeletalMesh'SLV2Models.thermo'
    AmbientGlow=255
    bUnlit=True
    LightType=1
    LightEffect=13
    LightBrightness=255
    LightHue=195
    LightRadius=6
}
