//=====================================================================
// RX6T4.
//      ""()Frgd()""
//               **Monarch**
//
//              555 ---===CrAzYBoNeS===--- 555
//			Boppolis_The_Dog
//
//
// Thank you Al McElrath for SLV2.
//=====================================================================
/** Ejected brass from firearms. Also the super cl_ass for similar
	objects.
*/
class EjectedBrass extends UT_ShellCase;


var() bool bLevel;				// Zero the pitch and roll on landing?
var() Sound landSound;			// Sound played on landing.
var() float sinktime;			// Time it takes to sinkout.
var() float sinkfudge;			// Sink height fudge factor.
var() int maxBounces;			// Don't bounce past this.
var() float noBounceChance;		// Chance we'll stop bouncing on any given hitWall().

var() bool bRandHitSound;
var() Sound hitSounds[10];		// Random hitsounds.
var() int num;					// # of hitsounds.


simulated function postBeginPlay() {
	if (level.bDropDetail && (level.netmode != NM_DedicatedServer) && (level.netmode != NM_ListenServer))
		lifeSpan = 1.5;
}


simulated function playHitSound() {
	local Sound s;

	if (bRandHitSound)
		s = hitSounds[rand(num)];
	else
		s = landSound;

	playSound(s, SLOT_Misc, 1.0);
}


simulated function hitWall(vector hn, Actor wall) {
	local vector realhn;

	if (level.bDropDetail) { // || numBounces > 3) {
		destroy();
	} else {
		if (bHasBounced && ((numBounces > maxBounces) || (frand() < noBounceChance))) // || (velocity.z > -50)))
			bBounce = false;

		numBounces++;
		if (!region.zone.bWaterZone)
			playHitSound();

		realhn = hn;
		hn = normal(hn + 0.4 * vrand());
		if ((hn dot realhn) < 0)
			hn *= -0.5;
		velocity = 0.5 * (velocity - 2 * hn * (velocity dot hn));
		randspin(spinRate());
		bHasBounced = true;
	}
}


simulated function float spinRate() {
	return (rand(100000) + 100000);
}


simulated function landed(vector hn) {
	local rotator r;

	if (level.bDropDetail || numBounces > 3) {
		destroy();
	} else {
		if (!region.zone.bWaterZone && landSound != none)
			playHitSound();

		setPhysics(PHYS_None);
		if (bLevel) {
			r = rotation;
			r.pitch = 0;
			r.roll = 0;
			setRotation(r);
		}

		if (lifespan > sinktime)
			setTimer(lifespan - sinktime, false);
		else
			gotoState('Sinkout');
	}
}


simulated function timer() {
	gotoState('Sinkout');
}


/** Rather than just disappearing or fading out, we sink into the
	ground.
*/
state Sinkout {
	simulated function beginState() {
		local float vish;
		local vector v;

		if (level.bDropDetail) {
			destroy();
			return;
		}

		rotationRate = rot(0, 0, 0);

		// The constant is a fudge factor. Er, not.
		vish = (collisionHeight + sinkfudge) * drawScale;
		v = location;
		v.z += vish;
		setLocation(v);
		v = vect(0, 0, 0);
		v.z = -vish;
		prePivot = v;

		bCollideWorld = false;
		setPhysics(PHYS_Projectile);

		// Fast enough to disappear before we are destroy()'ed.
		v = vect(0, 0, 0);
		v.z -= vish / lifespan;
		velocity = v;
	}
}



// end

defaultproperties
{
    bLevel=True
    landSound=Sound'SLV2Sounds.Weapon.brasshit1'
    sinktime=2.00
    sinkfudge=5.00
    maxBounces=3
    noBounceChance=0.50
    bRandHitSound=True
    HitSounds(0)=Sound'SLV2Sounds.Weapon.brasshit1'
    HitSounds(1)=Sound'SLV2Sounds.Weapon.brasshit2'
    HitSounds(2)=Sound'SLV2Sounds.Weapon.brasshit3'
    Num=3
    LifeSpan=6.00
    Mesh=SkeletalMesh'SLV2Models.brass'
    LightType=0
}
