//Done
class MEATWarheadLauncher extends TournamentWeapon;

#exec MESH IMPORT  MESH=WarHead ANIVFILE=MODELS\war_a.3D DATAFILE=MODELS\war_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WarHead X=0 Y=-210 Z=-50 YAW=64 PITCH=16  ROLL=-62
#exec MESH SEQUENCE MESH=WarHead SEQ=All         STARTFRAME=0   NUMFRAMES=35
#exec MESH SEQUENCE MESH=WarHead SEQ=Select      STARTFRAME=0   NUMFRAMES=15
#exec MESH SEQUENCE MESH=WarHead SEQ=Still       STARTFRAME=15  NUMFRAMES=1
#exec MESH SEQUENCE MESH=WarHead SEQ=Idle        STARTFRAME=15  NUMFRAMES=5
#exec MESH SEQUENCE MESH=WarHead SEQ=Down        STARTFRAME=20  NUMFRAMES=7
#exec MESH SEQUENCE MESH=WarHead SEQ=Fire        STARTFRAME=28  NUMFRAMES=7
#exec TEXTURE IMPORT NAME=Jwarhead1 FILE=Textures\Jwarhead1.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=Jwarhead2 FILE=Textures\Jwarhead2.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=Jwarhead3 FILE=Textures\Jwarhead3.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=Jwarhead4 FILE=Textures\Jwarhead4.bmp GROUP=Skins LODSET=2
#exec MESHMAP SCALE MESHMAP=WarHead X=0.006 Y=0.006 Z=0.012
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=0 TEXTURE=Jwarhead1
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=1 TEXTURE=Jwarhead2
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=2 TEXTURE=Jwarhead3
#exec MESHMAP SETTEXTURE MESHMAP=WarHead NUM=3 TEXTURE=Jwarhead4

#exec MESH IMPORT MESH=WHHand ANIVFILE=MODELS\WHpick_a.3D DATAFILE=MODELS\WHpick_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WHHand X=-150 Y=-110 Z=0 YAW=0 ROLL=-64
#exec MESH SEQUENCE MESH=WHHand SEQ=All         STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=WHHand SEQ=Still       STARTFRAME=0   NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=WHHand X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=WHHand NUM=1 TEXTURE=JWHPick1

#exec TEXTURE IMPORT NAME=IconWarH FILE=Textures\IconWarH.bmp GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UseWarH FILE=Textures\UseWarH.bmp GROUP="Icons" MIPS=OFF

//Custom import from here
#exec TEXTURE IMPORT NAME=Static_A00A FILE=TEXTURES\Static_A00A.bmp FLAGS=2 MIPS=OFF
#exec AUDIO IMPORT FILE="SOUNDS\umhdeemershot.wav" NAME="umhdeemershot" GROUP=Redeemer
#exec AUDIO IMPORT FILE="Sounds\WarheadPickupA.wav" NAME="WarheadPickupA" GROUP=Redeemer
#exec TEXTURE IMPORT NAME=MReticle FILE=TEXTURES\MReticle.bmp GROUP="Icons" FLAGS=2 MIPS=OFF

var PlayerPawn GuidingPawn;
var bool    bGuiding, bCanFire, bShowStatic, StartZoom, ToggleZoom, StopZoom, EndZoom, SetDesiredFOV;
var rotator StartRotation;

replication
{
   reliable if( bNetOwner && (Role==ROLE_Authority) )
      bGuiding, bShowStatic, StartZoom, ToggleZoom, StopZoom, EndZoom, SetDesiredFOV;
}

function SetWeaponStay()
{
   bWeaponStay = false;
}

simulated function PostRender( canvas Canvas )
{
   local int i, numReadouts, OldClipX, OldClipY;
   local float XScale;
   local PlayerPawn P;
   local float Scale;

   Super.PostRender(Canvas);
   P = PlayerPawn(Owner);
   if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
   {  
      bOwnsCrossHair = true;
      Scale = Canvas.ClipX/640;
      Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
      if ( Level.bHighDetailMode )
         Canvas.Style = ERenderStyle.STY_Translucent;
      else Canvas.Style = ERenderStyle.STY_Translucent;
      Canvas.DrawIcon(Texture'MReticle', Scale);
      Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
      Canvas.DrawColor.R = 0;
      Canvas.DrawColor.G = 255;
      Canvas.DrawColor.B = 0;
      Scale = P.DefaultFOV/P.DesiredFOV;
      Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
   }
   else bOwnsCrossHair = false;
}

function float RateSelf( out int bUseAltMode )
{
   local Pawn P, E;
   local Bot O;

   O = Bot(Owner);
   if ( (O == None) || (AmmoType.AmmoAmount <=0) || (O.Enemy == None) )
      return -2;

   bUseAltMode = 0;
   E = O.Enemy;

   for ( P=Level.PawnList; P!=None; P=P.NextPawn )
   if ( P.bIsPlayer && (P != O) && (P != E) && (!Level.Game.bTeamGame || (O.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team))
      && (VSize(E.Location - P.Location) < 650) && (!Level.Game.IsA('TeamGamePlus') || TeamGamePlus(Level.Game).PriorityObjective(O) < 2)
      && FastTrace(P.Location, E.Location) )
   {
      if ( VSize(E.Location - O.Location) > 500 )
         return 2.0;
      else return 1.0;
   }
   return 0.35;
}

function float SuggestAttackStyle()
{
   return -1.0;
}

simulated function PlayFiring()
{
//   Remove this comment section to prevent firing while spawn protection is on
//   if( Pawn(Owner).FindInventoryType(class'SpawnProtEffect') == None)
//        {
   PlayAnim( 'Fire', 0.3 );
   PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening);
//   }
}

function setHand(float Hand)
{
   if ( Hand == 2 )
   {
      bHideWeapon = true;
      return;
   }
   else bHideWeapon = false;

   PlayerViewOffset.Y = Default.PlayerViewOffset.Y;
   PlayerViewOffset.X = Default.PlayerViewOffset.X;
   PlayerViewOffset.Z = Default.PlayerViewOffset.Z;
   PlayerViewOffset *= 100;
}

function AltFire( float Value )
{
   ClientAltFire(Value);
}

simulated function bool ClientAltFire( float Value )
{
   GotoState('Zooming');
   return true;
}

State Finishing
{
   ignores Fire, AltFire;

   function BeginState()
   {
      bShowStatic = true;
   }
   Begin:
      Sleep(0.3);
      bShowStatic = false;
      Sleep(1.0);
      GotoState('Idle');
}

state Zooming
{
   simulated function Tick(float DeltaTime)
   {
      if ( Pawn(Owner).bAltFire == 0 )
      {
         PlayerPawn(Owner).StopZoom();
         SetTimer(0.0,False);
         GoToState('Idle');
      }
   }
   simulated function BeginState()
   {
      if ( Owner.IsA('PlayerPawn') )
      {
         if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
            PlayerPawn(Owner).ToggleZoom();
         SetTimer(0.2,True);
      }
      else
      {
         Pawn(Owner).bFire = 1;
         Pawn(Owner).bAltFire = 0;
         Global.Fire(0);
      }
   }
}

function Finish()
{
   if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
      Timer();
   Super.Finish();
}

function Fire( float Value )
{
    local Inventory Inv;

    if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }
    if ( AmmoType.UseAmmo(1) )
    {

        GotoState('NormalFire');
        bPointing=True;
        bCanClientFire = true;
        ClientFire(Value);
        if ( bRapidFire || (FiringSpeed > 0) )
            Pawn(Owner).PlayRecoil(FiringSpeed);
        if ( bInstantHit )
            TraceFire(0.0);
        else
            ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
   }
}

defaultproperties
{
   WeaponDescription="As if you need one."
   InstFlash=-0.40
   InstFog=(X=950.00,Y=650.00,Z=290.00),
   AmmoName=Class'MEATWarheadAmmo'
   ReloadCount=1
   PickupAmmoCount=1
   bWarnTarget=True
   bAltWarnTarget=True
   bSplashDamage=True
   bSpecialIcon=True
   FiringSpeed=1.00
   FireOffset=(X=0.00,Y=0.00,Z=0.00),
   ProjectileClass=Class'MEATWarShell'
   shakemag=350.00
   shaketime=0.20
   shakevert=7.50
   AIRating=1.00
   RefireRate=0.25
   AltRefireRate=0.25
   FireSound=Sound'Botpack.Redeemer.WarheadShot'
   SelectSound=Sound'Redeemer.WarheadPickupA'
   DeathMessage="%o was vaporized by %k's %w!!"
   NameColor=(R=255,G=128,B=128,A=0),
   AutoSwitchPriority=10
   InventoryGroup=10
   PickupMessage="You got the Seeking Deemer."
   ItemName="Seeking Deemer"
   RespawnTime=60.00
   PlayerViewOffset=(X=1.80,Y=1.00,Z=-1.89),
   PlayerViewMesh=LodMesh'Botpack.WarHead'
   BobDamping=0.98
   PickupViewMesh=LodMesh'Botpack.WHPick'
   ThirdPersonMesh=LodMesh'Botpack.WHHand'
   StatusIcon=Texture'Botpack.Icons.UseWarH'
   PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
   Icon=Texture'Botpack.Icons.UseWarH'
   Mesh=LodMesh'Botpack.WHPick'
   bNoSmooth=False
   CollisionRadius=45.00
   CollisionHeight=23.00
}