
class MEATWarShell extends Projectile config(RedeemerMania);

#exec MESH IMPORT MESH=missile ANIVFILE=MODELS\missile_a.3d DATAFILE=MODELS\missile_d.3d LODSTYLE=2
#exec MESH ORIGIN MESH=missile X=0 Y=0 Z=100 PITCH=192
#exec MESH SEQUENCE MESH=missile SEQ=All                      STARTFRAME=0 NUMFRAMES=100
#exec MESH SEQUENCE MESH=missile SEQ=missile                  STARTFRAME=0 NUMFRAMES=100
#exec MESHMAP NEW   MESHMAP=missile MESH=missile
#exec MESHMAP SCALE MESHMAP=missile X=0.1 Y=0.1 Z=0.2
#exec TEXTURE IMPORT NAME=Jmissile_01 FILE=Textures\Jmissile_01.bmp GROUP=Skins
#exec MESHMAP SETTEXTURE MESHMAP=missile NUM=1 TEXTURE=Jmissile_01 TLOD=30
#exec AUDIO IMPORT FILE="Sounds\WarFly.wav" NAME="WarFly" GROUP=Redeemer

var float CannonTimer, SmokeRate, TurnRate;
var redeemertrail trail;

var Actor Seeking;
var vector InitialDir;

//ADDS
var config int MissileSpeed;
var config int TurnRadius;

replication
{
   reliable if( Role==ROLE_Authority )
      Seeking, InitialDir, MissileSpeed, TurnRadius;
}

simulated function Timer()
{
   local ut_SpriteSmokePuff b;
   local vector x, y, z, SeekingDir;
   local float bestDist, bestAim, MagnitudeVel;
   local actor other;
   local Pawn p;

   Speed=MissileSpeed;

   if ( InitialDir == vect(0,0,0) )
      InitialDir = Normal(Velocity);

   if ( Trail == None )
      Trail = Spawn(class'RedeemerTrail',self);

   If (Seeking==None)
      bestAim = 1.00; //0.93

   if (Pawn(Seeking) != None && (Pawn(Seeking).Health <= 0 || Pawn(Seeking).bHidden))
      Seeking = None;

   If (Seeking != None  && Seeking != Instigator)
   {
      Pawn(Seeking).ReceiveLocalizedMessage( class'LockedMessage',, Pawn(Seeking).PlayerReplicationInfo, Pawn(Seeking).PlayerReplicationInfo );
      Instigator.ReceiveLocalizedMessage( class'MyLockedMessage',, Instigator.PlayerReplicationInfo, Instigator.PlayerReplicationInfo );

      SeekingDir = Normal(Seeking.Location - Location);
      if ( (SeekingDir Dot InitialDir) > 0 )
      {
         MagnitudeVel = VSize(Velocity);
         SeekingDir = Normal(SeekingDir * 1.2 * MagnitudeVel + Velocity);
         Velocity =  MagnitudeVel * SeekingDir;
         Acceleration = TurnRadius * SeekingDir;
         SetRotation(rotator(Velocity));
      }
   }
   CannonTimer += SmokeRate;
   if ( CannonTimer > 0.6 )
   {
      WarnCannons();
      CannonTimer -= 0.6;
   }
   if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
   {
      SetTimer(SmokeRate, false);
      Return;
   }
   if ( Level.bHighDetailMode )
   {
      if ( Level.bDropDetail )
         Spawn(class'LightSmokeTrail');
      else Spawn(class'UTSmokeTrail');
      SmokeRate = 152/Speed;
   }
   else
   {
      SmokeRate = 0.15;
      b = Spawn(class'ut_SpriteSmokePuff');
      b.RemoteRole = ROLE_None;
   }
   SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
   if ( Trail != None )
      Trail.Destroy();
   Super.Destroyed();
}

simulated function PostBeginPlay()
{
   SmokeRate = 0.3;
   SetTimer(0.3,false);
}

function WarnCannons()
{
   local Pawn P;

   for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
   if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
   {
      P.target = self;
      P.GotoState('TrackWarhead');
   }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, vector momentum, name damageType )
{
   if ( NDamage > 5 )
   {
      PlaySound(Sound'Expl03',,6.0);
      spawn(class'WarExplosion',,,Location);
      RemoteRole = ROLE_SimulatedProxy;
      Destroy();
   }
}

auto state Flying
{
   simulated function ZoneChange( Zoneinfo NewZone )
   {
      local waterring w;
      if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
      {
         w = Spawn(class'WaterRing',,,,rot(16384,0,0));
         w.DrawScale = 0.2;
         w.RemoteRole = ROLE_None;
      }
   }
   function ProcessTouch (Actor Other, Vector HitLocation)
   {
      if ( Other != instigator )
         Explode(HitLocation,Normal(HitLocation-Other.Location));
   }
   function Explode(vector HitLocation, vector HitNormal)
   {
      if ( Role < ROLE_Authority )
         return;

      HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );
      spawn(class'ShockWave',,,HitLocation+ HitNormal*16);
      RemoteRole = ROLE_SimulatedProxy;
      Destroy();
   }
   function BeginState()
   {
      local vector InitialDir,x,y,z;
      local vector SeekingDir;
      local float MagnitudeVel;
      local float bestDist, bestAim;
      local actor other;
      local Pawn p;

      Speed=MissileSpeed;

      initialDir = vector(Rotation);
      if ( Role == ROLE_Authority )
         Velocity = speed*initialDir;

      Acceleration = initialDir*50;

      If (Seeking==None)
      {
         bestAim = 1.00;//0.93
         Seeking = getTarget( 30000, Instigator.Location, vector(Rotation), Class'Pawn', 0.9995, True);
      }
   }
}

function actor getTarget( float Radius, vector Loc, vector Dir, optional class<Actor> classType, optional float periphericalFactor, optional bool getEnemyOnly)
{
   local Actor A, closerA;

   if (classType == None) classType = Class'Actor';

   ForEach VisibleCollidingActors(classType, A, FMax(Radius, 1.0))
   {
      if ((!getEnemyOnly || (getEnemyOnly && !isFriendlyPawn(Pawn(A)))) && (Normal(A.Location - Loc) dot Normal(Dir)) >= periphericalFactor
	  && (closerA == None || (VSize(A.Location - Loc) < VSize(closerA.Location - Loc))))
         closerA = A;
   }
   return closerA;
}

function bool isFriendlyPawn( Pawn P)
{
   if (P == None || Instigator == None)
      return False;
   if (P == Instigator)
      return True;
   if (ScriptedPawn(P) != None)
      return False;
   if (TeamGamePlus(Level.Game) != None && P.PlayerReplicationInfo != None && Instigator.PlayerReplicationInfo != None)
      return (P.PlayerReplicationInfo.Team == Instigator.PlayerReplicationInfo.Team);
   return False;
}

defaultproperties
{
   speed=MissileSpeed
   TurnRadius=100.00
   Damage=1000.00
   MomentumTransfer=100000
   MyDamageType=RedeemerDeath
   ExplosionDecal=Class'Botpack.NuclearMark'
   bNetTemporary=False
   RemoteRole=ROLE_SimulatedProxy
   AmbientSound=Sound'Botpack.Redeemer.WarFly'
   Mesh=LodMesh'Botpack.missile'
   AmbientGlow=78
   bUnlit=True
   SoundRadius=100
   SoundVolume=255
   CollisionRadius=7.00
   CollisionHeight=4.00
   bProjTarget=True
   bFixedRotationDir=True
   RotationRate=(Pitch=0,Yaw=0,Roll=20000),
   DesiredRotation=(Pitch=0,Yaw=0,Roll=30000),
}
