
class PostalBabesMusic extends AmbientSound;

#exec AUDIO IMPORT FILE="Sounds\crazytrain.WAV" NAME="crazytrain"
#exec AUDIO IMPORT FILE="Sounds\kickstart.WAV" NAME="kickstart"
#exec AUDIO IMPORT FILE="Sounds\welcometojungle.WAV" NAME="welcometojungle"

var byte MusicIndex;
var sound MusicSound[3];

replication
{
   reliable if ( Role == ROLE_Authority )
      MusicIndex;
}

function BeginPlay()
{
   MusicIndex = Rand(3);
   AmbientSound = MusicSound[MusicIndex];
   Super.BeginPlay();
}

simulated function PostNetBeginPlay()
{
   AmbientSound = MusicSound[MusicIndex];
}

function Reset()
{
   Destroy();
}

defaultproperties
{
   MusicSound(0)=Sound'crazytrain'
   MusicSound(1)=Sound'kickstart'
   MusicSound(2)=Sound'welcometojungle'
   bStatic=False
   bAlwaysRelevant=True
   SoundRadius=40
   SoundVolume=255
}
