//Done
class SniperWarheadLauncher extends TournamentWeapon;

var int Scroll;
var PlayerPawn GuidingPawn;
var bool    bGuiding, bCanFire, bShowStatic, StartZoom, ToggleZoom, StopZoom, EndZoom, SetDesiredFOV;
var rotator StartRotation;
var int ScrollCounter;    //These are to slow the alt fire HUD side scroll down
var int ScrollSpeed;      //Ditto

replication
{
   reliable if( bNetOwner && (Role==ROLE_Authority) )
      bGuiding, bShowStatic, StartZoom, ToggleZoom, StopZoom, EndZoom, SetDesiredFOV;
}

function SetWeaponStay()
{
   bWeaponStay = false;
}

simulated function PostRender( canvas Canvas )
{
   local int i, numReadouts, OldClipX, OldClipY;
   local float XScale;
   local PlayerPawn P;
   local float Scale;

   Super.PostRender(Canvas);
   P = PlayerPawn(Owner);
   if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
   {
      bOwnsCrossHair = true;
      Scale = Canvas.ClipX/640;
      Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
      if (Level.bHighDetailMode)
         Canvas.Style = ERenderStyle.STY_Translucent;
      else
         Canvas.Style = ERenderStyle.STY_Translucent;
      Canvas.DrawIcon(Texture'MReticle', Scale);
      Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
      Canvas.DrawColor.R = 0;
      Canvas.DrawColor.G = 255;
      Canvas.DrawColor.B = 0;
      Scale = P.DefaultFOV/P.DesiredFOV;
      Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
   }
   else bOwnsCrossHair = false;
}

function float RateSelf( out int bUseAltMode )
{
   local Pawn P, E;
   local Bot O;

   O = Bot(Owner);
   if ((O == None) || (AmmoType.AmmoAmount <=0) || (O.Enemy == None))
      return -2;

   bUseAltMode = 0;
   E = O.Enemy;

   for (P=Level.PawnList; P!=None; P=P.NextPawn)
   if (P.bIsPlayer && (P != O) && (P != E) && (!Level.Game.bTeamGame || (O.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team))
      && (VSize(E.Location - P.Location) < 650) && (!Level.Game.IsA('TeamGamePlus') || TeamGamePlus(Level.Game).PriorityObjective(O) < 2)
      && FastTrace(P.Location, E.Location))
   {
      if ( VSize(E.Location - O.Location) > 500 )
         return 2.0;
      else return 1.0;
   }
   return 0.35;
}

function float SuggestAttackStyle()
{
   return -1.0;
}

simulated function PlayFiring()
{

   PlayAnim( 'Fire', 0.3 );
   PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening);
}

function setHand(float Hand)
{
   if ( Hand == 2 )
   {
      bHideWeapon = true;
      return;
   }
   else bHideWeapon = false;

   PlayerViewOffset.Y = Default.PlayerViewOffset.Y;
   PlayerViewOffset.X = Default.PlayerViewOffset.X;
   PlayerViewOffset.Z = Default.PlayerViewOffset.Z;
   PlayerViewOffset *= 100;
}

function AltFire( float Value )
{
   ClientAltFire(Value);
}

simulated function bool ClientAltFire( float Value )
{
   GotoState('Zooming');
   return true;
}

State Finishing
{
   ignores Fire, AltFire;

   function BeginState()
   {
      bShowStatic = true;
   }
   Begin:
      Sleep(0.3);
      bShowStatic = false;
      Sleep(1.0);
      GotoState('Idle');
}

state Zooming
{
   simulated function Tick(float DeltaTime)
   {
      if ( Pawn(Owner).bAltFire == 0 )
      {
         PlayerPawn(Owner).StopZoom();
         SetTimer(0.0,False);
         GoToState('Idle');
      }
   }
   simulated function BeginState()
   {
      if ( Owner.IsA('PlayerPawn') )
      {
         if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
            PlayerPawn(Owner).ToggleZoom();
         SetTimer(0.2,True);
      }
      else
      {
         Pawn(Owner).bFire = 1;
         Pawn(Owner).bAltFire = 0;
         Global.Fire(0);
      }
   }
}

function Finish()
{
   if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
      Timer();
   Super.Finish();
}

function Fire( float Value )
{
    local Inventory Inv;

    if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }
    if ( AmmoType.UseAmmo(1) )
    {
        GotoState('NormalFire');
        bPointing=True;
        bCanClientFire = true;
        ClientFire(Value);
        if ( bRapidFire || (FiringSpeed > 0) )
            Pawn(Owner).PlayRecoil(FiringSpeed);
        if ( bInstantHit )
            TraceFire(0.0);
        else
            ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
  }
}

defaultproperties
{
   ScrollSpeed=3
   WeaponDescription="Classification: Thermonuclear Device\n\nPrimary Fire: Launches a huge yet slow moving missile that, upon striking a solid surface, will explode and send out a gigantic shock wave, instantly pulverizing anyone or anything within its colossal radius, including yourself.\n\nSecondary Fire: Take control of the missile and fly it anywhere.  You can press the primary fire button to explode the missile early.\n\nTechniques: Remember that while this rocket is being piloted you are a sitting duck.  If an opponent manages to hit your incoming Redeemer missile while it's in the air, the missile will explode harmlessly."
   InstFlash=-0.40
   InstFog=(X=950.00,Y=650.00,Z=290.00),
   AmmoName=Class'SniperWarheadAmmo'
   ReloadCount=1
   PickupAmmoCount=1
   bWarnTarget=True
   bAltWarnTarget=True
   bSplashDamage=True
   bSpecialIcon=True
   FiringSpeed=1.00
   FireOffset=(X=18.00,Y=0.00,Z=-10.00),
   ProjectileClass=Class'SniperWarShell'
   shakemag=350.00
   shaketime=0.20
   shakevert=7.50
   AIRating=1.00
   RefireRate=0.25
   AltRefireRate=0.25
   FireSound=Sound'Botpack.Redeemer.WarheadShot'
   SelectSound=Sound'Redeemer.WarheadPickupA'
   DeathMessage="%o was vaporized by %k's %w!!"
   NameColor=(R=255,G=128,B=128,A=0),
   AutoSwitchPriority=10
   InventoryGroup=10
   PickupMessage="You got the Sniper Deemer."
   ItemName="SniperDeemer"
   RespawnTime=60.00
   PlayerViewOffset=(X=1.80,Y=1.00,Z=-1.89),
   PlayerViewMesh=LodMesh'Botpack.WarHead'
   BobDamping=0.98
   PickupViewMesh=LodMesh'Botpack.WHPick'
   ThirdPersonMesh=LodMesh'Botpack.WHHand'
   StatusIcon=Texture'Botpack.Icons.UseWarH'
   PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
   Icon=Texture'Botpack.Icons.UseWarH'
   Mesh=LodMesh'Botpack.WHPick'
   bNoSmooth=False
   CollisionRadius=45.00
   CollisionHeight=23.00
}