class goGuidedWarShell extends goWarShell config(RedeemerMania);

#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2

var Pawn Guider;
var rotator OldGuiderRotation, GuidedRotation;
var float CurrentTimeStamp, LastUpdateTime,ClientBuffer,ServerUpdate;
var bool bUpdatePosition;
var bool bDestroyed;

var SavedMove SavedMoves;
var SavedMove FreeMoves;

var vector RealLocation, RealVelocity;
var int d;

//Add
var() config bool bHideSpectatorBeacons;
var Texture TeamBeaconIcon;
var color BeaconColor;
var color GreenColor;

replication
{
    // Things the server should send to the client.
    unreliable if( Role==ROLE_Authority )
        ClientAdjustPosition, bDestroyed;
    unreliable if ( Role==ROLE_Authority && bNetOwner && bNetInitial )
        GuidedRotation, OldGuiderRotation;
    unreliable if( Role==ROLE_Authority && !bNetOwner )
        RealLocation, RealVelocity;
    unreliable if( Role==ROLE_AutonomousProxy )
        ServerMove;
}

simulated function Timer()
{
    local ut_SpriteSmokePuff b;
    local float SmokeRate;

    if ( (Role == ROLE_Authority) && (Level.TimeSeconds - ServerUpdate > 4) )
    {
        Explode(Location,Vect(0,0,1));
        return;
    }

    if ( Trail == None )
        Trail = Spawn(class'RedeemerTrail',self);

    CannonTimer += SmokeRate;
    if ( CannonTimer > 0.6 )
    {
        WarnCannons();
        CannonTimer -= 0.6;
    }

    if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
    {
        SetTimer(SmokeRate, false);
        Return;
    }

    if ( Level.bHighDetailMode )
    {
        if ( Level.bDropDetail )
            SmokeRate = 0.07;
        else
            SmokeRate = 0.02; 
    }
    else 
    {
        SmokeRate = 0.15;
    }
    b = Spawn(class'ut_SpriteSmokePuff');
    b.RemoteRole = ROLE_None;
    SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
    local goWarheadLauncher W;

    bDestroyed = true;
    if ( (PlayerPawn(Guider) != None) )
        PlayerPawn(Guider).ViewTarget = None;

    While ( FreeMoves != None )
    {
        FreeMoves.Destroy();
        FreeMoves = FreeMoves.NextMove;
    }

    While ( SavedMoves != None )
    {
        SavedMoves.Destroy();
        SavedMoves = SavedMoves.NextMove;
    }

    if ( (Guider != None) && (Level.NetMode != NM_Client) )
    {
        W = goWarheadLauncher(Guider.FindInventoryType(class'goWarheadLauncher'));
        if ( W != None )
        {
            W.GuidedShell = None;
            W.GotoState('Finishing');
        }
    }
    Super.Destroyed();
}

simulated function Tick(float DeltaTime)
{
    local int DeltaYaw, DeltaPitch;
    local int YawDiff, PitchDiff;
    local SavedMove NewMove;

    if ( Level.NetMode == NM_Client )
    {
        if ( (PlayerPawn(Instigator) != None) && (ViewPort(PlayerPawn(Instigator).Player) != None) )
        {
            Guider = Instigator;
            if ( bDestroyed || (Instigator.health < 0) )
            {
                PlayerPawn(Instigator).ViewTarget = None;
                Destroy();
                if ( Instigator.Weapon.IsA('goWarheadLauncher') )
                    goWarheadLauncher(Instigator.Weapon).bGuiding = false;
                return;
            }
            PlayerPawn(Instigator).ViewTarget = self;
            if ( Instigator.Weapon.IsA('goWarheadLauncher') )
            {
                goWarheadLauncher(Instigator.Weapon).GuidedShell = self;
                goWarheadLauncher(Instigator.Weapon).bGuiding = true;
            }
        }
        else
        {
            if ( RealLocation != vect(0,0,0) )
            {
                SetLocation(RealLocation);
                RealLocation = vect(0,0,0);
            }
            if ( RealVelocity != vect(0,0,0) )
            {
                Velocity = RealVelocity;
                SetRotation(rotator(Velocity));
                RealVelocity = vect(0,0,0);
            }
            return;
        }
    }
    else if ( (Level.NetMode != NM_Standalone) && (RemoteRole == ROLE_AutonomousProxy) ) 
            return;

    // if server updated client position, client needs to replay moves after the update
    if ( bUpdatePosition )
        ClientUpdatePosition();

    DeltaYaw = (Guider.ViewRotation.Yaw & 65535) - (OldGuiderRotation.Yaw & 65535);
    DeltaPitch = (Guider.ViewRotation.Pitch & 65535) - (OldGuiderRotation.Pitch & 65535);
    if ( DeltaPitch < -32768 )
        DeltaPitch += 65536;
    else if ( DeltaPitch > 32768 )
        DeltaPitch -= 65536;
    if ( DeltaYaw < -32768 )
        DeltaYaw += 65536;
    else if ( DeltaYaw > 32768 )
        DeltaYaw -= 65536;

    YawDiff = (Rotation.Yaw & 65535) - (GuidedRotation.Yaw & 65535) - DeltaYaw;
    if ( DeltaYaw < 0 )
    {
        if ( ((YawDiff > 0) && (YawDiff < 16384)) || (YawDiff < -49152) )
            GuidedRotation.Yaw += DeltaYaw;
    }   
    else if ( ((YawDiff < 0) && (YawDiff > -16384)) || (YawDiff > 49152) )
        GuidedRotation.Yaw += DeltaYaw;

    GuidedRotation.Pitch += DeltaPitch;
    OldGuiderRotation = Guider.ViewRotation;
    if ( Role == ROLE_AutonomousProxy )
    {
        // Send the move to the server
        // skip move if too soon
        if ( ClientBuffer < 0 )
        {
            ClientBuffer += DeltaTime;
            MoveRocket(DeltaTime, Velocity, GuidedRotation);
            return;
        }
        else
            ClientBuffer = ClientBuffer + DeltaTime - 80.0/PlayerPawn(Instigator).Player.CurrentNetSpeed;

        // I'm  a client, so I'll save my moves in case I need to replay them
        // Get a SavedMove actor to store the movement in.
        if ( SavedMoves == None )
        {
            SavedMoves = GetFreeMove();
            NewMove = SavedMoves;
        }
        else
        {
            NewMove = SavedMoves;
            while ( NewMove.NextMove != None )
                NewMove = NewMove.NextMove;
            NewMove.NextMove = GetFreeMove();
            NewMove = NewMove.NextMove;
        }

        NewMove.TimeStamp = Level.TimeSeconds;
        NewMove.Delta = DeltaTime;
        NewMove.Velocity = Velocity;
        NewMove.SetRotation(GuidedRotation);

        MoveRocket(DeltaTime, Velocity, GuidedRotation);
        ServerMove(Level.TimeSeconds, Location, NewMove.Rotation.Pitch, NewMove.Rotation.Yaw);
        return;
    }
    MoveRocket(DeltaTime, Velocity, GuidedRotation);
}

simulated function ClientAdjustPosition
(
    float TimeStamp, 
    float NewLocX, 
    float NewLocY, 
    float NewLocZ, 
    float NewVelX, 
    float NewVelY, 
    float NewVelZ
)
{
    local vector NewLocation;

    if ( CurrentTimeStamp > TimeStamp )
        return;
    CurrentTimeStamp = TimeStamp;

    NewLocation.X = NewLocX;
    NewLocation.Y = NewLocY;
    NewLocation.Z = NewLocZ;
    Velocity.X = NewVelX;
    Velocity.Y = NewVelY;
    Velocity.Z = NewVelZ;

    SetLocation(NewLocation);

    bUpdatePosition = true;
}

// Client calls this to replay moves after getting its position updated by the server
simulated function ClientUpdatePosition()
{
    local SavedMove CurrentMove;
    local int realbRun, realbDuck;
    local bool bRealJump;

    bUpdatePosition = false;
    CurrentMove = SavedMoves;
    while ( CurrentMove != None )
    {
        if ( CurrentMove.TimeStamp <= CurrentTimeStamp )
        {
            SavedMoves = CurrentMove.NextMove;
            CurrentMove.NextMove = FreeMoves;
            FreeMoves = CurrentMove;
            FreeMoves.Clear();
            CurrentMove = SavedMoves;
        }
        else
        {
            MoveRocket(CurrentMove.Delta, CurrentMove.Velocity, CurrentMove.Rotation);
            CurrentMove = CurrentMove.NextMove;
        }
    }
}
    
// server moves the rocket based on clients input, and compares the resultant location to the client's view of the location
function ServerMove(float TimeStamp, vector ClientLoc, int Pitch, int Yaw)
{
    local float ClientErr, DeltaTime;
    local vector LocDiff;

    if ( CurrentTimeStamp >= TimeStamp )
        return;

    if ( CurrentTimeStamp > 0 )
        DeltaTime = TimeStamp - CurrentTimeStamp;
    CurrentTimeStamp = TimeStamp;
    GuidedRotation.Pitch = Pitch;
    GuidedRotation.Yaw = Yaw;
    if ( DeltaTime > 0 )    
        MoveRocket(DeltaTime, Velocity, GuidedRotation);
    if ( Level.TimeSeconds - LastUpdateTime > 0.3 )
    {
        ClientErr = 10000;
    }
    else if ( Level.TimeSeconds - LastUpdateTime > 0.07 )
    {
        LocDiff = Location - ClientLoc;
        ClientErr = LocDiff Dot LocDiff;
    }

    // If client has accumulated a noticeable positional error, correct him.
    if ( ClientErr > 3 )
    {
        LastUpdateTime = Level.TimeSeconds;
        ClientAdjustPosition(TimeStamp, Location.X, Location.Y, Location.Z, Velocity.X, Velocity.Y, Velocity.Z);
    }
}

simulated function MoveRocket(float DeltaTime, vector CurrentVelocity, rotator GuideRotation )
{
    local int OldRoll, RollMag;
    local rotator NewRot;
    local float SmoothRoll;
    local vector OldVelocity, X,Y,Z;

    if ( (Role == ROLE_Authority) && ( (Guider == None) || (Guider.Health <= 0)
                || (Guider.IsA('PlayerPawn') && (PlayerPawn(Guider).ViewTarget != self)) || Guider.IsInState('FeigningDeath')) )
    {
        Explode(Location,Vect(0,0,1));
        return;
    }

    ServerUpdate = Level.TimeSeconds;
    OldRoll = Rotation.Roll & 65535;
    OldVelocity = CurrentVelocity;
    Velocity = CurrentVelocity + Vector(GuideRotation) * 1500 * DeltaTime;
    Velocity = Normal(Velocity) * 850; //was 550
    NewRot = Rotator(Velocity);

    // Roll Warhead based on acceleration
    GetAxes(NewRot, X,Y,Z);
    RollMag = int(10 * (Y Dot (Velocity - OldVelocity))/DeltaTime);
    if ( RollMag > 0 ) 
        NewRot.Roll = Min(12000, RollMag); 
    else
        NewRot.Roll = Max(53535, 65536 + RollMag);

    //smoothly change rotation
    if (NewRot.Roll > 32768)
    {
        if (OldRoll < 32768)
            OldRoll += 65536;
    }
    else if (OldRoll > 32768)
        OldRoll -= 65536;

    SmoothRoll = FMin(1.0, 5.0 * deltaTime);
    NewRot.Roll = NewRot.Roll * SmoothRoll + OldRoll * (1 - SmoothRoll);
    SetRotation(NewRot);

    if ( (Level.NetMode != NM_Standalone)
        && ((Level.NetMode != NM_ListenServer) || (Instigator == None) 
            || (Instigator.IsA('PlayerPawn') && (PlayerPawn(Instigator).Player != None)
                && (ViewPort(PlayerPawn(Instigator).Player) == None))) )
        AutonomousPhysics(DeltaTime);

    if ( Role == ROLE_Authority )
    {
        RealLocation = Location;
        RealVelocity = Velocity;
    }
}

simulated function PostRender( canvas Canvas )
{
   local Pawn thisPawn;
   local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
   local rotator CamRot;
   local Actor Camera;
   local float BaseBeaconScale, BeaconScale, Dist, DistScale;
   local float TanFOVx, TanFOVy;
   local float TanX, TanY;
   local float dx, dy, FontY;
   local string BeaconText;
   
   Canvas.Style = ERenderStyle.STY_Masked;

   if (Canvas.ClipX > 1024)
      Canvas.Font = Font'BeaconNameFontLarge';
   else if (Canvas.ClipX > 640)
      Canvas.Font = Font'BeaconNameFontMedium';
   else
      Canvas.Font = Font'BeaconNameFontSmall';
	
   Canvas.SetPos(0, 0);
   Canvas.TextSize("X", dx, FontY);
   BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;

   Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

   TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559);
   TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
   GetAxes(CamRot, X, Y, Z);

   Canvas.bNoSmooth = False;
   Canvas.Style = ERenderStyle.STY_Masked;
   foreach AllActors(class'Pawn', thisPawn)
   {
      if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden)
      {
         TargetDir = thisPawn.Location - CamLoc;
	 Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
	 TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
	 DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);
	 d = Dist;

	 if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(thisPawn.Location, CamLoc) || FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc)))
         {
	    BeaconScale = BaseBeaconScale * DistScale;
	    Dir = X * (X dot TargetDir);
	    XY = TargetDir - Dir;

	    dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
	    dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));

	    Canvas.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);

	    if (DistScale <= 1.0)
            {
	       if (Canvas.ClipX > 600)
		  BeaconText = "" $ d $ "";

	       Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
	       Canvas.DrawTextClipped(BeaconText, False);
         Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
	       Canvas.DrawTextClipped(BeaconText, False);
            }
         }
      }
   }
}

simulated function SavedMove GetFreeMove()
{
    local SavedMove s;

    if ( FreeMoves == None )
        return Spawn(class'SavedMove');
    else
    {
        s = FreeMoves;
        FreeMoves = FreeMoves.NextMove;
        s.NextMove = None;
        return s;
    }   
}

auto state Flying
{
    function BeginState()
    {
        ServerUpdate = Level.TimeSeconds;
        GuidedRotation = Rotation;
        OldGuiderRotation = Rotation;
        Velocity = speed*vector(Rotation);
        Acceleration = vect(0,0,0);
        if ( (Level.NetMode != NM_Standalone) && (Role == ROLE_Authority) )
        {
            if ( (PlayerPawn(Instigator) != None) 
                && (ViewPort(PlayerPawn(Instigator).Player) != None) )
                RemoteRole = ROLE_SimulatedProxy;
            else
                RemoteRole = ROLE_AutonomousProxy;
        }
    }
}

defaultproperties
{
   bFixedRotationDir=True
   RotationRate=(Pitch=0,Yaw=0,Roll=0)
   DesiredRotation=(Pitch=0,Yaw=0,Roll=0)
   TeamBeaconIcon=Texture'TeamBeacon2'
   BeaconColor=(R=0,G=150,B=0,A=0)
   GreenColor=(R=0,G=255,B=0,A=0)
}
