
class goWarheadLauncher extends WarheadLauncher;

var goGuidedWarShell GuidedShell;
var int Scroll;
var PlayerPawn GuidingPawn;
var bool    bGuiding, bCanFire, bShowStatic;
var rotator StartRotation;
var int ScrollCounter;    //These are to slow the side scroll down
var int ScrollSpeed;      //Ditto

replication
{
    // Things the server should send to the client.
    reliable if( bNetOwner && (Role==ROLE_Authority) )
        bGuiding, bShowStatic;
}

simulated function PostBeginPlay()   //Added to slow the scrolling of the alt-fire text
{
	super.PostBeginPlay();

	ScrollCounter = 0;
}

function SetWeaponStay()
{
    bWeaponStay = false; // redeemer never stays
}

simulated function PostRender( canvas Canvas )

{
    local int i, numReadouts, OldClipX, OldClipY;
    local float XScale;
    if(PlayerPawn(Owner) == None)
	return;

    bOwnsCrossHair = ( bGuiding || bShowStatic );

    if ( !bGuiding )
    {
        if ( !bShowStatic )
            return;

        Canvas.SetPos( 0, 0);
        Canvas.Style = ERenderStyle.STY_Normal;
        Canvas.DrawIcon(Texture'Static_A00A', FMax(Canvas.ClipX, Canvas.ClipY)/256.0);

        if ( Owner.IsA('PlayerPawn') )
            PlayerPawn(Owner).ViewTarget = None;
        return;
    }
    if(GuidedShell != None)
    GuidedShell.PostRender(Canvas);
    OldClipX = Canvas.ClipX;
    OldClipY = Canvas.ClipY;
    XScale = FMax(0.5, int(Canvas.ClipX/640.0));
    Canvas.SetPos( 0.5 * OldClipX - 128 * XScale, 0.5 * OldClipY - 128 * XScale );
    if ( Level.bHighDetailMode )
        Canvas.Style = ERenderStyle.STY_Translucent;
    else
        Canvas.Style = ERenderStyle.STY_Normal;
    Canvas.DrawIcon(Texture'GuidedX', XScale);

    numReadouts = OldClipY/128 + 2;
    for ( i = 0; i < numReadouts; i++ )
    { 
        Canvas.SetPos(1,Scroll + i * 128);

        ScrollCounter++;         //Apdate to the scroll speed. Set in def props
	if(ScrollCounter == ScrollSpeed) 
	{
		Scroll--;
		ScrollCounter = 0;
	}

	if ( Scroll < -128 )
	{
            Scroll = 0;
	}

        Canvas.DrawIcon(Texture'Readout', 1.0);
    }
}

function float RateSelf( out int bUseAltMode )
{
    local Pawn P, E;
    local Bot O;

    O = Bot(Owner);
    if ( (O == None) || (AmmoType.AmmoAmount <=0) || (O.Enemy == None) )
        return -2;

    bUseAltMode = 0;
    E = O.Enemy;

    for ( P=Level.PawnList; P!=None; P=P.NextPawn )
        if ( P.bIsPlayer && (P != O) && (P != E)
            && (!Level.Game.bTeamGame || (O.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team))
            && (VSize(E.Location - P.Location) < 650) 
            && (!Level.Game.IsA('TeamGamePlus') || TeamGamePlus(Level.Game).PriorityObjective(O) < 2)
            && FastTrace(P.Location, E.Location) )
        {
            if ( VSize(E.Location - O.Location) > 500 )
                return 2.0;
            else
                return 1.0;
        }

    return 0.35;
}

// return delta to combat style
function float SuggestAttackStyle()
{
    return -1.0;
}

simulated function PlayFiring()
{
    PlayAnim( 'Fire', 0.3 );        
    PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening);
}

function setHand(float Hand)
{
    if ( Hand == 2 )
    {
        bHideWeapon = true;
        return;
    }
    else
        bHideWeapon = false;

    PlayerViewOffset.Y = Default.PlayerViewOffset.Y;
    PlayerViewOffset.X = Default.PlayerViewOffset.X;
    PlayerViewOffset.Z = Default.PlayerViewOffset.Z;
    PlayerViewOffset *= 100;
}

function AltFire( float Value )
{
    if ( !Owner.IsA('PlayerPawn') )
    {
        Fire(Value);
        return;
    }

    if (AmmoType.UseAmmo(1))
    {
        PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
        bPointing=True;
        Pawn(Owner).PlayRecoil(FiringSpeed);
        PlayFiring();
        GuidedShell = goGuidedWarShell(ProjectileFire(AltProjectileClass, ProjectileSpeed, bWarnTarget));
        GuidedShell.SetOwner(Owner);
        PlayerPawn(Owner).ViewTarget = GuidedShell;
        GuidedShell.Guider = PlayerPawn(Owner);
        ClientAltFire(0);
        GotoState('Guiding');
    }
}

simulated function bool ClientAltFire( float Value )
{
    if ( bCanClientFire && ((Role == ROLE_Authority) || (AmmoType == None) || (AmmoType.AmmoAmount > 0)) )
    {
        if ( Affector != None )
            Affector.FireEffect();
        PlayOwnedSound(FireSound, SLOT_None,4.0*Pawn(Owner).SoundDampening);
        return true;
    }
    return false;
}

State Guiding
{
    function Fire ( float Value )
    {
        if ( !bCanFire )
            return;
        if ( GuidedShell != None )
            GuidedShell.Explode(GuidedShell.Location,Vect(0,0,1));
        bCanClientFire = true;

        GotoState('Finishing');
    }

    function AltFire ( float Value )
    {
        Fire(Value);
    }

    function BeginState()
    {
        Scroll = 0;
        bGuiding = true;
        bCanFire = false;
        if ( Owner.IsA('PlayerPawn') )
        {
            GuidingPawn = PlayerPawn(Owner);
            StartRotation = PlayerPawn(Owner).ViewRotation;
            PlayerPawn(Owner).ClientAdjustGlow(-0.2,vect(200,0,0));
        }
    }

    function EndState()
    {
        bGuiding = false;
        if ( GuidingPawn != None )
        {
            GuidingPawn.ClientAdjustGlow(0.2,vect(-200,0,0));
            GuidingPawn.ClientSetRotation(StartRotation);
            GuidingPawn = None;
        }
    }


Begin:
    Sleep(1.0);
    bCanFire = true;
}

State Finishing
{
    ignores Fire, AltFire;

    function BeginState()
    {
        bShowStatic = true;
    }

Begin:
    Sleep(0.3);
    bShowStatic = false;
    Sleep(1.0);
    GotoState('Idle');
}

defaultproperties
{
     ScrollSpeed=3
     AmmoName=Class'RedeemerMania.goWarheadAmmo'
     ProjectileClass=Class'RedeemerMania.goWarShell'
     AltProjectileClass=Class'RedeemerMania.goGuidedWarShell'
}
