
class LongShot extends mutator config(RewardMod);

var MediaLoader Loaded;
var config int SLShot;
var config int LShot;
var config int LSDist, SLSDist;
var config int LongShotMaxHealth;

simulated event PreBeginPlay()
{
	//This is for loading the dynamic sounds that can 
	//be assigned in the ini file
	Loaded = Spawn(class 'MediaLoader');
   Loaded.MediaLoad();
   super.prebeginplay();
}

function ScoreKill(pawn Killer, pawn Other)
{
   local vector hitloc, hitnormal;
	Super.ScoreKill(Killer, Other);

   if(Other != Killer && Killer!=None  && (Other.IsA('PlayerPawn') || Other.IsA('Bot')) && (Killer.IsA('PlayerPawn') || Killer.IsA('Bot')))
   {
		// check for distance kill
		if (VSize(Killer.Location - Other.Location) > SLSDist)
		{
			Killer.Health += SLShot;
			if ( Killer.Health > LongShotMaxHealth )
			{
				 Killer.Health = LongShotMaxHealth;
			}
			PlayerPawn(Killer).ReceiveLocalizedMessage(class'SuperLongShot');
			PlayerPawn(Killer).ClientPlaySound( Loaded.sndSLSound,true,true);
		}
		else if (VSize(Killer.Location - Other.Location) > LSDist)
		{
			Killer.Health += LShot;
         if ( Killer.Health > LongShotMaxHealth )
			{
				 Killer.Health = LongShotMaxHealth;
			}
			PlayerPawn(Killer).ReceiveLocalizedMessage(class'LongShotMess');
			PlayerPawn(Killer).ClientPlaySound(Loaded.sndLSound,true,true);
		}
  	}
}

defaultproperties
{
   SLShot=20
   LShot=10
   LSDist=5000
   SLSDist=7000
   LongShotMaxHealth=199
}
