
class UTmod expands Mutator config(RewardMod);

var config bool bInit, bDropWeapons, bTranslucentBodies, bHeadShotBonus, 
	bUseLongeRangeBonus, bUseTombstones, bUseRandomAwards;

var config int HealthBonus, MaxHealth, AmmoBonus, FragBonus;

function PreBeginPlay ()
{
	if ( bInit )
		return;

	Super.PreBeginPlay();

	//This class monitors the shot distance for awards
	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'LongShot'));

	bInit = True;

	if ( NextMutator != None )
		NextMutator.PreBeginPlay();
}

function PostBeginPlay()
{
	//We are using timer to monitor the lifetime
	//of the tombstones.
   SetTimer(0.1, True);

   if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

function Timer()
{
   local Pawn P;

   Super.Timer();
   //countdown LifeTime of Tombstones
   CyclePickups();
}

simulated function bool AlwaysKeep(Actor Other)
{
	//This makes all carcass render as see-through
	if ( bTranslucentBodies && Other.IsA('Carcass') )
	{
		Carcass(Other).Style=STY_Translucent;
	}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

//I used PreventDeath because I just like to use this function for mods like this. Other
//ways are just as correct.
function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	local actor dropped;
	local float speed;
	local inventory inv;
	local weapon weap;
	local int X;

//Headshot bonus
	if ( bHeadShotBonus )
	{
		if ( damageType == 'Decapitated' )
		{
			Killer.Health += HealthBonus;

			if ( Killer.Health > MaxHealth )
			{
				 Killer.Health = MaxHealth;
			}
			Killer.PlayerReplicationInfo.Score += FragBonus;
			Killer.Weapon.AmmoType.AmmoAmount += AmmoBonus;

			if ( Killer.Weapon.AmmoType.AmmoAmount > Killer.Weapon.AmmoType.MaxAmmo )
			{
				Killer.Weapon.AmmoType.AmmoAmount = Killer.Weapon.AmmoType.MaxAmmo;
			}
			if ( Level.Game.bTeamGame && Level.Game.Class != class'Botpack.CTFGame')
			{
				TeamGamePlus(Level.Game).Teams[Killer.PlayerReplicationInfo.Team].Score += FragBonus;
			}
		}
	}

//Drop weapons on death
	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
	{
		if ( bDropWeapons && inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('ChainSaw') && !inv.IsA('Translocator') )
		{
			weap = Weapon(inv);

			//spawn inventory item to world:
			dropped = Spawn(weap.Class,,,Killed.Location);
			speed = VSize(Killed.Velocity);
			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
dropped.Lifespan = 10;
			weap = Weapon(dropped);
			weap.PickupAmmoCount = weap.default.PickupAmmoCount;

			if ( weap != None )
			{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
			}
		}
		Killed.Inventory.Destroy();
	}

//Tombstones
	if ( bUseTombstones )
		if ( Killed != none)
     		DropSoul(Killed, Killer);

//Generic random awards
	if ( bUseRandomAwards )
		if ( Killed != none)
			if (FRand()<0.1)
				DropRandomAward(Killed, Killer);

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

//Handles the tombstone creation and drop
function DropSoul(Pawn Other, Pawn Killer)
{
   local Pickup_Soul DropItem;

   if ((Other != none) && (Killer !=none))
   {
      DropItem = Spawn(Class'Pickup_Soul',,,Other.Location);
      DropItem.Claimer = Killer.PlayerReplicationInfo.PlayerName;
      DropItem.Claimed = Other.PlayerReplicationInfo.PlayerName;
      DropItem.DrawScale = 0.75;
      DropItem.RemoteRole = ROLE_DumbProxy;
      DropItem.SetPhysics(PHYS_Falling);
      DropItem.bCollideWorld = true;
      DropItem.RespawnTime = 0.0;
      DropItem.bRotatingPickup = False;
   }
}

//Handles the destroying of the tombstones if ungrabbed
function CyclePickups()
{
   local Pickup_Soul U;

   ForEach AllActors(class'Pickup_Soul', U)
   {
          U.LifeTime--;
          if ( U.LifeTime < 0 )
          {
              spawn(class'UT_SpriteSmokePuff',,,U.Location);
              U.Destroy();
          }
    }
}

//Creates a random award 10% of the time on kills
function DropRandomAward(Pawn Other, Pawn Killer)
{
   local HealthPack DropItem1;
   local UT_ShieldBelt DropItem2;
   local Armor2 DropItem3;
   local UDamage DropItem4;
   local UT_JumpBoots DropItem5;
   local int randm;

   if ((Other != none) && (Killer !=none))
   {
   	randm = Rand(5);
      switch(randm)
      {
	    	case 0:
      	DropItem1 = Spawn(Class'HealthPack',,,Other.Location);
      	DropItem1.RemoteRole = ROLE_DumbProxy;
      	DropItem1.SetPhysics(PHYS_Falling);
      	DropItem1.bCollideWorld = true;
      	DropItem1.RespawnTime = 0.0;
      	DropItem1.bRotatingPickup = False;
      	Break;
      	case 1:
      	DropItem2 = Spawn(Class'UT_ShieldBelt',,,Other.Location);
      	DropItem2.RemoteRole = ROLE_DumbProxy;
      	DropItem2.SetPhysics(PHYS_Falling);
      	DropItem2.bCollideWorld = true;
      	DropItem2.RespawnTime = 0.0;
      	DropItem2.bRotatingPickup = False;
      	Break;
      	case 2:
      	DropItem3 = Spawn(Class'Armor2',,,Other.Location);
      	DropItem3.RemoteRole = ROLE_DumbProxy;
      	DropItem3.SetPhysics(PHYS_Falling);
      	DropItem3.bCollideWorld = true;
      	DropItem3.RespawnTime = 0.0;
      	DropItem3.bRotatingPickup = False;
      	Break;
      	case 3:
      	DropItem4 = Spawn(Class'UDamage',,,Other.Location);
      	DropItem4.RemoteRole = ROLE_DumbProxy;
      	DropItem4.SetPhysics(PHYS_Falling);
      	DropItem4.bCollideWorld = true;
      	DropItem4.RespawnTime = 0.0;
      	DropItem4.bRotatingPickup = False;
      	Break;
      	case 4:
      	DropItem5 = Spawn(Class'UT_JumpBoots',,,Other.Location);
      	DropItem5.RemoteRole = ROLE_DumbProxy;
      	DropItem5.SetPhysics(PHYS_Falling);
      	DropItem5.bCollideWorld = true;
      	DropItem5.RespawnTime = 0.0;
      	DropItem5.bRotatingPickup = False;
      	Break;
   	}
	}
}

defaultproperties
{
   bDropWeapons=True
	bTranslucentBodies=True
	bHeadShotBonus=True
	bUseLongeRangeBonus=True
	HealthBonus=15
	MaxHealth=199
	AmmoBonus=10
	FragBonus=0
	bUseTombstones=True
	bUseRandomAwards=True
}
