class MeltingDrip extends Drip;

auto simulated state FallingState
{
	simulated function ZoneChange(ZoneInfo NewZone)
	{
		if ( NewZone.bWaterZone && !NewZone.IsA('NitrogenZone') )
			Destroy();
	}
	
	simulated function Landed(vector HitNormal)
	{
		HitWall(HitNormal, None);
	}
	
	simulated singular function Touch(actor Other)
	{
		PlaySound(DripSound);
		Destroy();
	}

Begin:
	if ( Region.Zone.bWaterZone && !Region.Zone.IsA('NitrogenZone') )
		Destroy();
	PlayAnim('Dripping', 0.3);
}

defaultproperties
{
   RemoteRole=ROLE_None
   Style=STY_Translucent
   Texture=Texture'UnrealShare.Belt_fx.ShieldBelt.newblue'
   DrawScale=1.00
   bMeshEnviroMap=True
}