
class SnowBigRock extends BigRock;


function SpawnChunks(int num)
{
   local int    NumChunks,i;
   local Snowball   TempRock;
   local float scale;

   if ( DrawScale < 1 + FRand() )
      return;

   NumChunks = 1+Rand(num);
   scale = sqrt(0.52/NumChunks);
   if ( scale * DrawScale < 1 )
   {
      NumChunks *= scale * DrawScale;
      scale = 1/DrawScale;
   }
   speed = VSize(Velocity);
   for (i=0; i<NumChunks; i++)
   {
      TempRock = Spawn(class'Snowball');
      if (TempRock != None )
         TempRock.InitFrag(self, scale);
   }
   InitFrag(self, 0.5);
}

auto state Flying
{
   function ProcessTouch (Actor Other, Vector HitLocation)
   {
      local int hitdamage;

      if ( Other == instigator )
         return;
      PlaySound(ImpactSound, SLOT_Interact, DrawScale/10);

      if ( !Other.IsA('SnowBigRock') && !Other.IsA('Titan') )
      {
         Hitdamage = Damage * 0.00002 * (DrawScale**3) * speed;
         if ( (HitDamage > 6) && (speed > 150) )
            Other.TakeDamage(hitdamage, instigator,HitLocation,(35000.0 * Normal(Velocity)), 'crushed' );
      }
   }
    
   simulated function Landed(vector HitNormal)
   {
      HitWall(HitNormal, None);
   }

   function MakeSound()
   {
      local float soundRad;

      if ( Drawscale > 2.0 )
         soundRad = 500 * DrawScale;
      else
         soundRad = 100;
      PlaySound(ImpactSound, SLOT_Misc, DrawScale/8,,soundRad);
   }

   simulated function HitWall (vector HitNormal, actor Wall)
   {
      local vector RealHitNormal;

      if ( (Role == ROLE_Authority) && (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
         Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');
      speed = VSize(velocity);
      MakeSound();
      if ( (HitNormal.Z > 0.8) && (speed < 60 - DrawScale) )
      {
         SetPhysics(PHYS_None);
         GotoState('Sitting');
      }
      else
      {
         SetPhysics(PHYS_Falling);
         RealHitNormal = HitNormal;
         if ( FRand() < 0.5 )
            RotationRate.Pitch = Max(RotationRate.Pitch, 100000);
         else
            RotationRate.Roll = Max(RotationRate.Roll, 100000);
         HitNormal = Normal(HitNormal + 0.5 * VRand());
         if ( (RealHitNormal Dot HitNormal) < 0 )
            HitNormal.Z *= -0.7;
         Velocity = 0.7 * (Velocity - 2 * HitNormal * (Velocity Dot HitNormal));
         DesiredRotation = rotator(HitNormal);
         if ( (speed > 150) && (FRand() * 30 < DrawScale) )
            SpawnChunks(4);
      }
   }

Begin:
   Sleep(5.0);
   SetPhysics(PHYS_Falling);
}

defaultproperties
{
   ImpactSound=Sound'UnrealI.Titan.Rockhit'
	MultiSkins(1)=Texture'SnowSkin'
}