class Snowball extends Projectile;

#exec TEXTURE IMPORT FILE="Textures\SnowSkin.bmp" NAME="SnowSkin" GROUP="SnowballGun"

var vector SurfaceNormal;	
var bool bOnGround, bMelting;
var bool bCanHitInstigator;
var float wallTime;
var float BaseOffset;

function InitFrag(BigRock myParent, float scale)
{
   local rotator newRot;

   RotationRate = RotRand();
   scale *= (0.5 + FRand());
   DrawScale = scale * myParent.DrawScale;
   if ( DrawScale <= 2 )
      SetCollisionSize(0,0);
   else
      SetCollisionSize(CollisionRadius * DrawScale/Default.DrawScale, CollisionHeight * DrawScale/Default.DrawScale);

   Velocity = Normal(VRand() + myParent.Velocity/myParent.speed) * (myParent.speed * (0.4 + 0.3 * (FRand() + FRand())));
}

simulated function SetWall(vector HitNormal, Actor Wall)
{
	local rotator RandRot;
	
	bProjTarget = True;
	SurfaceNormal = HitNormal;
	RandRot = rotator(HitNormal);
	RandRot.Roll += 32768;
	SetRotation(RandRot);	
	if ( Mover(Wall) != None )
		SetBase(Wall);
}

auto state Flying
{
	simulated function ProcessTouch (Actor Other, vector HitLocation) 
	{ 
		if ( Other.IsA('Snowball') ) {
			if ( Snowball(Other).bOnGround ) {
				Other.DrawScale = Sqrt(Square(DrawScale) + Square(Other.DrawScale));
				Other.LifeSpan = 2 * Other.DrawScale;
				Other.PlaySound(ImpactSound);
				Destroy();
			}
		}
		else if ( Role == ROLE_Authority && (Pawn(Other) != Instigator || bCanHitInstigator) ) 
		{
			Other.TakeDamage(Damage * VSize(Velocity) / MaxSpeed, Instigator, HitLocation, Normal(Velocity) * MomentumTransfer, MyDamageType);
			Destroy();
		}
	}
	
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		SetPhysics(PHYS_None);		
		MakeNoise(0.3);	
		bOnGround = True;
		PlaySound(ImpactSound);
		SetWall(HitNormal, Wall);
		TweenAnim('Drip', 0.2);
		GoToState('OnSurface');
	}
	
	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local WaterRing w;
		
		if ( !NewZone.bWaterZone )
			return;
		
		if ( !bOnGround ) 
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.1;
		}
		bOnGround = True;
		StartMelting();
		Velocity = 0.1 * Velocity;
	}

	function BeginState()
	{	
		if ( Role == ROLE_Authority ) 
		{
			Velocity = Vector(Rotation) * Speed;
			Velocity.Z += 120;
			if ( Region.Zone.bWaterZone )
				Velocity = Velocity * 0.7;
		}
		if ( Level.NetMode != NM_DedicatedServer )
			RandSpin(100000);
		bOnGround = False;
	}
}

simulated function Tick(float DeltaTime)
{
	local SnowSplat s;
	local vector dir;
	
	if ( bMelting )
		DrawScale = 0.5 * LifeSpan;
	if ( bOnGround && DrawScale > 8 && SurfaceNormal dot vect(0,0,1) < 0.7 ) 
	{
		while ( DrawScale > Default.DrawScale ) 
		{
			dir = VRand();
			if ( Role == Role_Authority )
				s = Spawn(class'SnowSplat',,,Location + 15 * (SurfaceNormal + dir), rotator(SurfaceNormal + dir));
			DrawScale -= 0.2 * class'SnowSplat'.default.DrawScale;
		}
		LifeSpan = 2 * DrawScale;
	}
}
	
simulated function Timer()
{
	if ( bMelting )
		Spawn(class'MeltingDrip',,,, rot(0,0,0));
	bCanHitInstigator = True;
}
	
simulated function StartMelting()
{
	bMelting = True;
	LifeSpan = 2 * DrawScale;
	if ( Level.NetMode != NM_DedicatedServer && !Region.Zone.bWaterZone && SurfaceNormal dot vect(0,0,1) < 0.1 )
		SetTimer(RandRange(0.5, 0.7), True);
}

state OnSurface
{
ignores Touch;

	simulated function AnimEnd()
	{
		StartMelting();
	}
}

defaultproperties
{
    speed=700.00
    MaxSpeed=2500.00
    Damage=25.00
    MomentumTransfer=20000
    MyDamageType=Frozen
    ImpactSound=Sound'Botpack.GelHit'
    bNetTemporary=False
    Physics=PHYS_Falling
    RemoteRole=ROLE_SimulatedProxy
    AnimSequence=Still
    Mesh=LodMesh'Botpack.BioGelm'
    DrawScale=8.0
    AmbientGlow=50
    MultiSkins(1)=Texture'SnowSkin'
    CollisionRadius=10.00
    CollisionHeight=10.00
    bBounce=True
    Buoyancy=150.00
}
