
class Scanner extends Weapon;

#exec TEXTURE IMPORT NAME=hand FILE=Textures\hand.bmp  GROUP=Skins

//Needed text for radar
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2

//Add
var() bool bHasHand;
var() int HandSkinNUM;

// For mover XRay function
var Texture TeamBeaconIcon;
var int d;

// Sets personal light
var pawn Beacon;

//I found a mover!
var sound SuccessSound;

function float RateSelf( out int bUseAltMode )
{
	return -2;
}

// Skin swaps called from mesh notifies in scannermesh class
simulated function TurnOn()
{
	MultiSkins[3] = Texture'ScannerReady';
}
simulated function TurnOff()
{
	MultiSkins[3] = Texture'BlackTexture';
	MultiSkins[2] = Texture'JMediGun1';
}
simulated function ScanOn()
{
	MultiSkins[3] = Texture'SendingOpen';
	MultiSkins[2] = Texture'damagewet';
}
simulated function AltScanOn()
{
	MultiSkins[3] = Texture'SendingClose';
	MultiSkins[2] = Texture'damagewet';
}
simulated function ScanOff()
{
	MultiSkins[3] = Texture'ScannerReady';
	MultiSkins[2] = Texture'JMediGun1';
}

function PlayFiring()
{
	PlayAnim('Wave1',1.0,0.02);
	Owner.PlaySound(AltFireSound, SLOT_None,Pawn(Owner).SoundDampening,,,1.0);
	Owner.PlaySound(FireSound, SLOT_Misc,2.0*Pawn(Owner).SoundDampening,,,1.0);
}

function PlayAltFiring()
{
	PlayAnim('Wave2',1.0,0.02);
	Owner.PlaySound(AltFireSound, SLOT_None,Pawn(Owner).SoundDampening,,,1.0);
}

function Fire( float Value )
{
	if(AmmoType.UseAmmo(1))
	{
		GotoState('NormalFire');
		bPointing=True;
		PlayFiring();
		if ( !bRapidFire && (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		TraceFire(0.0);
	}
}

function AltFire( float Value )
{
	if(AmmoType.UseAmmo(1))
	{
		GotoState('AltFiring');
		bPointing=True;
		PlayAltFiring();
		if ( bRapidFire || (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		OtherTraceFire(0.0);
	}
}

function OtherTraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
			   + Accuracy * (FRand() - 0.5 ) * Z * 1000;
	X = vector(AdjustedAim);
	EndTrace += (10000 * X);
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	OtherProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

// Setup for finding a mover
function EffectsTraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
			   + Accuracy * (FRand() - 0.5 ) * Z * 1000;
	X = vector(AdjustedAim);
	EndTrace += (10000 * X);
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	TimerProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

// Trace hit for the fire command, sends the 'open' order to the mover
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local Mover M;

	if ((Other != none) && (Other.IsA('Mover')) && VSize(Other.Location-Owner.Location) < 2000)
	{
		M = Mover(Other);
   	M.DoOpen();
	}
}

// Trace hit for the alt-fire, sends the 'close' order to the mover
function OtherProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local Mover M;

	if ((Other != none) && (Other.IsA('Mover')) && VSize(Other.Location-Owner.Location) < 2000)
	{
		M = Mover(Other);
   	M.DoClose();
	}
}

// Trace hit for hovering over a mover
function TimerProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if ((Other != none) && (Other.IsA('Mover')) && VSize(Other.Location-Owner.Location) < 2000)
	{
		Spawn(class'MoverWallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
      Owner.PlaySound(SuccessSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
   }
}

// Creates the overlay in the HUD that shows movers
// Needs improvement, some movers don't render properly
simulated function PostRender(canvas Canvas)
{
   local Mover thisMover;
   local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
   local rotator CamRot;
   local Actor Camera;
   local float BaseBeaconScale, BeaconScale, Dist, DistScale;
   local float TanFOVx, TanFOVy;
   local float dx, dy, FontY;
   local string BeaconText;

   Canvas.Style = ERenderStyle.STY_Masked;

   if (Canvas.ClipX > 1024)
      Canvas.Font = Font'BeaconNameFontLarge';
   else if (Canvas.ClipX > 640)
      Canvas.Font = Font'BeaconNameFontMedium';
   else
      Canvas.Font = Font'BeaconNameFontSmall';
	
   Canvas.SetPos(0, 0);
   Canvas.TextSize("X", dx, FontY);
   BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;

   Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

   TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559);
   TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
   GetAxes(CamRot, X, Y, Z);

   Canvas.bNoSmooth = False;
   Canvas.Style = ERenderStyle.STY_Masked;

   //foreach RadiusActors(class 'Mover', thisMover, 7000)
	foreach Owner.RadiusActors(class 'Mover', thisMover, 7000,CamLoc)
   {
      if (thisMover != none && thisMover != Camera)
      {
         TargetDir = thisMover.Location - CamLoc;
	 		Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
	 		TargetDir = Normal(TargetDir + vect(0,0,1)); // * thisMover.CollisionHeight);
	 		DistScale = FMin(100.0 * thisMover.CollisionRadius / Dist, 1.0);
	 		d = Dist;

	 		if ((DistScale > 0.0 && TargetDir dot X > 0) && (FastTrace(thisMover.Location, CamLoc) 
			|| FastTrace(thisMover.Location + vect(0,0,0.8) * thisMover.CollisionHeight, CamLoc)))
         {
	    		BeaconScale = BaseBeaconScale * DistScale;
	   	 	Dir = X * (X dot TargetDir);
	    		XY = TargetDir - Dir;

	    		dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
	    		dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));

	    		//Canvas.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);
	    		Canvas.SetPos(dx - 0.5 * BeaconScale, dy - 2 * FontY * DistScale);

	    		if (DistScale <= 1.0)
            {
	       		if (Canvas.ClipX > 600)
		  				BeaconText = "Mover: " $ d $ "";
               Canvas.DrawIcon(texture'CrossHair6', 1.0);
	       		Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
	       		Canvas.DrawTextClipped(BeaconText, False);
            }
         }
      }
   }
}

function PlaySelect()
{
	local Texture handtex;

	Super.PlaySelect();

	if(!bHasHand || Pawn(Owner) == none || mesh == PickupViewMesh) return;
	
	handtex = Texture'hand';

	if(HandSkinNUM == 0) skin = handtex;
	else MultiSkins[HandSkinNUM] = handtex;
	
	PlayAnim('Select',1.0,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	
	Beacon = pawn(owner);
	Beacon.ClientMessage("Turning personal light on");
   Beacon.AmbientGlow = 254;
   Beacon.LightEffect=LE_NonIncidence;
   Beacon.LightBrightness=255;
   Beacon.LightHue=210;
   Beacon.LightRadius=30;
   Beacon.LightSaturation=200;
   Beacon.LightType=LT_Steady;
}

simulated function DropFrom(vector StartLocation)
{
	if(HandSkinNUM == 0) skin = Texture'black_none';
		else MultiSkins[HandSkinNUM] = Texture'black_none';

	Super.DropFrom(StartLocation);
}

simulated function PlayIdleAnim()
{
   PlayAnim('still0',1.25,1.2);
}

simulated function TweenToStill()
{
	TweenAnim('still0', 0.1);
}

function TweenDown()
{
	if ( (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else
		PlayAnim('Down', 1.0, 0.05);
		
	Beacon.ClientMessage("Turning personal light off");
   Beacon.AmbientGlow = Beacon.Default.AmbientGlow;
   Beacon.LightType = LT_None;
}

state Idle   //added only to disable animend
{
	function AnimEnd()
	{
		PlayIdleAnim();
		EffectsTraceFire(0.0);
	}

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}

Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) AltFire(0.0);	
//	Disable('AnimEnd');
	PlayIdleAnim();
}

defaultproperties
{
   bHasHand=True
   AmmoName=Class'ScannerBattery'
   PickupAmmoCount=199
   FireOffset=(X=10.00,Y=0.00,Z=0.00),
   FireSound=Sound'UnrealI.dampndea'
   AltFireSound=Sound'UnrealI.DampSnd'
   SelectSound=Sound'UnrealShare.Pickups.VoiceSnd'
   DeathMessage="%o was killed with %k's %w."
   AutoSwitchPriority=0
   PickupMessage="You got the Scanner"
   ItemName="Scanner"
   PlayerViewOffset=(X=5.40,Y=2.60,Z=-4.10),
   PlayerViewMesh=LodMesh'scanner2.MediGun'
   PlayerViewScale=0.15
   PickupViewMesh=LodMesh'scanner2.MediGunS'
   ThirdPersonMesh=LodMesh'scanner2.MediGunS'
   PickupSound=Sound'UnrealShare.Dispersion.number3'
   Mesh=LodMesh'scanner2.MediGunS'
   TeamBeaconIcon=Texture'TeamBeacon2'
   SuccessSound=Sound'UnrealI.fFieldh2'
}
