//=============================================================================
// Fader
//=============================================================================
class Fader extends TournamentPickup;

var() float GuardTime;  //The time the Fader should last
var() float StartFactor;//What percentage to start the Fade at
var() float MaxGlow;    //What percentage to start the Fade at
var() firetexture TeamFireTextures[4];
var() string TeamFireTextureStrings[4];
var firetexture ActiveTexture;
var float DamageFactor;	//Current factor of fader
var float TimerInterval;//Current factor of fader
var int Counter;        //Current factor of fader
var string PlayerName;
var bool Flash;
var int TeamNum;
var texture TeamTextures[4];
var Weapon ActiveWeapon;

function PickupFunction(Pawn Other) {
	
  if ( Level.Game.bTeamGame && (Other.PlayerReplicationInfo != None) ) {
    TeamNum = Other.PlayerReplicationInfo.Team;
  }
  if ( TeamFireTextures[TeamNum] == None )
    TeamFireTextures[TeamNum] = FireTexture(DynamicLoadObject(TeamFireTextureStrings[TeamNum], class'Texture'));

  if( StartFactor > 1 )
    StartFactor = 1;
  
  if( MaxGlow < 1 )
    MaxGlow = 1;
  
  if( GuardTime < 1.5 )
    GuardTime = 1.5;
  
  DamageFactor = StartFactor;
  PlayerName = Other.PlayerReplicationInfo.PlayerName;
  ActiveTexture = TeamFireTextures[TeamNum];


  Other.SetDisplayProperties( ERenderStyle.STY_Translucent, ActiveTexture, true, true );

  SetOwnerDisplay();

  Other.ScaleGlow = 0;
  Other.Weapon.ScaleGlow = 0;

  log( PlayerName $ ": GuardTime = " $ GuardTime );
  
  Counter = 0;
  
  TimerInterval = ( GuardTime - 1 ) / 10;
  
  //log( PlayerName $ ": TimerInterval = " $ TimerInterval );
  
  SetTimer( TimerInterval, True );
}

function Timer() {
  
  local pawn P;
  local float Glow;
  
  //log( PlayerName $ ": Counter = " $ Counter $ ", preDamageFactor = " $ DamageFactor );
  
  P = Pawn(Owner);
  
  if( Counter <= 9 ) {
    DamageFactor = ( ( ( Counter * 0.1 ) + StartFactor ) / ( 0.9 + StartFactor ) ) * 0.9;
    
    Glow = MaxGlow * DamageFactor;
    
    P.ScaleGlow = Glow;
    ActiveWeapon.ScaleGlow = Glow;
  } else {
    if( Counter >= 15 ) {
      P.ScaleGlow = 1;
      P.SetDefaultDisplayProperties();
      ActiveWeapon.ScaleGlow = 1;
      ActiveWeapon.SetDefaultDisplayProperties();
      //log( PlayerName $ ": done with protection" );
      DamageFactor = 1;
      Destroy();
    } else {
      //for the last second, we blink
      DamageFactor = 0.9;
    
      if( Flash ) {
        //translucent
        Flash = false;
        P.SetDisplayProperties( ERenderStyle.STY_Translucent, ActiveTexture, true, true );
        SetFadeWeapon();
      } else {
        //solid
        Flash = true;
        P.SetDefaultDisplayProperties();
        P.ScaleGlow = 1;
        ActiveWeapon.SetDefaultDisplayProperties();
        ActiveWeapon.ScaleGlow = 1;
      }
    
      SetTimer(0.2,false);
    }	
    if( Inventory != None )
      Inventory.SetOwnerDisplay();
  }
  
  Counter++;
}

function ChangedWeapon() {
if( Inventory != None )
     Inventory.ChangedWeapon();
  
  SetFadeWeapon();
}

function SetFadeWeapon() {
  // Make old weapon normal again.
  if ( ActiveWeapon != None ) {
    ActiveWeapon.SetDefaultDisplayProperties();
    if ( ActiveWeapon.IsA('TournamentWeapon') )
      TournamentWeapon(ActiveWeapon).Affector = None;
  }
		
  ActiveWeapon = Pawn(Owner).Weapon;
  // Make new weapon cool.
  if ( ActiveWeapon != None ) {
    if ( ActiveWeapon.IsA('TournamentWeapon') )
      TournamentWeapon(ActiveWeapon).Affector = self;
    ActiveWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent, ActiveTexture, true, true );
  }
}

function SetOwnerDisplay() {
  if( Inventory != None )
    Inventory.SetOwnerDisplay();
  
  SetFadeWeapon();
}



defaultproperties
{
    TeamFireTextures(0)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
    TeamFireTextures(1)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
    TeamFireTextures(2)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.Greenshield'
    TeamFireTextures(3)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.N_Shield'
    TeamFireTextureStrings(0)="UnrealShare.Belt_fx.ShieldBelt.RedShield"
    TeamFireTextureStrings(1)="UnrealShare.Belt_fx.ShieldBelt.BlueShield"
    TeamFireTextureStrings(2)="UnrealShare.Belt_fx.ShieldBelt.Greenshield"
    TeamFireTextureStrings(3)="UnrealShare.Belt_fx.ShieldBelt.N_Shield"
}
