//=============================================================================
// SpawnGuard
//=============================================================================
class SpawnGuard extends Mutator config(spawnguard);

var() config float GuardTime;   //The time the SpawnGuard should last
var() config float StartFactor; //The time the SpawnGuard should last
var() config float MaxGlow;     //What percentage to start the Fade at
var bool Initialized;

function PostBeginPlay() {
  if (Initialized)
    return;
  Initialized = True;
  Level.Game.RegisterDamageMutator( Self );
}

function ModifyPlayer(Pawn Other) {
  local Fader g;
  
  if ( Other.IsA('Spectator') || Other.FindInventoryType(class'Fader') != None )
    return;
  
  g = Spawn(class'Fader',,, Location);
  if (g != None)
    {
      //log("adding fader to inventory and activating it");
      g.bHeldItem = true;
      g.GuardTime = GuardTime;
      g.StartFactor = StartFactor;
      g.MaxGlow = MaxGlow;
      g.GiveTo( Other );
      g.PickupFunction( Other );
      Other.SelectedItem = g;
    }
  
  //log("done initializing the SpawnGuard");
  Super.ModifyPlayer(Other);
}


function MutatorTakeDamage( out int ActualDamage, 
			    Pawn Victim, 
			    Pawn InstigatedBy, 
			    out Vector HitLocation,
			    out Vector Momentum, 
			    name DamageType) {
  
  local Inventory VictimInv;
  local Inventory InstigatorInv;
  local string VictimName;
  local string InstigatorName;

  VictimName = Victim.PlayerReplicationInfo.PlayerName;
  InstigatorName = InstigatedBy.PlayerReplicationInfo.PlayerName;

  //log( VictimName $ " takes initial damage of " $ ActualDamage );
  
  if (Victim.IsA('Bot') || Victim.IsA('PlayerPawn')) {
    VictimInv = Victim.FindInventoryType(class'Fader');
    if( VictimInv != None ) {
      if( ActualDamage > 100 && DamageType == 'decapitated' ) {
        //log( VictimName $" suffers a headshot!" );
        ActualDamage = 100;
      }
      ActualDamage = ActualDamage * Fader(VictimInv).DamageFactor;
      //log( "Damage reduced to " $ ActualDamage $ " by " $ VictimName $ "'s Fader State " $ Fader(VictimInv).DamageFactor );
    }
  }
    
  if (InstigatedBy.IsA('Bot') || InstigatedBy.IsA('PlayerPawn')) {
    InstigatorInv = InstigatedBy.FindInventoryType(class'Fader');
    if( InstigatorInv != None ) {
      ActualDamage = ActualDamage * Fader(InstigatorInv).DamageFactor;
      //log( "Damage reduced to " $ ActualDamage $ " by " $ InstigatorName $ "'s Fader State " $ Fader(InstigatorInv).DamageFactor );
    }
  }
  
  if ( NextDamageMutator != None )
    NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

defaultproperties
{
}
