/*
Teleporter fix code used by permission of Defrost
Thanks bro!
*/

class TeamTeleporter extends NavigationPoint;

#exec Texture Import File=Textures\S_Teleport.bmp Name=S_Teleport Mips=Off Flags=2

var() string URL;
var() name ProductRequired;

var() bool bChangesVelocity;
var() bool bChangesYaw;
var() bool bReversesX;
var() bool bReversesY;
var() bool bReversesZ;

var() bool bEnabled;
var() byte TeamNumber;

var() vector TargetVelocity;
var Actor TriggerActor;
var Actor TriggerActor2;
var float LastFired;

var UTTeleEffect T;

struct ActorCollisionInfo
{
var Actor a;
var bool bCollideActors;
var bool bBlockActors;
var bool bBlockPlayers;
var int targetTickCount;
};

struct ActorTouchIgnoreInfo 
{
var Actor a;
var int targetTickCount;
};

var ActorCollisionInfo actorCollisionsToFix[10];
var ActorTouchIgnoreInfo touchIgnoreList[10];
var int tickCounter;
const tickCounterMax = 10;
const restoreDelay = 3;
const ignoreDelay = 6;

replication
{
   reliable if( Role==ROLE_Authority )
      bEnabled, URL;
   reliable if ( bNetInitial && (Role == ROLE_Authority) )
      bChangesVelocity, bChangesYaw, bReversesX, bReversesY, bReversesZ, TargetVelocity;
}

function PostBeginPlay()
{
   if (URL ~= "")
      SetCollision(false, false, false);
   if ( !bEnabled )
      FindTriggerActor();
   Super.PostBeginPlay();

   LoopAnim('Teleport', 2.0, 0.0);
   T = spawn(class'UTTeleeffect');
   T.lifespan = 0.0;
}

simulated function Destroyed()
{
   if ( T != None )
      T.Destroy();
   Super.Destroyed();
}

function FindTriggerActor()
{
   local Actor A;

   TriggerActor = None;
   TriggerActor2 = None;
   ForEach AllActors(class 'Actor', A)
   if ( A.Event == Tag)
   {
      if ( Counter(A) != None )
         return;
      if (TriggerActor == None)
         TriggerActor = A;
      else
      {
         TriggerActor2 = A;
         return;
      }
   }
}

simulated function bool Accept( actor Incoming, Actor Source )
{
   local rotator newRot, oldRot;
   local int oldYaw;
   local float mag;
   local vector oldDir;
   local pawn P;

   Disable('Touch');

   newRot = Incoming.Rotation;
   if (bChangesYaw)
   {
      oldRot = Incoming.Rotation;
      newRot.Yaw = Rotation.Yaw;
      if ( Source != None )
         newRot.Yaw += (32768 + Incoming.Rotation.Yaw - Source.Rotation.Yaw);
   }

   if ( Pawn(Incoming) != None )
   {
      if ( Role == ROLE_Authority )
      {
         P = Level.PawnList;
         While ( P != None )
         {
            if (P.Enemy == Incoming)
               P.LastSeenPos = Incoming.Location;
            P = P.nextPawn;
         }
      }
      storeActor(incoming);
      Pawn(Incoming).SetLocation(Location);
      if ((Role == ROLE_Authority) || (Level.TimeSeconds - LastFired > 0.5))
      {
         newRot.yaw = rand(65536);
         Pawn(incoming).setRotation(newRot);
         Pawn(incoming).viewRotation = newRot;
         LastFired = level.timeSeconds;
      }
      Pawn(Incoming).MoveTimer = -1.0;
      Pawn(Incoming).MoveTarget = self;
      PlayTeleportEffect( Incoming, false);
   }
   else
   {
      storeActor(incoming);
      if ( !Incoming.SetLocation(Location) )
      {
         restoreActor(incoming);
         Enable('Touch');
         return false;
      }
      if ( bChangesYaw )
         Incoming.SetRotation(newRot);
   }
   Enable('Touch');

   if (bChangesVelocity)
      Incoming.Velocity = TargetVelocity;
   else
   {
      if ( bChangesYaw )
      {
         if ( Incoming.Physics == PHYS_Walking )
            OldRot.Pitch = 0;
         oldDir = vector(OldRot);
         mag = Incoming.Velocity Dot oldDir;
         Incoming.Velocity = Incoming.Velocity - mag * oldDir + mag * vector(Incoming.Rotation);
      }
      if ( bReversesX )
         Incoming.Velocity.X *= -1.0;
      if ( bReversesY )
         Incoming.Velocity.Y *= -1.0;
      if ( bReversesZ )
         Incoming.Velocity.Z *= -1.0;
   }
   return true;
}

function PlayTeleportEffect(actor Incoming, bool bOut)
{
   if ( Incoming.IsA('Pawn') )
   {
      Incoming.MakeNoise(1.0);
      Level.Game.PlayTeleportEffect(Incoming, bOut, true);
   }
}

function Trigger( actor Other, pawn EventInstigator )
{
   local int i;

   bEnabled = !bEnabled;
   if ( bEnabled )
      for (i=0;i<4;i++)
      if ( Touching[i] != None )
         Touch(Touching[i]);
}

simulated function Touch( actor Other )
{
   local TeamTeleporter Dest;
   local int i;
   local Actor A;
   local int index;
   local bool bFound;

   while (!bFound && index < arrayCount(touchIgnoreList))
   {
      if (touchIgnoreList[index].a == other)
      {
	 bFound = true;
      }
      else
      {
	 index++;
      }
   }

   if (!bFound)
   {
      if ( !bEnabled )
         return;

      if( Pawn(Other).PlayerReplicationInfo.Team != TeamNumber)
         return;

      if( Other.bCanTeleport)
      {
         if( (InStr( URL, "/" ) >= 0) || (InStr( URL, "#" ) >= 0) )
         {
            if( (Role == ROLE_Authority) && (PlayerPawn(Other) != None) )
               Level.Game.SendPlayer(PlayerPawn(Other), URL);
         }
         else
         {
            foreach AllActors( class 'TeamTeleporter', Dest )
            if( string(Dest.tag)~=URL && Dest!=Self )
               i++;
            i = rand(i);
            foreach AllActors( class 'TeamTeleporter', Dest )
            if( string(Dest.tag)~=URL && Dest!=Self && i-- == 0 )
               break;
            if( Dest != None )
            {
               if ( Other.IsA('Pawn') )
                  PlayTeleportEffect( Pawn(Other), false);
               Dest.Accept( Other, self );
               if( (Event != '') && (Other.IsA('Pawn')) )
                  foreach AllActors( class 'Actor', A, Event )
                     A.Trigger( Other, Other.Instigator );
            }
            else if ( Role == ROLE_Authority )
               Pawn(Other).ClientMessage( "Teleport destination for "$self$" has not been correctly set!" );
         }
      }
   }
}

simulated function storeActor(Actor a)
{
   local int index;
   local bool bFound;

   while (!bFound && index < arrayCount(actorCollisionsToFix))
   {
      if (actorCollisionsToFix[index].a == none)
      {
	 actorCollisionsToFix[index].a = a;
	 actorCollisionsToFix[index].bCollideActors = a.bCollideActors;
	 actorCollisionsToFix[index].bBlockActors = a.bBlockActors;
	 actorCollisionsToFix[index].bBlockPlayers = a.bBlockPlayers;
	 actorCollisionsToFix[index].targetTickCount = (tickCounter + restoreDelay) % tickCounterMax;
	 a.setCollision(false, false, false);
	 bFound = true;
      }
      else
      {
	 index++;
      }
   }
   addToTouchIgnoreList(a);
}

simulated function addToTouchIgnoreList(Actor a)
{
   local int index;
   local bool bFound;

   while (!bFound && index < arrayCount(touchIgnoreList)) 
   {
      if (touchIgnoreList[index].a == none) 
      {
	 touchIgnoreList[index].a = a;
	 touchIgnoreList[index].targetTickCount = (tickCounter + restoreDelay) % ignoreDelay;
	 bFound = true;
      }
      else 
      {
	 index++;
      }
   }
}

simulated function restoreActor(Actor a)
{
   local int index;
   local bool bFound;

   while (!bFound && index < arrayCount(actorCollisionsToFix)) 
   {
      if (actorCollisionsToFix[index].a == a)
      {
	 a.setCollision(actorCollisionsToFix[index].bCollideActors,
         actorCollisionsToFix[index].bBlockActors,
         actorCollisionsToFix[index].bBlockPlayers);
	 actorCollisionsToFix[index].a = none;
         bFound = true;
      } 
      else 
      {
	 index++;
      }
   }
}

function Actor SpecialHandling(Pawn Other)
{
   local int i;
   local vector Dist2D;
   if (bEnabled && (Other.RouteCache[1] != None) && Other.RouteCache[1].IsA('TeamTeleporter') && (string(Other.RouteCache[1].tag)~=URL))
   {
      if ( Abs(Location.Z - Other.Location.Z) < CollisionHeight + Other.CollisionHeight )
      {
         Dist2D = Location - Other.Location;
         Dist2D.Z = 0;
         if ( VSize(Dist2D) < CollisionRadius + Other.CollisionRadius )
            Touch(Other);
      }
      return self;
   }

   if (TriggerActor == None)
   {
      FindTriggerActor();
      if (TriggerActor == None)
         return None;
   }

   if ((TriggerActor2 != None) && (VSize(TriggerActor2.Location - Other.Location) < VSize(TriggerActor.Location - Other.Location)))
      return TriggerActor2;

   return TriggerActor;
}

simulated function tick(float delta)
{
   local int index;

   tickCounter = (tickCounter + 1) % tickCounterMax;

   for (index = 0; index < arrayCount(actorCollisionsToFix); index++)
   {
      if (actorCollisionsToFix[index].a != none && actorCollisionsToFix[index].targetTickCount == tickCounter)
      {
	 restoreActor(actorCollisionsToFix[index].a);
      }
   }
   for (index = 0; index < arrayCount(touchIgnoreList); index++)
   {
      if (touchIgnoreList[index].a != none && touchIgnoreList[index].targetTickCount == tickCounter)
      {
	 touchIgnoreList[index].a = none;
      }
   }
}

defaultproperties
{
   RemoteRole=ROLE_SimulatedProxy
   bChangesYaw=true
   bEnabled=True
   bDirectional=True
   SoundVolume=128
   CollisionRadius=+00018.000000
   CollisionHeight=+00040.000000
   bCollideActors=True
   Texture=S_Teleport
   DrawType=DT_Mesh
   Style=STY_Translucent
   Mesh=LodMesh'Botpack.Tele2'
   bUnlit=True
   bStatic=false
   bHidden=false
   RemoteRole=ROLE_SimulatedProxy
}

