class MutPostalBabes extends Mutator config(UTPostalBabes);

#exec NEW MUSICFACTORY FILE=Music\null48.s3m NAME=Null48

var bool PartyIsOn;
var bool DanceOn;

//Dynamic loading from the ini file
var config string DancerATexture;
var config string DancerBTexture;
var Texture DancerATextureChoice;
var Texture DancerBTextureChoice;

function PostBeginPlay()
{
	local int i;

   SetTimer( 4.0, true );
    
   DancerATextureChoice = texture(DynamicLoadObject(DancerATexture, class'Texture'));
   DancerBTextureChoice = texture(DynamicLoadObject(DancerBTexture, class'Texture'));
}

function bool AlwaysKeep(Actor Other)
{
	local int randm;

	if ( Other.IsA('Dancer') )
		Dancer(Other).MultiSkins[0] = DancerATextureChoice;

	if ( Other.IsA('Dancer1') )
		Dancer(Other).MultiSkins[0] = DancerBTextureChoice;

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );

	return false;
}

function Timer()
{
   if (Level.Game.bGameEnded)
	{
		if (PartyIsOn == False)
		{
			ShutDownLevelMusic();
			BabeParty();
			PartyIsOn=True;
   	}
	}
}

function BabeParty()
{
	local actor A;
   local pawn P, Best;
   local ZoneInfo M;
   local Light B;
   local Pickup Q;
   local rotator R;
	local vector dir;
	local Table1 T1;
	local Table2 T2;

   for ( P=Level.PawnList; P!=None; P=P.nextPawn )
      if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)))
         Best = P;
         
   DanceOn=False;

   ForEach RadiusActors( class'Pawn', P, 350.0, Best.Location )
   {
      if ( P != Best )
		{
      	P.bHidden = true;

         if ( P.Weapon != None )
			{
            P.Weapon.Destroy();
            P.Weapon = None;
         }
      }
   }

   ForEach RadiusActors( class'Pickup', Q, 350.0, Best.Location )
   {
      if ( Q.bStatic || Q.bNoDelete )
         Q.GotoState( 'Disabled' );
		else
         Q.Destroy();
   }

   spawn(class'Table1',,, Best.Location  + 72 * Vector(Rotation) + vect(0,0,-33));
   foreach RadiusActors(class'Table1', T1, 100, Best.Location)
	{
		if(T1 != None)
		{
      	spawn(class'PostalExplosion',,, Best.Location  + 72 * Vector(Rotation) + vect(0,0,20));
         spawn(class'RingExplosion2',,, Best.Location  + 72 * Vector(Rotation) + vect(0,0,20));
         spawn(class'RingExplosion2',,, Best.Location  + 72 * Vector(Rotation * 2) + vect(0,0,20));
         spawn(class'PurpleShots',,, Best.Location  + 72 * Vector(Rotation) + vect(0,0,20));
        	spawn(class'Dancer1',,, Best.Location  + 72 * Vector(Rotation) + vect(0,0,5));
        	DanceOn = True;
		}
		else BroadcastMessage("Not enough room for the Postal Babes");
	}

   spawn(class'Table2',,, Best.Location  - 72 * Vector(Rotation) + vect(0,0,-33));
   foreach RadiusActors(class'Table2', T2, 100, Best.Location)
   {
   	if(T2 != None)
   	{
   		spawn(class'PostalExplosion',,, Best.Location  - 72 * Vector(Rotation) + vect(0,0,20));
   		spawn(class'RingExplosion2',,, Best.Location  - 72 * Vector(Rotation) + vect(0,0,20));
   		spawn(class'RingExplosion2',,, Best.Location  - 72 * Vector(Rotation * 2) + vect(0,0,20));
   		spawn(class'PurpleShots',,, Best.Location  - 72 * Vector(Rotation) + vect(0,0,20));
   	   spawn(class'Dancer',,, Best.Location  - 72 * Vector(Rotation) + vect(0,0,5));
   	   if (DanceOn != True)
   	   	DanceOn = True;
      }
      else BroadcastMessage("Not enough room for the Postal Babes");
   }
   if (DanceOn != False)
   	spawn(class'PostalBabesMusic',,,Best.Location);
}

function ShutDownLevelMusic()
{
   local PlayerPawn P;
   local Pawn A;

   A = Level.PawnList;
   While ( A != None )
   {
      if ( A.IsA('PlayerPawn') )
         PlayerPawn(A).ClientSetMusic( Music'null48', 0, 255, MTRAN_Fade);
      A = A.nextPawn;
   }
}

defaultproperties
{
   PartyIsOn=False
   DanceOn=False
}
