class ANTIEVERYTHING expands MortarShell config (VMViper);

#exec MESH IMPORT MESH=NukeMissileA ANIVFILE=MODELS\NukeMissile_a.3d DATAFILE=MODELS\NukeMissile_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=NukeMissileA STRENGTH=0
#exec MESH ORIGIN MESH=NukeMissileA X=0 Y=0 Z=0 YAW=128

#exec MESH SEQUENCE MESH=NukeMissileA SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeMissileA SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=NukeMissileA MESH=NukeMissileA
#exec MESHMAP SCALE MESHMAP=NukeMissileA X=0.0313 Y=0.0313 Z=0.0625

#exec TEXTURE IMPORT NAME=XNukeSk FILE=XNukeSk.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeMissileA NUM=1 TEXTURE=XNukeSk

#exec AUDIO IMPORT NAME="dropalarm1" FILE=SLV2SOUNDS\dropalarm1.wav

var()  config int BlastRadius;        // radius of explosion
var() config float Damage;
var() config float Speed;

function Explode(vector HitLocation, vector HitNormal)
{
	local vector start;
	local BombWave F;

	HurtRadius(damage, BlastRadius, 'StrangeDeath', MomentumTransfer, HitLocation);
	start = Location + 10 * HitNormal;
	F = Spawn( class'BombWave',,,Start);
	Spawn( class 'UTChunk2',, '', Start);
	Spawn( class 'UTChunk3',, '', Start);
	Spawn( class 'UTChunk4',, '', Start);
	Spawn( class 'UTChunk1',, '', Start);
	Destroy();

	if ( Level.NetMode != NM_DedicatedServer )
		Spawn(class'Botpack.NuclearMark',self,,Location, rotator(HitNormal));
	Destroy();
}

defaultproperties
{
   BlastRadius=250
   Damage=1000.000000
   speed=2600.000000
   MomentumTransfer=100000
   MyDamageType=RedeemerDeath
   MiscSound=Sound'dropalarm'
   ExplosionDecal=Class'Botpack.NuclearMark'
   LifeSpan=10.000000
   AmbientSound=Sound'Botpack.Redeemer.WarFly'
   Mesh=NukeMissileA
   DrawScale=2.350000
   AmbientGlow=78
   Fatness=225
   SoundRadius=255
   SoundVolume=255
   SoundPitch=255
   TransientSoundVolume=2.000000
   TransientSoundRadius=1.000000
   CollisionRadius=2.000000
   CollisionHeight=2.000000
   bFixedRotationDir=True
   Mass=10000.000000
   Buoyancy=-10000.000000
}
