class AntiSlv expands DumbRocket config (VMViper);

#exec MESH IMPORT MESH=NukeMissileA ANIVFILE=MODELS\NukeMissile_a.3d DATAFILE=MODELS\NukeMissile_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=NukeMissileA STRENGTH=0
#exec MESH ORIGIN MESH=NukeMissileA X=0 Y=0 Z=0 YAW=128

#exec MESH SEQUENCE MESH=NukeMissileA SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeMissileA SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=NukeMissileA MESH=NukeMissileA
#exec MESHMAP SCALE MESHMAP=NukeMissileA X=0.0313 Y=0.0313 Z=0.0625

#exec TEXTURE IMPORT NAME=XNukeSk FILE=XNukeSk.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeMissileA NUM=1 TEXTURE=XNukeSk

#exec AUDIO IMPORT NAME="NukeAmb" FILE=SOUNDS\NukeAmb.wav GROUP="NukeAmb"
#exec AUDIO IMPORT NAME="detonate1" FILE=SLV2SOUNDS\detonate1.wav
#exec AUDIO IMPORT NAME="Warning1" FILE=SLV2SOUNDS\Warning1.wav

#exec OBJ LOAD FILE=..\System\NWCoreV3.u PACKAGE=NWCoreV3
#exec OBJ LOAD FILE=..\System\NWNuclearFXV3.u PACKAGE=NWNuclearFXV3


var Actor Seeking;
var() config int CheckRadius;
var() config bool bTeamColoredNuke;
var bool bInCheck;
var() int MyTeam;

var() bool bSeekNuke;
var() bool bDroppableNuke;

var() config bool bIgnoreFriendlyDam;

var NukeBurner XNUkeTrailA;
var NukeBurnLight XNukeTrailB;

replication
{
  	unreliable if (role == ROLE_Authority)
		Seeking, MyTeam;
}

simulated function timer()
{
   local vector x,y,z;
   local float bestDist, bestAim;
   local vector SeekingDir;
   local float MagnitudeVel;
   local DamagePuff b;    //ut_SpriteSmokePuff
   local Pawn pilot;     // pawn(owner) Pilot;
   local actor other;
   local Pawn p;
          
   If (bSeekNuke)
   {
     	If (Seeking==None)
     	{
         bestAim = 0.85;//0.93
	  		bestDist = CheckRadius;
         seeking = instigator.PickTarget(bestAim, bestDist, Normal(Velocity), Location);
     	}
     	If (Seeking != None  && Seeking != Instigator)
     	{
         SeekingDir = Normal(Seeking.Location - Location);
         MagnitudeVel = VSize(Velocity);
         Velocity =  MagnitudeVel * Normal(SeekingDir * 2.0 * MagnitudeVel + Velocity);
			SetRotation(rotator(Velocity));
     	}
   }

	if (!bDroppableNuke)
		Velocity = Speed * vector(Rotation);

   CannonTimer += SmokeRate;
   if ( CannonTimer > 0.6 )
   {
      WarnCannons();
      CannonTimer -= 0.6;
   }

   if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
   {
      SetTimer(SmokeRate, false);
      Return;
   }

   if (!bDroppableNuke)
   {
     	if ( Level.bHighDetailMode )
     	{
         if ( Level.bDropDetail )
            Spawn(Class'DamagePuff');
         else
            Spawn(Class'DamagePuff');
         SmokeRate = 152/Speed;
     	}
     	else
     	{
         SmokeRate = 0.15;
         b = Spawn(Class'DamagePuff');
         b.RemoteRole = ROLE_None;
     	}
   }
   SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
	if (XNUkeTrailA != None)
		XNUkeTrailA.Destroy();
	if (XNUkeTrailB != None)
		XNUkeTrailB.Destroy();

   Super.Destroyed();
}

function WarnCannons()
{
   local Pawn P;

   for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
      if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
      {
         P.target = self;
         P.GotoState('TrackWarhead');
      }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation,  vector momentum, name damageType )
{
   if (NDamage > 5 && ((bIgnoreFriendlyDam && Instigator.PlayerReplicationInfo.Team!=instigatedBy.PlayerReplicationInfo.Team) ||	!bIgnoreFriendlyDam || Instigator == instigatedBy))
   {
		if (instigatedBy != Instigator && Instigator.PlayerReplicationInfo.Team!=instigatedBy.PlayerReplicationInfo.Team)
	  		GiveMessage(instigatedBy, damageType);

      PlaySound(Sound'Expl03',,6.0);
      spawn(class'WarExplosion',,,Location);
          
      HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
      RemoteRole = ROLE_SimulatedProxy;
      Destroy();
   }
}

function GiveMessage(Pawn TPP, name DmgT)
{
	if (TournamentPlayer(TPP) != None && DmgT != 'SpecialDamage' && DmgT != 'RedeemerDeath')
	{
		TournamentPlayer(TPP).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 14); //DENIED
		TPP.PlayerReplicationInfo.Score += class'Strangemutator'.default.DeniedBonus;
	}
}

function Landed(vector HitNormal )
{
	HitWall(HitNormal, None);
}

auto state Flying
{
   simulated function ZoneChange( Zoneinfo NewZone )
   {
      local waterring w;
          
      if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
      {
         w = Spawn(class'WaterRing',,,,rot(16384,0,0));
         w.DrawScale = 0.2;
         w.RemoteRole = ROLE_None;
      }
   }
   function ProcessTouch (Actor Other, Vector HitLocation)
   {
      if ( Other != instigator && !Other.IsA('StrangeShell'))
         Explode(HitLocation,Normal(HitLocation-Other.Location));
	  	else if (Other.IsA('StrangeShell'))
	  	{
			if (Other.Instigator != Instigator)
				Explode(HitLocation,Normal(HitLocation-Other.Location));
	  	}
   }
   function Explode(vector HitLocation, vector HitNormal)
   {
		local StrangeWave vxSW;
		local NuclearExplosionLevelA NE;
		local StrangeShell vxShell;

      if ( Role < ROLE_Authority )
         return;

      //HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );
     // vxSW = spawn(class'StrangeWave',,, location);
      NE = spawn(class'NuclearExplosionLevelA',,, location);

		if (Seeking != None && Seeking.bIsPawn)
			vxSW.bWasSeeking = True;

      spawn(class'BlackCloud',,, location);
      RemoteRole = ROLE_SimulatedProxy;
      Destroy();
   }

   function BeginState()
   {
      local vector InitialDir;

		if (bTeamColoredNuke && Instigator.PlayerReplicationInfo.Team <= 3 && !bDroppableNuke)
		{
			if (Instigator.PlayerReplicationInfo.Team == 0)
			{
				XNUkeTrailA = Spawn(Class'RedNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'RedNukeBurnLight', Self);
				LightHue = 0;
				LightSaturation = 0;
			}
			else if (Instigator.PlayerReplicationInfo.Team == 1)
			{
				XNUkeTrailA = Spawn(Class'BlueNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'BlueNukeBurnLight', Self);
				LightHue = 170;
				LightSaturation = 127;
			}
			else if (Instigator.PlayerReplicationInfo.Team == 2)
			{
				XNUkeTrailA = Spawn(Class'GreenNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'GreenNukeBurnLight', Self);
				LightHue = 85;
				LightSaturation = 64;
			}
			else
			{
				XNUkeTrailA = Spawn(Class'YellowNukeBurner', Self);
				XNUkeTrailB = Spawn(Class'YellowNukeBurnLight', Self);
				LightHue = 42;
				LightSaturation = 83;
			}
		}
		else if (!bDroppableNuke)
		{
			XNUkeTrailA = Spawn(Class'NukeBurner', Self);
			XNUkeTrailB = Spawn(Class'NukeBurnLight', Self);
		}

		if (bDroppableNuke)
			SetPhysics(PHYS_Falling);
		else
		{
         initialDir = vector(Rotation);
         if ( Role == ROLE_Authority )
            Velocity = speed*initialDir;
         Acceleration = initialDir*50;
		}
   }
}

defaultproperties
{
   CheckRadius=1024
   speed=1720.000000
   MaxSpeed=1720.000000
   MyDamageType=RedeemerDeath
   ImpactSound=Sound'detonate1'
   MiscSound=Sound'Warning1'
   LifeSpan=0.000000
   AmbientSound=Sound'NukeAmb'
   Mesh=NukeMissileA
   DrawScale=1.350000
   AmbientGlow=78
   SoundRadius=255
   SoundPitch=104
   TransientSoundVolume=2.000000
   CollisionRadius=15.000000
   CollisionHeight=8.000000
   bProjTarget=True
   LightBrightness=131
   LightHue=85
   LightSaturation=32
   LightRadius=6
   bBounce=False
   bTeamColoredNuke=True
   Mass=135.000000
   bSeekNuke=True
   bIgnoreFriendlyDam=True
}
