// Residual smoke from crashes, etc.
class BlackCloud extends SLSmoke;

var float exrate;

simulated function beginPlay() 
{
	super.beginPlay();

	velocity = vrand() * 15;
	velocity.z = abs(velocity.z);

	// Half step off...
	setTimer((lifespan / 20.0) * 0.5, false);
}

simulated function tick(float delta) 
{
	drawScale += delta * exrate;
}

defaultproperties
{
   exrate=0.500000
   SSprites(0)=Texture'SLV2Textures.Smoke.blackcloud_a00'
   SSprites(1)=Texture'SLV2Textures.Smoke.blackcloud_a00'
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=2.000000
   Style=STY_Modulated
   Texture=Texture'SLV2Textures.Smoke.blackcloud_a00'
   DrawScale=8.000000
}
