class CannonPulseProj expands Projectile config (VMViper);

var() class<Effects> ExplSpriteEffect;
var byte Team;
var() byte LightH[4], LightS[4];

var() config int CannonDamage;
var() texture ProjFX01[4], ProjFX02[4];

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	Velocity = Speed * vector(Rotation);
	SetPulseColor();
}

function SetPulseColor()
{
	Damage = CannonDamage;
	Team = Instigator.PlayerReplicationInfo.Team;

	LightHue = LightH[Team];
	LightSaturation = LightS[Team];

	MultiSkins[0] = ProjFX01[Team];
	MultiSkins[1] = ProjFX02[Team];
}

function TakeDamage(int NDamage, pawn InstigatedBy, vector HitLocation, vector Momentum, name DType);

simulated function ProcessTouch (Actor Other, Vector HitLocation)
{
	if (Other != Instigator)
	{
		if (Role == Role_Authority)
			Other.TakeDamage(CannonDamage, Instigator, HitLocation, vect(0,0,0), MyDamageType);
		Explode(HitLocation, vect(0,0,1));
	}
}

function BlowUp(vector HitLocation)
{
   //HurtRadius(Damage , 20, MyDamageType, MomentumTransfer, HitLocation);
	Spawn(ExplSpriteEffect);
      MakeNoise(0.4);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	BlowUp(HitLocation);
	Destroy();
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=LodMesh'UnrealShare.DispM1'
	Style=STY_Translucent
	bBounce=False
	RemoteRole=ROLE_SimulatedProxy
	Damage=15
	MaxSpeed=8000.000000
	MomentumTransfer=5000
	MyDamageType=Energy
	speed=3550.000000
	DrawScale=0.500000
	bUnlit=True
	CollisionHeight=0.000000
	CollisionRadius=0.000000
	SoundVolume=60
	SoundRadius=80
	AmbientSound=Sound'UnrealShare.Dispersion.DispFly'
	ScaleGlow=3.000000
	LightBrightness=150
	LightHue=40
	LightSaturation=128
	LightEffect=LE_FireWaver
	LightRadius=4
	LightType=LT_Steady
	ExplosionDecal=None
	bNetTemporary=True
	LightH(0)=0
	LightS(0)=0
	LightH(1)=148
	LightS(1)=128
	LightH(2)=85
	LightS(2)=64
	LightH(3)=40
	LightS(3)=128
	ExplSpriteEffect=Class'CannonPulseExpl'
	CannonDamage=44
	ProjFX01(0)=Texture'UnrealShare.Effect1.FireEffect1p'
	ProjFX01(1)=Texture'UnrealShare.Effect1.FireEffect1u'
	ProjFX01(2)=Texture'UnrealShare.Effect1.FireEffect1a'
	ProjFX01(3)=Texture'UnrealShare.Effect1.FireEffect1e'
	ProjFX02(0)=Texture'UnrealShare.Effect1.FireEffect1ob'
	ProjFX02(1)=Texture'UnrealShare.Effect1.FireEffect1t'
	ProjFX02(2)=Texture'UnrealShare.Effect1.FireEffect1'
	ProjFX02(3)=Texture'UnrealShare.Effect1.FireEffect1d'
}
