class CarriedMissile expands Projectile config (VMViper);

#exec MESH IMPORT MESH=CarriedMissile ANIVFILE=MODELS\CarriedMissile_a.3d DATAFILE=MODELS\CarriedMissile_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=CarriedMissile STRENGTH=0
#exec MESH ORIGIN MESH=CarriedMissile X=0 Y=0 Z=0 YAW=128

#exec MESH SEQUENCE MESH=CarriedMissile SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=CarriedMissile SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=CarriedMissile MESH=CarriedMissile
#exec MESHMAP SCALE MESHMAP=CarriedMissile X=0.045 Y=0.045 Z=0.09

#exec TEXTURE IMPORT NAME=CarriedMissileSk01 FILE=CarriedMissileSk01.bmp GROUP=Skins FLAGS=2 MIPMAPS=OFF
#exec MESHMAP SETTEXTURE MESHMAP=CarriedMissile NUM=1 TEXTURE=CarriedMissileSk01

#exec TEXTURE IMPORT NAME=CarriedMissileSk02 FILE=CarriedMissileSk02.bmp GROUP=Skins FLAGS=2 MIPMAPS=OFF
#exec MESHMAP SETTEXTURE MESHMAP=CarriedMissile NUM=2 TEXTURE=CarriedMissileSk02

#exec TEXTURE IMPORT NAME=FXOff FILE=FXOff.bmp GROUP=Skins FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=CarriedMissile NUM=3 TEXTURE=FXOff

#exec AUDIO IMPORT NAME="JetMissileAmb" FILE=SOUNDS\JetMissileAmb.wav GROUP="CarryMissile"
#exec AUDIO IMPORT NAME="JetMissileSpawn" FILE=SOUNDS\JetMissileSpawn.wav GROUP="CarryMissile"

var bool bRing,bHitWater,bWaterStart;
var() bool bSeek;
var() config bool bTeamColored;
var() config int CheckRadius;

var Actor Seeking;
var float SeekDelay;

var JetMissileTrail Trail;

replication
{
	unreliable if (role == ROLE_Authority)
		Seeking,SeekDelay;
}

simulated function Destroyed()
{
	if (Trail != None)
		Trail.Destroy();

	Super.Destroyed();
}

simulated function PostBeginPlay()
{
   SetTimer(0.05, true);
}


simulated function Timer()       
{
   local ut_SpriteSmokePuff b;
	local vector x,y,z;
   local float bestDist, bestAim;
   local vector SeekingDir;
   local float MagnitudeVel;
	local actor other;
   local Pawn p;

	if (bSeek && SeekDelay >= 0.35)
	{
		If (Seeking==None)
     	{
         bestAim = 0.85;//0.93
			bestDist = CheckRadius;
         seeking = instigator.PickTarget(bestAim, bestDist, Normal(Velocity), Location);
     	}
     	If (Seeking != None  && Seeking != Instigator)
     	{
         SeekingDir = Normal(Seeking.Location - Location);
         MagnitudeVel = VSize(Velocity);
         Velocity =  MagnitudeVel * Normal(SeekingDir * 2.0 * MagnitudeVel + Velocity);
			SetRotation(rotator(Velocity));
     	}
	}

	if (!Region.Zone.bWaterZone)
	{
      b = Spawn(class'ut_SpriteSmokePuff');
      b.RemoteRole = ROLE_None;
	}
}

simulated function Tick(float DeltaTime)
{
	if (bSeek && SeekDelay < 0.35)
		SeekDelay += DeltaTime;
}

auto state Flying
{
   simulated function ZoneChange( Zoneinfo NewZone )
   {
      local waterring w;
        
      if (!NewZone.bWaterZone || bHitWater) 
			Return;

      bHitWater = True;
      if ( Level.NetMode != NM_DedicatedServer )
      {
         w = Spawn(class'WaterRing',,,,rot(16384,0,0));
         w.DrawScale = 0.2;
         w.RemoteRole = ROLE_None;
      }
      Velocity=0.6*Velocity;
   }

   simulated function ProcessTouch (Actor Other, Vector HitLocation)
   {
      if ( (Other != instigator) && (!Other.IsA('Projectile') || Other.bProjTarget))
         Explode(HitLocation,Normal(HitLocation-Other.Location));
   }

	function BlowUp(vector HitLocation)
	{
		HurtRadius(Damage, 300, MyDamageType, MomentumTransfer, HitLocation);
		MakeNoise(1.0);
	}

   simulated function Explode(vector HitLocation, vector HitNormal)
   {
      local CarriedMissileExpl s;
      local TShock t;

      s = spawn(class'CarriedMissileExpl',,,HitLocation + HitNormal*16);
      t = spawn(class'TShock',,, HitLocation + HitNormal, rotator(HitNormal));
      s.RemoteRole = ROLE_None;
      t.RemoteRole = ROLE_None;
      BlowUp(HitLocation);
      Destroy();
   }

   function BeginState()
   {
      local vector Dir;

      Dir = vector(Rotation);
      Velocity = speed * Dir;
      Acceleration = Dir * 50;

		if (bTeamColored && Instigator.PlayerReplicationInfo.Team <= 3)
		{
			if (Instigator.PlayerReplicationInfo.Team == 0)
			{
				Trail = Spawn(Class'RedJetMissileTrail',Self);
				LightHue = 0;
				LightSaturation = 0;
				MultiSkins[3] = Texture'RedXIgnition01';
			}
			else if (Instigator.PlayerReplicationInfo.Team == 1)
			{
				Trail = Spawn(Class'BlueJetMissileTrail',Self);
				LightHue = 170;
				LightSaturation = 127;
				MultiSkins[3] = Texture'BlueXIgnition01';
			}
			else if (Instigator.PlayerReplicationInfo.Team == 2)
			{
				Trail = Spawn(Class'GreenJetMissileTrail',Self);
				LightHue = 85;
				LightSaturation = 64;
				MultiSkins[3] = Texture'GreenXIgnition01';
			}
			else
			{
				Trail = Spawn(Class'YellowJetMissileTrail',Self);
				LightHue = 42;
				LightSaturation = 83;
				MultiSkins[3] = Texture'YellowXIgnition01';
			}
		}
		else
			Trail = Spawn(Class'JetMissileTrail',Self);

      if (Region.Zone.bWaterZone)
      {
         bHitWater = True;
         Velocity=0.6*Velocity;
      }
   }
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=CarriedMissile
	DrawScale=3.200000
	ExplosionDecal=class'Botpack.BlastMark'
	MyDamageType=MissileBlast
	speed=1350.000000
	MaxSpeed=2000.000000
	Damage=100.000000
	MomentumTransfer=200000
	SpawnSound=JetMissileSpawn
	RemoteRole=ROLE_SimulatedProxy
	AmbientGlow=96
	bUnlit=True
	SoundRadius=192
	SoundVolume=255
	SoundPitch=65
	AmbientSound=JetMissileAmb
	LightType=LT_Steady
	LightEffect=LE_NonIncidence
	LightBrightness=100
	LightHue=42
	LightSaturation=127
	LightRadius=6
	bBounce=False
	LifeSpan=0.000000
	bTeamColored=True
	MultiSkins(3)=XIgnition01
	bNetTemporary=False
	CheckRadius=256
}
