class CarriedMissileCarry expands Effects;

var vector PrePivotRel;
var byte GroupID, MissileID;
var float TimePingCount;

replication
{
	reliable if (ROLE == Role_Authority)
		PrePivotRel,GroupID, MissileID;
}

simulated function Tick(float DeltaTime)
{
local vector X, Y, Z;

	if (Owner != None)
	{
		GetAxes(Owner.Rotation, X, Y, Z);
		TimePingCount = 0;

		if (Owner.IsA('StrangeShell'))
		{
			if (GroupID == 1 && MissileID>StrangeShell(Owner).NormCmcX)
				Destroy();
			else if (GroupID == 2 && MissileID>StrangeShell(Owner).SeekCmcX)
				Destroy();
			else if (GroupID == 3 && MissileID>StrangeShell(Owner).RearCmcX)
				Destroy();
			else if (GroupID == 4 && StrangeShell(Owner).SpecialCount <= 0)
				Destroy();
		}
	}
	//A max of a 250ms acceptable, otherwise the jet crashes will look funny
	else if (TimePingCount < 0.25)
		TimePingCount += DeltaTime;
	else if (TimePingCount >= 0.25)
		Destroy();

	PrePivot = PrePivotRel.X*X + PrePivotRel.Y*Y + PrePivotRel.Z*Z;
}

defaultproperties
{
	DrawScale=3.200000
	bTrailerSameRotation=True
	bTrailerPrePivot=True
	DrawType=DT_Mesh
	Mesh=CarriedMissile
	RemoteRole=ROLE_SimulatedProxy
	Physics=PHYS_Trailer
}

