class DumbRocket expands Projectile config (VMViper);

var() int BlastRadius;
var RedeemerTrail Trail;
var class<SpriteGreenE> SpriteGreenEClass;
var class<StrangeExpl> StrangeExplClass;
var class<GreenSmokePuff> GreenSmokePuffClass;
var float CannonTimer, SmokeRate;
var bool bRing,bHitWater,bWaterStart;


simulated function Timer()
{
	local GreenSmokePuff b;

	if ( Trail == None )
		Trail = Spawn(class'RedeemerTrail',self);

	CannonTimer += SmokeRate;
	if ( CannonTimer > 0.6 )
		CannonTimer -= 0.6;

	if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
	{
		SetTimer(SmokeRate, false);
		Return;
	}

	if ( Level.bHighDetailMode )
	{
		if ( Level.bDropDetail )
			Spawn(class'GreenSmokePuff');
		else
			Spawn(class'GreenSmokePuff');
		SmokeRate = 152/Speed;
	}
	else
	{
		SmokeRate = 0.15;
		b = Spawn(class'GreenSmokePuff');
		b.RemoteRole = ROLE_None;
	}
	SetTimer(SmokeRate, false);
}

simulated function PostBeginPlay()
{
	SmokeRate = 0.3;
	SetTimer(0.3,false);
}

simulated function Destroyed()
{
	if ( Trail != None )
		Trail.Destroy();
	Super.Destroyed();
}

auto state Flying
{
	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;

		if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.2;
			w.RemoteRole = ROLE_None;
		}
	}

	function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( Other != instigator )
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	}

	function Explode(vector HitLocation, vector HitNormal)
	{
		local SpriteGreenE F;
		local WaveStrange r;
		local vector start;

		if ( Role < ROLE_Authority )
			return;

		HurtRadius(damage, BlastRadius, 'StrangeDeath', MomentumTransfer, HitLocation);
		start = Location + 10 * HitNormal;
		F = Spawn( class'SpriteGreenE',,,Start);
		r = Spawn(class'WaveStrange',,,HitLocation + HitNormal*16);

		RemoteRole = ROLE_SimulatedProxy;
		Destroy();
	}

	function BeginState()
	{
		local vector InitialDir;

		initialDir = vector(Rotation);
		if ( Role == ROLE_Authority )
			Velocity = speed*initialDir;
		Acceleration = initialDir*50;
	}
}

defaultproperties
{
   BlastRadius=20
   speed=800.000000
   Damage=1000.000000
   MomentumTransfer=100000
   SpawnSound=Sound'UnrealShare.Eightball.Ignite'
   ImpactSound=Sound'UnrealShare.Eightball.GrenadeFloor'
   bCanTeleport=True
   bNetTemporary=False
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=14.000000
   AmbientSound=Sound'Botpack.Redeemer.WarFly'
   AmbientGlow=51
   bUnlit=True
   SoundRadius=134
   SoundVolume=255
   SoundPitch=166
   CollisionRadius=2.000000
   CollisionHeight=2.000000
   LightType=LT_Steady
   LightEffect=LE_NonIncidence
   VolumeBrightness=3
}
