class FlashDevice expands Projectile;

#exec MESH IMPORT MESH=FlashDevice ANIVFILE=MODELS\FlashDevice_a.3d DATAFILE=MODELS\FlashDevice_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=FlashDevice STRENGTH=0
#exec MESH ORIGIN MESH=FlashDevice X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FlashDevice SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FlashDevice SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=FlashDevice MESH=FlashDevice
#exec MESHMAP SCALE MESHMAP=FlashDevice X=0.05 Y=0.05 Z=0.1

#exec TEXTURE IMPORT NAME=FXOff FILE=FXOff.bmp GROUP=Skins FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=FlashDevice NUM=1 TEXTURE=FXOff

#exec TEXTURE IMPORT NAME=MetalShine FILE=SKINS\MetalShine.bmp GROUP=Skins FLAGS=2 LODSET=2

#exec AUDIO IMPORT NAME="FlashSnd" FILE=SOUNDS\FlashSnd.wav GROUP="Specials"

simulated function PostBeginPlay()
{
	local PlayerPawn P;

	Spawn(Class'FlashCorona',Self);
	PlaySound(Sound'FlashSnd',,30.0);
	SetTimer(1.0, False);

	Velocity = vect(0,0,80);

	if (Role == ROLE_Authority)
	{
		ForEach VisibleCollidingActors(Class'PlayerPawn', P, 1024)
		{
			if (P.CanSee(Self) && P.PlayerReplicationInfo.Team != Instigator.PlayerReplicationInfo.Team)
				P.ClientFlash( 4, 100 * vect(75,75,75));
		}
	}
}

simulated function Timer()
{
	Destroy();
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=FlashDevice
	bMeshEnviroMap=True
	Texture=MetalShine
	Physics=PHYS_Projectile
	RemoteRole=ROLE_SimulatedProxy
	Mass=2.000000
	bFixedRotationDir=True
	RotationRate=(Pitch=48000,Yaw=48000,Roll=48000)
	bCollideActors=False
	bCollideWorld=False
	bProjTarget=False
}
