// Makes the fuel cores glow.
class Fuelglow extends SLSmoke;

var float fadet;

function postBeginPlay() 
{
	//setTimer(0.5, false);
}

function tick(float delta) 
{
	if (fadet < 0.5) 
	{
		fadet = fmin(0.5, fadet + delta);
		drawScale = default.drawScale * fadet * 2;
	} 
	else disable('tick');
}

function fade () 
{
	if (!isInState('Fadeout'))
		gotoState('Fadeout');
}

state Fadeout 
{
	function beginState() 
	{
		fadet = 0;
	}

	function tick(float delta) 
	{
		if (fadet < 0.5) 
		{
			fadet += delta;
			scaleGlow = default.scaleGlow * (1.0 - fadet / 0.5);
		} 
		else destroy();
	}
}

defaultproperties
{
   Physics=PHYS_Trailer
   LifeSpan=0.000000
   Texture=Texture'SLV2Textures.exhaust.Fuelglow'
   DrawScale=0.800000
   AmbientGlow=255
}
