// Fuel core riser. Client-only in network games.
class Fuelpod extends Effects;

var Fuelcore core;
var bool bOpen;

var Util u;

function postBeginPlay() 
{
	u = spawn(Class'Util', self);
	u.setDebugLevel(DL_Verbose);

	core = Fuelcore(owner);
	if (core != none)
		setTimer(core.hoverTimer, true);

	super.postBeginPlay();
}

// Returns true if there is a valid pawn in the core's hover radius.
function bool in() 
{
	local Pawn p;
	
	if (core != none) 
	{
		foreach radiusActors(class'Pawn', p, core.hoverRadius) 
		{
			if (validActor(p)) 
				return true;
		}
	}
	return false;
}

// Check to see if we should open or close.
function timer() 
{
	if (in()) 
	{
		if (core != none && !core.bHover && !core.bHidden && !bOpen)
			open();
	} 
	else 
	{
		if (core.bHover && !core.bHidden && bOpen)
			close();
	}
}

// Core has just entered the pickup state. See if we should pop it up.
function touchCheck() 
{
	local Pawn p;

	if (!bOpen && in())
		open();
}

function open() 
{
	u.debug("open()");

	bOpen = true;
	playAnim('opening');
	core.startHover();
}

function close() 
{
	u.debug("close()");

	bOpen = false;
	playAnim('closing');
	core.stopHover();
}

function bool validActor(Actor a) 
{
	return (a.bIsPawn && Pawn(a).bIsPlayer && (Pawn(a).health > 0) && !Pawn(a).playerReplicationInfo.bIsSpectator);
}

function destroyed() 
{
	u.debug("destroyed()");
}

defaultproperties
{
   RemoteRole=ROLE_None
   DrawType=DT_Mesh
   Mesh=SkeletalMesh'SLV2Models.fpod'
}
