class HeadShotExpl expands Effects;

#exec MESH IMPORT MESH=HeadShotExpl ANIVFILE=MODELS\HeadShotExpl_a.3d DATAFILE=MODELS\HeadShotExpl_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=HeadShotExpl STRENGTH=0.75
#exec MESH ORIGIN MESH=HeadShotExpl X=0 Y=0 Z=195

#exec MESH SEQUENCE MESH=HeadShotExpl SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=HeadShotExpl SEQ=BlowUp STARTFRAME=0 NUMFRAMES=30 RATE=30.0

#exec MESHMAP NEW MESHMAP=HeadShotExpl MESH=HeadShotExpl
#exec MESHMAP SCALE MESHMAP=HeadShotExpl X=0.2 Y=0.2 Z=0.4

#exec TEXTURE IMPORT NAME=NoBlood FILE=EFFECTS\NoBlood.bmp GROUP=Blood FLAGS=2

#exec AUDIO IMPORT NAME="HeadShotA" FILE=SOUNDS\HeadShotA.wav GROUP="HeadShots"
#exec AUDIO IMPORT NAME="HeadShotB" FILE=SOUNDS\HeadShotB.wav GROUP="HeadShots"

var() sound HeadBlowSound[2];

var float Count;
var byte Sk;

simulated function PostBeginPlay()
{
	local byte i;

	PlayAnim('BlowUp', 1/Default.LifeSpan, 0.05);
	Velocity = vect(0,0,250);
	MakeSound();
}

simulated function Tick(float Delta)
{
	Count += Delta;
	if (Count >= Default.LifeSpan/8)
	{
		Count = 0;
		if (Sk < 8)
			MultiSkins[Sk] = Texture'NoBlood';
		Sk++;
	}
}

function MakeSound()
{
	PlaySound(HeadBlowSound[Rand(2)],,60.0,,1000);
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=HeadShotExpl
	Physics=PHYS_Falling
	bUnlit=True
	RemoteRole=ROLE_SimulatedProxy
	bParticles=True
	bRandomFrame=True
	Style=STY_Masked
	HeadBlowSound(0)=HeadShotA
	HeadBlowSound(1)=HeadShotB
	Texture=Texture'Botpack.Blood.BD3'
	MultiSkins(0)=Texture'Botpack.Blood.BD3'
	MultiSkins(1)=Texture'Botpack.Blood.BD4'
	MultiSkins(2)=Texture'Botpack.Blood.BD6'
	MultiSkins(3)=Texture'Botpack.Blood.BD9'
	MultiSkins(4)=Texture'Botpack.Blood.BD10'
	MultiSkins(5)=Texture'Botpack.Blood.BD3'
	MultiSkins(6)=Texture'Botpack.Blood.BD4'
	MultiSkins(7)=Texture'Botpack.Blood.BD6'
	DrawScale=0.450000
	LifeSpan=1.000000
	ScaleGlow=1.500000
}
