class HeatSeeker expands Projectile;

#exec MESH IMPORT MESH=HeatSeeker ANIVFILE=MODELS\HeatSeeker_a.3d DATAFILE=MODELS\HeatSeeker_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=HeatSeeker STRENGTH=0
#exec MESH ORIGIN MESH=HeatSeeker X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=HeatSeeker SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=HeatSeeker SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=HeatSeeker MESH=HeatSeeker
#exec MESHMAP SCALE MESHMAP=HeatSeeker X=0.075 Y=0.075 Z=0.15

#exec TEXTURE IMPORT NAME=HeatSeekerSk FILE=HeatSeekerSk.bmp GROUP=Skins FLAGS=2 MIPMAPS=OFF
#exec MESHMAP SETTEXTURE MESHMAP=HeatSeeker NUM=1 TEXTURE=HeatSeekerSk

#exec AUDIO IMPORT NAME="Flamming" FILE=SOUNDS\Flamming.wav GROUP="Specials"

var bool bHitWater;
var() bool bThrownSeeker;
var() float HeatRadius;

simulated function PostBeginPlay()
{
   local vector X,Y,Z;
   local rotator RandRot;

   Super.PostBeginPlay();

	if (bThrownSeeker)
	{
		SetPhysics(PHYS_Projectile);
		Velocity = -vector(Rotation) * speed;
		Acceleration = -vector(Rotation) * 50;
	}
	else
	{
		Velocity = vect(0,0,-1) * speed;
		Acceleration = vect(0,0,-1) * 50;
      RandSpin(50000);
	}
   bHitWater = True;
   Velocity=0.6*Velocity;
	SetTimer(0.1, False);
}

function CheckMissiles()
{
	local CarriedMissile CM;
	local AntiSlv ANuke;

	ForEach VisibleCollidingActors(Class'CarriedMissile', CM, HeatRadius)
	{
		if (Instigator.PlayerReplicationInfo.Team != CM.Instigator.PlayerReplicationInfo.Team)
			CM.Seeking = Self;
	}

	ForEach VisibleCollidingActors(Class'AntiSlv', ANuke, HeatRadius)
	{
		if (Instigator.PlayerReplicationInfo.Team != CM.Instigator.PlayerReplicationInfo.Team)
			ANuke.Seeking = Self;
	}
}

simulated function ZoneChange( Zoneinfo NewZone )
{
   local waterring w;
    
   if (!NewZone.bWaterZone || bHitWater)
	 	Return;

   bHitWater = True;
   w = Spawn(class'WaterRing',,,,rot(16384,0,0));
   w.DrawScale = 0.2;
   w.RemoteRole = ROLE_None;
   Velocity=0.6*Velocity;
}

simulated function Timer()
{
	local HeatFlames hf;

	if (AmbientSound == None)
	{
		CheckMissiles();
		AmbientSound = Sound'Flamming';
		SetTimer(0.05, True);
	}
	hf = Spawn(Class'HeatFlames');
	hf.RemoteRole = ROLE_None;
}

simulated function Landed( vector HitNormal )
{
   LifeSpan = 3.0;
   HitWall( HitNormal, None );
}

simulated function ProcessTouch( actor Other, vector HitLocation );

simulated function HitWall( vector HitNormal, actor Wall )
{
   SetPhysics(PHYS_Falling);
   Velocity = 0.75*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
   RandSpin(100000);
   speed = VSize(Velocity);
   if ( Level.NetMode != NM_DedicatedServer )
      PlaySound(ImpactSound, SLOT_Misc, 1.5 );
   if ( Velocity.Z > 400 )
      Velocity.Z = 0.5 * (400 + Velocity.Z);
   else if ( speed < 20 )
   {
		LifeSpan = 3.0;
      bBounce = False;
      SetPhysics(PHYS_None);
   }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation,vector momentum, name damageType )
{
   if (NDamage > 5)
      Destroy();
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=HeatSeeker
	DrawScale=1.000000
	bFixedRotationDir=True
	DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
	speed=1550.000000
	MaxSpeed=1000.000000
	ImpactSound=Sound'Unrealshare.Eightball.GrenadeFloor'
	Physics=PHYS_Projectile
	RemoteRole=ROLE_SimulatedProxy
	bProjTarget=True
	CollisionRadius=5.000000
	CollisionHeight=5.000000
	AmbientSound=None
	SoundRadius=64
	SoundVolume=80
	SoundPitch=75
	HeatRadius=3072.000000
}
