class JetCtrlBurners expands Effects;

#exec MESH IMPORT MESH=JetCtrlBurners ANIVFILE=MODELS\JetCtrlBurners_a.3d DATAFILE=MODELS\JetCtrlBurners_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=JetCtrlBurners STRENGTH=0
#exec MESH ORIGIN MESH=JetCtrlBurners X=40 Y=0 Z=-80

#exec MESH SEQUENCE MESH=JetCtrlBurners SEQ=All STARTFRAME=0 NUMFRAMES=4
#exec MESH SEQUENCE MESH=JetCtrlBurners SEQ=Shrink STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=JetCtrlBurners SEQ=Grow STARTFRAME=1 NUMFRAMES=2
#exec MESH SEQUENCE MESH=JetCtrlBurners SEQ=TC STARTFRAME=3 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=JetCtrlBurners MESH=JetCtrlBurners
#exec MESHMAP SCALE MESHMAP=JetCtrlBurners X=0.045 Y=0.045 Z=0.09

#exec OBJ LOAD FILE=Textures\XAfterBurners.utx PACKAGE=VMViper.Burners

#exec MESHMAP SETTEXTURE MESHMAP=JetCtrlBurners NUM=1 TEXTURE=XIgnition01
#exec MESHMAP SETTEXTURE MESHMAP=JetCtrlBurners NUM=2 TEXTURE=XIgnition01

var() texture BurnerFX;
var StrangeShell XNXShell;
var float TimePingCount;

simulated function Tick(float DeltaTime)
{
	XNXShell = StrangeShell(Owner);

	if (XNXShell != None)
	{
		TimePingCount = 0;
		if (!XNXShell.bMarchPlaying && !XNXShell.bAfterburn)
		{
			AnimSequence = 'Grow';
			AnimFrame = VSize(XNXShell.Velocity) / 2 / XNXShell.FullSpeed;
			MultiSkins[1] = BurnerFX;
			MultiSkins[2] = Texture'FXOff';
		}
		else if (!XNXShell.bMarchPlaying && XNXShell.bAfterburn)
		{
			MultiSkins[2] = BurnerFX;
			MultiSkins[1] = Texture'FXOff';
		}
		else if (XNXShell.bMarchPlaying && !XNXShell.bAfterburn)
		{
			AnimSequence = 'Grow';
			AnimFrame = VSize(XNXShell.Velocity) / 2 / XNXShell.FullSpeed;
			MultiSkins[1] = BurnerFX;
			MultiSkins[2] = BurnerFX;
		}
		else
		{
			AnimSequence = 'TC';
			AnimFrame = 0;
			MultiSkins[1] = BurnerFX;
			MultiSkins[2] = BurnerFX;
		}

		if (XNXShell.bNoFuel)
			Destroy();
	}
	//A max of a 250ms acceptable, otherwise the jet crashes will look funny
	else if (TimePingCount < 0.25)
		TimePingCount += DeltaTime;
	else if (TimePingCount >= 0.25)
		Destroy();
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=JetCtrlBurners
	DrawScale=3.200000
	ScaleGlow=0.800000
	RemoteRole=ROLE_SimulatedProxy
	bUnlit=True
	Style=STY_Translucent
	Physics=PHYS_Trailer
	bTrailerSameRotation=True
	bNetTemporary=False
}
