/** Used for jump detection, so we can eject riders and gunners. Checks for jump boots in the inventory and tries to manage
    the bCountJumps variable which we need to be set to true. After jump boots where off they set it to false. Only used in standalone games.
*/
class JumpDetector extends TournamentPickup;

var StrangeShell sl;
var Util u;

function postBeginPlay() 
{
   u = spawn(Class'Util', self);
   u.setDebugLevel(DL_Verbose);
   super.postBeginPlay();
}

state Activated 
{
begin:
   Pawn(owner).bCountJumps = true;
}

/** This is called from PlayerPawn.doJump(), normally used for jump boots. bCountJumps is set for the rider every tick so any jump boots
    don't get in the way. Once we've ejected, we look for jump boots. If none, set it to false.
*/
function ownerJumped() 
{
   u.debug("ownerJumped()");

   if (sl != none) 
      sl.eject(owner, 1);

   if (inventory != none)
      inventory.ownerJumped();
}

/** We could make this a timer but it's for standalone games only, and even for just that one split second you wouldn't have been
    able to eject, it'll be worth it.
*/
function tick(float delta) 
{
   Pawn(owner).bCountJumps = true;
}

function destroyed()
{
   local Inventory jb;

   jb = Pawn(owner).findInventoryType(class'UT_JumpBoots');
   if (jb == none)
      Pawn(owner).bCountJumps = false;

   super.destroyed();
}

defaultproperties
{
}
