
class Konglauncher extends SLWeapon config (VMViper);

//1st person with missile
#exec MESH IMPORT MESH=NukeLauncher ANIVFILE=MODELS\NukeLauncherOne_a.3d DATAFILE=MODELS\NukeLauncherOne_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=NukeLauncher STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncher X=0 Y=0 Z=0 YAW=128

//1st person right handed with missile
#exec MESH IMPORT MESH=NukeLauncherR ANIVFILE=MODELS\NukeLauncherOne_a.3d DATAFILE=MODELS\NukeLauncherOne_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=NukeLauncherR STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherR X=0 Y=0 Z=0

//1st person with no missile
#exec MESH IMPORT MESH=NukeLauncherW ANIVFILE=MODELS\NukeLauncherM_a.3d DATAFILE=MODELS\NukeLauncherM_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=NukeLauncherW STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherW X=0 Y=0 Z=0 YAW=128

//1st person right handed with no missile
#exec MESH IMPORT MESH=NukeLauncherRW ANIVFILE=MODELS\NukeLauncherM_a.3d DATAFILE=MODELS\NukeLauncherM_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=NukeLauncherRW STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherRW X=0 Y=0 Z=0

//Pickup with missile
#exec MESH IMPORT MESH=NukeLauncherPick ANIVFILE=MODELS\NukeLauncherOne_a.3d DATAFILE=MODELS\NukeLauncherOne_d.3d X=0 Y=0 Z=0
//#exec MESH LODPARAMS MESH=NukeLauncherPick STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherPick X=0 Y=0 Z=0 YAW=128

//Pickup with no missile
#exec MESH IMPORT MESH=NukeLauncherPickW ANIVFILE=MODELS\NukeLauncherM_a.3d DATAFILE=MODELS\NukeLauncherM_d.3d X=0 Y=0 Z=0
//#exec MESH LODPARAMS MESH=NukeLauncherPickW STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherPickW X=0 Y=0 Z=0 YAW=128

//3rd person with missile
#exec MESH IMPORT MESH=NukeLauncherM ANIVFILE=MODELS\NukeLauncherOne_a.3d DATAFILE=MODELS\NukeLauncherOne_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=NukeLauncherM STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherM X=608 Y=0 Z=-78 YAW=128

//3rd person with no missile
#exec MESH IMPORT MESH=NukeLauncherMW ANIVFILE=MODELS\NukeLauncherM_a.3d DATAFILE=MODELS\NukeLauncherM_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=NukeLauncherMW STRENGTH=0
#exec MESH ORIGIN MESH=NukeLauncherMW X=608 Y=0 Z=-78 YAW=128

//Animations
#exec MESH SEQUENCE MESH=NukeLauncher SEQ=All STARTFRAME=0 NUMFRAMES=22
#exec MESH SEQUENCE MESH=NukeLauncher SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeLauncher SEQ=Fire STARTFRAME=0 NUMFRAMES=17 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncher SEQ=Down STARTFRAME=12 NUMFRAMES=5 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncher SEQ=Select STARTFRAME=16 NUMFRAMES=5 RATE=7.0 GROUP=Select
#exec MESH SEQUENCE MESH=NukeLauncher SEQ=Lock STARTFRAME=20 NUMFRAMES=2 RATE=1.0

#exec MESH SEQUENCE MESH=NukeLauncherR SEQ=All STARTFRAME=0 NUMFRAMES=22
#exec MESH SEQUENCE MESH=NukeLauncherR SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeLauncherR SEQ=Fire STARTFRAME=0 NUMFRAMES=17 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncherR SEQ=Down STARTFRAME=12 NUMFRAMES=5 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncherR SEQ=Select STARTFRAME=16 NUMFRAMES=5 RATE=7.0 GROUP=Select
#exec MESH SEQUENCE MESH=NukeLauncherR SEQ=Lock STARTFRAME=20 NUMFRAMES=2 RATE=1.0

#exec MESH SEQUENCE MESH=NukeLauncherW SEQ=All STARTFRAME=0 NUMFRAMES=22
#exec MESH SEQUENCE MESH=NukeLauncherW SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeLauncherW SEQ=Fire STARTFRAME=0 NUMFRAMES=17 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncherW SEQ=Down STARTFRAME=12 NUMFRAMES=5 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncherW SEQ=Select STARTFRAME=16 NUMFRAMES=5 RATE=7.0 GROUP=Select
#exec MESH SEQUENCE MESH=NukeLauncherW SEQ=Lock STARTFRAME=20 NUMFRAMES=2 RATE=1.0

#exec MESH SEQUENCE MESH=NukeLauncherRW SEQ=All STARTFRAME=0 NUMFRAMES=22
#exec MESH SEQUENCE MESH=NukeLauncherRW SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeLauncherRW SEQ=Fire STARTFRAME=0 NUMFRAMES=17 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncherRW SEQ=Down STARTFRAME=12 NUMFRAMES=5 RATE=14.0
#exec MESH SEQUENCE MESH=NukeLauncherRW SEQ=Select STARTFRAME=16 NUMFRAMES=5 RATE=7.0 GROUP=Select
#exec MESH SEQUENCE MESH=NukeLauncherRW SEQ=Lock STARTFRAME=20 NUMFRAMES=2 RATE=1.0

#exec MESH SEQUENCE MESH=NukeLauncherPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESH SEQUENCE MESH=NukeLauncherPickW SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESH SEQUENCE MESH=NukeLauncherM SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeLauncherM SEQ=Fire STARTFRAME=0 NUMFRAMES=13 RATE=14.0

#exec MESH SEQUENCE MESH=NukeLauncherMW SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NukeLauncherMW SEQ=Fire STARTFRAME=0 NUMFRAMES=13 RATE=14.0

//Scale
#exec MESHMAP NEW MESHMAP=NukeLauncher MESH=NukeLauncher
#exec MESHMAP SCALE MESHMAP=NukeLauncher X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherR MESH=NukeLauncherR
#exec MESHMAP SCALE MESHMAP=NukeLauncherR X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherRW MESH=NukeLauncherRW
#exec MESHMAP SCALE MESHMAP=NukeLauncherRW X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherW MESH=NukeLauncherW
#exec MESHMAP SCALE MESHMAP=NukeLauncherW X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherPick MESH=NukeLauncherPick
#exec MESHMAP SCALE MESHMAP=NukeLauncherPick X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherPickW MESH=NukeLauncherPickW
#exec MESHMAP SCALE MESHMAP=NukeLauncherPickW X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherM MESH=NukeLauncherM
#exec MESHMAP SCALE MESHMAP=NukeLauncherM X=0.05 Y=0.05 Z=0.1

#exec MESHMAP NEW MESHMAP=NukeLauncherMW MESH=NukeLauncherMW
#exec MESHMAP SCALE MESHMAP=NukeLauncherMW X=0.05 Y=0.05 Z=0.1

//Skins
#exec TEXTURE IMPORT NAME=XNukeSk FILE=XNukeSk.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncher NUM=1 TEXTURE=XNukeSk
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherR NUM=1 TEXTURE=XNukeSk
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPick NUM=1 TEXTURE=XNukeSk
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherM NUM=1 TEXTURE=XNukeSk

#exec TEXTURE IMPORT NAME=XLauncherSk01 FILE=SKINS\XLauncherSk01.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherW NUM=1 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherRW NUM=1 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPickW NUM=1 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherMW NUM=1 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncher NUM=2 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherR NUM=2 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPick NUM=2 TEXTURE=XLauncherSk01
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherM NUM=2 TEXTURE=XLauncherSk01

#exec TEXTURE IMPORT NAME=XLauncherSk02L FILE=SKINS\XLauncherSk02L.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherW NUM=2 TEXTURE=XLauncherSk02L
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPickW NUM=2 TEXTURE=XLauncherSk02L
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherMW NUM=2 TEXTURE=XLauncherSk02L
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncher NUM=3 TEXTURE=XLauncherSk02L
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPick NUM=3 TEXTURE=XLauncherSk02L
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherM NUM=3 TEXTURE=XLauncherSk02L

#exec TEXTURE IMPORT NAME=XLauncherSk02R FILE=SKINS\XLauncherSk02R.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherRW NUM=2 TEXTURE=XLauncherSk02R
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherR NUM=3 TEXTURE=XLauncherSk02R

#exec TEXTURE IMPORT NAME=XLauncherSk03 FILE=SKINS\XLauncherSk03.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherW NUM=3 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherRW NUM=3 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPickW NUM=3 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherMW NUM=3 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncher NUM=4 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherR NUM=4 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPick NUM=4 TEXTURE=XLauncherSk03
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherM NUM=4 TEXTURE=XLauncherSk03

#exec TEXTURE IMPORT NAME=MetalShineBlood FILE=SKINS\MetalShineBlood.bmp GROUP=Skins FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherW NUM=4 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherRW NUM=4 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPickW NUM=4 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherMW NUM=4 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncher NUM=5 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherR NUM=5 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherPick NUM=5 TEXTURE=MetalShineBlood
#exec MESHMAP SETTEXTURE MESHMAP=NukeLauncherM NUM=5 TEXTURE=MetalShineBlood

//Icons
#exec TEXTURE IMPORT NAME=NukeIconWings FILE=NukeIconWings.bmp GROUP=Icons MIPS=OFF
#exec TEXTURE IMPORT NAME=TargetLocked FILE=TargetLocked.bmp GROUP=Icons MIPS=OFF

//Sounds
#exec AUDIO IMPORT NAME="NukeFire" FILE=SOUNDS\NukeFire.wav GROUP="NukeLauncher"
#exec AUDIO IMPORT NAME="NukePick" FILE=SOUNDS\NukePick.wav GROUP="NukeLauncher"
#exec AUDIO IMPORT NAME="NukeSelect" FILE=SOUNDS\NukeSelect.wav GROUP="NukeLauncher"
#exec AUDIO IMPORT NAME="XNXAlt" FILE=SOUNDS\XNXAlt.wav GROUP="NukeLauncher"

var Fuelcore fc;                              // Keeps track of fuel cores for the ret HUD.
var vector launchv;                              // Owner velocity at launch.
var float lastFired;                         // Bots should only fire every so often...
var SkyNet skynet;
var SkyNode launchsn;                         // Our onramp onto the network.
var() config bool bNeverStay;
var bool bClear;
var float clearanceStamp;
var() config string teamSLClass[4];
var UT_ShieldBeltEffect MyEffect;
var() config bool bForceLaunchPuff;
var bool bPendingLock;
var Actor LockedTarget, NewTarget, OldTarget;
var byte Teams;
var bool bUsedNXLaunch;
var() config float CustomRespawnTime;

replication 
{
	reliable if (role == ROLE_Authority && bNetOwner)
		bClear, bUsedNXLaunch;
}

function PreBeginPlay()
{
	RespawnTime = Default.CustomRespawnTime;
	Super.PreBeginPlay();
}

simulated event RenderOverlays( canvas Canvas )
{
   local rotator NewRot;
   local bool bPlayerOwner;
   local int Hand;
   local PlayerPawn PlayerOwner;

   if ( bHideWeapon || (Owner == None) )
      return;

   PlayerOwner = PlayerPawn(Owner);

   if ( PlayerOwner != None )
   {
      if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
         return;
      bPlayerOwner = true;
      Hand = PlayerOwner.Handedness;

      if (  (Level.NetMode == NM_Client) && (Hand == 2) )
      {
         bHideWeapon = true;
         return;
      }
   }

   if ( !bPlayerOwner || (PlayerOwner.Player == None) )
      Pawn(Owner).WalkBob = vect(0,0,0);

   if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
   {
      MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
      if ( !bSetFlashTime )
      {
         bSetFlashTime = true;
         FlashTime = Level.TimeSeconds + FlashLength;
      }
      else if ( FlashTime < Level.TimeSeconds )
         bMuzzleFlash = 0;
      if ( bMuzzleFlash > 0 )
      {
         if ( Hand == 0 )
            Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
         else
            Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

         Canvas.Style = 3;
         Canvas.DrawIcon(MFTexture, MuzzleScale);
         Canvas.Style = 1;
      }
   }
   else bSetFlashTime = false;

   SetLocation( Owner.Location + CalcDrawOffset() );
   NewRot = Pawn(Owner).ViewRotation;

   if ( Hand == 0 )
      newRot.Roll = -2 * Default.Rotation.Roll;
   else
      newRot.Roll = Default.Rotation.Roll * Hand;

   setRotation(newRot);
   Canvas.DrawActor(self, false,True);
}

function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
	{
		Mesh = mesh'NukeLauncher';
		PlayerViewMesh = mesh'NukeLauncher';
	}
	else
	{
		Mesh = mesh'NukeLauncherR';
		PlayerViewMesh = mesh'NukeLauncherR';
	}
}

// Set the projectile classes based on team.
function bringUp() 
{
   local PlayerReplicationInfo pri;
     
	// Teams alternate rocket types.
   if (Pawn(owner) != none) 
	{
      pri = Pawn(owner).playerReplicationInfo;
      projectileClass = (Class'AntiSLV');

		if (pri.team>3) 
			pri.team = 3;
       
      altProjectileClass = Class<Projectile>(dynamicLoadObject(Class'StrangeMutator'.default.NXPackName $ teamSLClass[pri.team], Class'Class'));
   }
   super.bringup();
}

state Idle 
{
	simulated function timer() 
	{
	  	super.timer();
	  	NewTarget = CheckTarget();
      if ( NewTarget == OldTarget )
	  	{
	      LockedTarget = NewTarget;
	      If (LockedTarget != None)
	      {
	         bLockedOn=True;
		     	Owner.MakeNoise(Pawn(Owner).SoundDampening);
		     	Owner.PlaySound(Misc1Sound, SLOT_None,Pawn(Owner).SoundDampening);
		     	if ( (Pawn(LockedTarget) != None) && (FRand() < 0.7) )
			  		Pawn(LockedTarget).WarnTarget(Pawn(Owner), ProjectileSpeed, vector(Pawn(Owner).ViewRotation));
		     	if ( bPendingLock )
		     	{
			 		oldTarget = NewTarget;
		         Pawn(Owner).bFire = 0;
		         GotoState('Fire', 'Begin');
		         return;
            }
			}
	  	}
	  	else if( (OldTarget != None) && (NewTarget == None) )
	  	{
	      Owner.PlaySound(Misc2Sound, SLOT_None,Pawn(Owner).SoundDampening);
	      bLockedOn = False;
      }
      else
      {
	      LockedTarget = None;
	      bLockedOn = False;
      }
      OldTarget = NewTarget;
      bPendingLock = false;
   }
Begin:
   if (Pawn(Owner).bFire!=0)
	  	Fire(0.0);
   if (Pawn(Owner).bAltFire!=0) 
		AltFire(0.0);
   bPointing=False;
   if (AmmoType.AmmoAmount<=0)
	Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
   OldTarget = CheckTarget();
   SetTimer(0.75,True);  //1.25
   LockedTarget = None;
   bLockedOn = False;
PendingLock:
	if ( bPendingLock )
	   bPointing = true;
	if ( TimerRate <= 0 )
	   SetTimer(0.5, true); //1.0
}

simulated function PostRender(canvas Canvas)
{
   local float XScale;

   Super.PostRender(Canvas);
   bOwnsCrossHair = bLockedOn;
   if ( bOwnsCrossHair )
   {
      // if locked on, draw special crosshair
      XScale = FMax(1.25, Canvas.ClipX/640.0);
      Canvas.SetPos(0.525 * (Canvas.ClipX - Texture'TargetLocked'.USize * XScale), 0.525 * (Canvas.ClipY - Texture'TargetLocked'.VSize * XScale));
      Canvas.Style = ERenderStyle.STY_Translucent;
      Canvas.DrawIcon(Texture'TargetLocked', 1.25);
      Canvas.Style = 1.25;
   }
}

// Function for bots. Returns true if they should ride a rocket. Not simulated so we don't need the role check.
function bool useAltFire(Bot b) 
{
   local BotReplicationInfo bri;
	local StrangeShell sl;

	u.debug("useAltFire(): ammo: " $ ammoLeft() $ " enemy: " $ b.enemy $ " orders: " $ b.orders);

	bri = BotReplicationInfo(b.playerReplicationInfo);

	// Only used in CTF and assault gametypes. And for assault, only if they're attacking.
	if (!(level.game.isA('CTFGame') || (level.game.isA('Assault') && bri.team == Assault(level.game).attacker.teamIndex)))
		return false;

	if (!ammoLeft() || b.enemy != none)
		return false;

	// Which? FIX.
	if (bri.realOrders == 'Defend' || bri.realOrders == 'Follow')
		return false;

	// Not if we're already riding one.
	if (Class<StrangeShell>(projectileClass) != None)
	{
	 	foreach b.radiusActors(Class'StrangeShell', sl, vsize(Class<StrangeShell>(projectileClass).default.pilotOffset) * 2.0) 
		{
		  	if (sl.getPilot() == b || sl.getGunner() == b)
				return false;
	 	}
	}
	return true;
}

function spawnSkyNet() 
{
	foreach allActors(Class'SkyNet', skynet)
		break;

	// Spawn it!
	if (skynet == none)
		skynet = spawn(Class'SkyNet');
}

// Needed to add fuel core count to the HUD.
simulated function setRetMsgs() 
{
   super.setRetMsgs();

   if (!bClear && (level.timeseconds - clearanceStamp < 1.5)) 
		retmsg = "no clearance!";

   if (fc == none)
      fc = Fuelcore(Pawn(owner).findInventoryType(class'Fuelcore'));
   if (fc != none && fc.ammoAmount > 0)
      retmsg2 = "cores " $ fc.ammoAmount;
}

// The Redeemer never stays.
function setWeaponStay() 
{
	if (bNeverStay)
	   bWeaponStay = false;
	else
	   super.setWeaponStay();
}

// Launch puffs spawned on the server.
function spawnPuff() 
{
   local vector x, y, z;

   if (bForceLaunchPuff == true)
	{
      getAxes(owner.rotation, x, y, z);
      spawn(class'LaunchPuff',,, owner.location + x * 80, rotation);
   } 
	else if (level.bHighDetailMode && !level.bDropDetail && level.netmode != NM_DedicatedServer) 	 
	{
      // Place it in view.
      getAxes(owner.rotation, x, y, z);
      spawn(class'LaunchPuff',,, owner.location + x * 80, rotation);
   }
}

// If we had a successful launch, spawn the puff.
function fire(float v) 
{
   local Vector Start, X,Y,Z;
    
	lastFired = level.timeseconds;
 	if ( AmmoType == None )
		GiveAmmo(Pawn(Owner));

	if (AmmoType.UseAmmo(1))
	{
      bPointing=true;
      bCanClientFire=true;
      GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
      Start = Owner.Location + CalcDrawOffset();
      Spawn(Class'WeaponLight',,'',Start+X*20,rot(0,0,0));
      Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
      AdjustedAim = pawn(owner).AdjustToss(ProjectileSpeed, Start, AimError,true,bWarnTarget);

    	if ( Pawn(Owner).PlayerReplicationInfo.Team == 0 ) 
        	Spawn(class'AntiSlv',,, Start,AdjustedAim);

	 	if ( Pawn(Owner).PlayerReplicationInfo.Team == 1 )
        	Spawn(class'AntiSlv',,, Start,AdjustedAim);

      if ( Pawn(Owner).PlayerReplicationInfo.Team == 2 )
        	Spawn(class'AntiSlv',,, Start,AdjustedAim);

      if ( Pawn(Owner).PlayerReplicationInfo.Team == 3 )
        	Spawn(class'AntiSlv',,, Start,AdjustedAim);
	}
	if (lastProj != none)
      spawnPuff();
   if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) )
    	Pawn(Owner).SwitchToBestWeapon();
}

function altFire(float v)
{
   local bool bAmmo;

   bAmmo = ammoLeft();

   if (bAmmo)
	{
      spawnProjOffset = -(Class<StrangeShell>(altProjectileClass).default.pilotOffset);
      bSetProjOwner = true;
      Pawn(Owner).bHidden = true;
      lastProj = none;
   }
   // All just to get the click...
   super.altFire(v);

   if (bAmmo)
	{
      if (lastProj != none)
         StrangeShell(lastProj).setPilot(Pawn(owner)); //, skynet, launchsn);
	  else 
	  {
         clearWarning();
         clearanceStamp = level.timeseconds;
      }
      bClear = (lastProj != none);
      // Unset these. Dumbs don't need them.
      spawnProjOffset = vect(0, 0, 0);
      bSetProjOwner = false;
      Pawn(Owner).bHidden = false;
   }
}

// Plays the clearance warning on the client. Is there a way to quiet this? FIX.
function clearWarning() 
{
   if (owner.isA('PlayerPawn'))
      PlayerPawn(owner).clientPlaySound(Class'StrangeShell'.default.warnSound, false, true);
}

simulated function bool clientFire(float v) 
{
   // Reset it.
   launchv = vect(0, 0, 0);
   return super.clientFire(v);
}

simulated function bool clientAltFire(float v)
{
	bUsedNXLaunch = True;

   if (super.clientAltFire(v)) 
	{
      clearanceStamp = level.timeseconds;
      launchv = owner.velocity;
      return true;
   } 
	else return false;
}

function Actor CheckTarget() 
{
   local Actor ETarget;
   local Vector Start, X,Y,Z;
   local float bestDist, bestAim;
   local Pawn PawnOwner;
   local rotator AimRot;
   local int diff;

   PawnOwner = Pawn(Owner);
   bPointing = false;
   if ( Owner.IsA('PlayerPawn') )
   {
      GetAxes(PawnOwner.ViewRotation,X,Y,Z);
      Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
      bestAim = 0.93;
      ETarget = PawnOwner.PickTarget(bestAim, bestDist, X, Start);
   }
   else if ( PawnOwner.Enemy == None )
      return None;
   else if ( Owner.IsA('Bot') && Bot(Owner).bNovice )
      return None;
   else if ( VSize(PawnOwner.Enemy.Location - PawnOwner.Location) < 2000 )
   {
      Start = Owner.Location + CalcDrawOffset() + FireOffset.Z * vect(0,0,1);
      AimRot = rotator(PawnOwner.Enemy.Location - Start);
      diff = abs((AimRot.Yaw & 65535) - (PawnOwner.Rotation.Yaw & 65535));
      if ( (diff > 7200) && (diff < 58335) )
         return None;
      // check if can hold lock
      if ( !bPendingLock ) //not already locked
      {
         AimRot = rotator(PawnOwner.Enemy.Location + (3 - PawnOwner.Skill) * 0.3 * PawnOwner.Enemy.Velocity - Start);
         diff = abs((AimRot.Yaw & 65535) - (PawnOwner.Rotation.Yaw & 65535));
			if ( (diff > 16000) && (diff < 49535) )
        		return None;
      }

      // check line of sight
      ETarget = Trace(X,Y, PawnOwner.Enemy.Location, Start, false);
      if ( ETarget != None )
         return None;

      return PawnOwner.Enemy;
   }
   bPointing = (ETarget != None);
   Return ETarget;
}

// From Botpack.WarheadLauncher.
function float rateSelf(out int bUseAltMode) 
{
	local Bot me;

	// Alt-fire handled separately in the idle loop.
	bUseAltMode = 0;

	me = Bot(owner);
	if (me == none || !ammoLeft() || (level.timeseconds - lastFired) < 2.0)
		return -2.0;

	// Keep the weapon out until we're under fire. We may alt-fire to get on the sky network.
	if (useAltFire(me))
		return 1.0;

	if (me.enemy == none)
		return -2.0;
	
	if (vsize(me.enemy.location - me.location) > 800 && fastTrace(me.enemy.location, me.location)) 
	{
		u.debug("rateSelf(): enemy past det range: " $ u.sname(me.enemy));
		return 2.0;
	}
	return -1.0;
}


function float suggestAttackStyle() 
{
	return -1.0;
}

simulated function playSelect() 
{
	u.debug("playSelect()");

	bForceFire = false;
	bForceAltFire = false;
	bCanClientFire = false;

	if (ammoLeft())
		bUsedNXLaunch = False;

	ThirdPersonMesh = mesh'NukeLauncherM';

	if (PlayerPawn(Owner) != None)
	{
		if ( PlayerPawn(Owner).Handedness == 1 )
		{
			Mesh = mesh'NukeLauncher';
			PlayerViewMesh = mesh'NukeLauncher';
		}
		else
		{
			Mesh = mesh'NukeLauncherR';
			PlayerViewMesh = mesh'NukeLauncherR';
		}
	}
	if (!isAnimating() || (animSequence != assSelect.aname))
		playAss(assSelect);
}

simulated function tweenDown() 
{
	local bool bAmmoC;

	u.debug("tweenDown()");

	if (ammoType != none)
		bAmmoC = (ammoType.AmmoAmount > 0);

	if (isAnimating() && (animSequence != '') && (getAnimGroup(animSequence) == assSelect.aname))
		tweenAnim(animSequence, animFrame * 0.4);
	else if (bAmmoC || bUsedNXLaunch)
		playAss(assDown);
	else
		playAss(assFire);

	if (!ammoLeft())
	{
		ThirdPersonMesh = mesh'NukeLauncherMW';

		if (PlayerPawn(Owner) != None)
		{
			if ( PlayerPawn(Owner).Handedness == 1 )
			{
				Mesh = mesh'NukeLauncherW';
				PlayerViewMesh = mesh'NukeLauncherW';
			}
			else
			{
				Mesh = mesh'NukeLauncherRW';
				PlayerViewMesh = mesh'NukeLauncherRW';
			}
		}
	}
}

function dropFrom(vector startLoc) 
{
	u.debug("dropFrom()");

	if (slave == none) 
	{
		// We don't transfer clips with dropped weapons.
		if (ammo().bClipped) 
		{
			// This keeps the super call from setting ammo.
			ammoType = none;
			// Keep the clip. Unset pickup ammo.
			pickupAmmoCount = 0;
		}

		// Unset the master.
		master = none;

		super.dropFrom(startLoc);
	} 
	else
		slave.dropFrom(startLoc);

	Mesh = mesh'NukeLauncherPick';
}

defaultproperties
{
   bNeverStay=True
   teamSLClass(0)=".StrangeShell"
   teamSLClass(1)=".rocket2X"
   teamSLClass(2)=".rocket3X"
   teamSLClass(3)=".rocket4X"
   wallhitClass=Class'SLWallhit'
   assFire=(aname=Fire,arate=1.000000,tween=0.100000,Sound=Sound'NukeFire',Volume=20.000000)
   assAltFire=(arate=0.000000,Sound=Sound'XNXAlt',Volume=3.000000)
   assSelect=(arate=1.000000,Sound=Sound'NukeSelect')
   assDown=(arate=1.000000)
   assReload=(arate=0.200000,Volume=1.000000)
   assIdle=(arate=0.900000,bSkipOwner=True)
   paSlide=0.750000
   mimicPriorityOf=WarheadLauncher
   WeaponDescription="Giant, yet portable anti-everything rocket."
   InstFlash=-0.400000
   InstFog=(X=950.000000,Y=650.000000,Z=290.000000)
   AmmoName=Class'StrangeAmmo'
   ReloadCount=1
   bWarnTarget=True
   bAltWarnTarget=True
   bSplashDamage=True
   bSpecialIcon=False
   FireOffset=(X=0.000000,Y=0.000000,Z=0.000000)
   ProjectileClass=Class'AntiSlv'
   AltProjectileClass=Class'StrangeShell'
   MyDamageType=StrangeDeath
   shakemag=350.000000
   shaketime=0.200000
   shakevert=7.500000
   AIRating=1.000000
   RefireRate=0.250000
   AltRefireRate=0.250000
   FireSound=NukeFire
   SelectSound=NukeSelect
   DeathMessage="%o was Torn Into Little Pieces By %k's %w."
   NameColor=(R=10,G=0,B=0)
   AutoSwitchPriority=10
   InventoryGroup=10
   PickupMessage="You Picked Up The VM Viper "
   ItemName="Multi-Purpose Anti-Everything "
   PlayerViewOffset=(X=30.000000,Y=-20.000000,Z=-12.000000)
   PlayerViewMesh=NukeLauncher
   BobDamping=0.975000
   PickupViewMesh=NukeLauncherPick
   PickupViewScale=1.000000
   ThirdPersonMesh=NukeLauncherM
   ThirdPersonScale=0.850000
   MaxDesireability=0.000000
   PickupSound=NukePick
   Icon=NukeIconWings
   StatusIcon=NukeIconWings
   Physics=PHYS_None
   LODBias=3.000000
   Rotation=(Roll=-500)
   Mesh=NukeLauncherPick
   AmbientGlow=125
   bUnlit=True
   CollisionRadius=45.000000
   CollisionHeight=23.000000
   Texture=MetalShineBlood
   CustomRespawnTime=25.000000
}
