//This gets spawned on the client when the Konglauncher is fired.
class LaunchPuff extends SLSmoke;

// The fade intro time in seconds.
var() float intro;

// Our own substitute for the builtin lifeSpan stuff. Used also in Contrail.uc. We do this so we can change the lifeSpan on the fly.
var() float life;
var float elapsed;

// This means our lifespan has been cut short.
var bool bShorted;

simulated function beginPlay() 
{
	velocity = vector(rotation) * 15.0;
	elapsed = life;
}

simulated function tick(float d) 
{
	if (level.bDropDetail && !bShorted) 
	{
		life /= 4.0;
		elapsed /= 4.0;
		intro /= 2.0;
		bShorted = true;
	}

	if (elapsed > (life - intro)) 
	{
		// For the intro time we are expanding and solidifying.
		scaleGlow = (life - elapsed) / intro;
		drawScale = default.drawScale * scaleGlow;
	} 
	else 
	{
		// The rest we are slowly expanding and fading out.
		scaleGlow = elapsed / (life - intro);
		drawScale = default.drawScale + 1.0 * (1.0 - scaleGlow);
	}

	lightBrightness = scaleGlow * default.lightBrightness;
	elapsed -= d;

	if (elapsed < 0)
		destroy();
}

defaultproperties
{
   Intro=0.150000
   life=2.000000
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=0.000000
   DrawType=DT_Sprite
   Texture=Texture'SLV2Textures.Smoke.LaunchPuff'
   ScaleGlow=0.000000
}
