class NXHUDMenuPage expands UMenuPageWindow;

var UWindowCheckBox bJetIC, bWeapIC, bTextIC, bWarnIC;

function AfterCreate()
{
   Super.AfterCreate();

   DesiredWidth = 220;
   DesiredHeight = 150;
}

function Created()
{
	bJetIC = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 10, 270, 1));
	bJetIC.SetText("Show Jet Status");
	bJetIC.bChecked = class'StrangeShell'.default.bSeeJetView;

	bWeapIC = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 40, 270, 1));
	bWeapIC.SetText("Show Weapons Status");
	bWeapIC.bChecked = class'StrangeShell'.default.bSeeWeaponsView;

	bTextIC = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 70, 270, 1));
	bTextIC.SetText("Show Selection Text");
	bTextIC.bChecked = class'StrangeShell'.default.bSeeSelectTextView;

	bWarnIC = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 100, 270, 1));
	bWarnIC.SetText("Show WarHead-Lock Warning Message");
	bWarnIC.bChecked = class'StrangeShell'.default.bSeeLockedNukeWarn;
}

function Notify(UWindowDialogControl C, byte E)
{
	switch(E) 
	{
		case DE_Change: // the message sent by sliders and checkboxes
			switch(C) 
			{
				case bJetIC:
					class'StrangeShell'.default.bSeeJetView = bJetIC.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bWeapIC:
					class'StrangeShell'.default.bSeeWeaponsView = bWeapIC.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bTextIC:
					class'StrangeShell'.default.bSeeSelectTextView = bTextIC.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bWarnIC:
					class'StrangeShell'.default.bSeeLockedNukeWarn = bWarnIC.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
			}				
		break;
	}
}
