class NXJetMenuPage expands UMenuPageWindow;

var UWindowCheckBox bDamFX;
var UWindowEditControl xMaxSpeed, xFullSpeed, xMarchSpeed, xMinSpeed;
var UWindowEditControl xMaxAccel, xAccel, xThrottle;
var UWindowEditControl xFuel, xBaseF, xExtraF;
var UWindowEditControl xArmor, xMaxArmor;
var UWindowHSliderControl MSlideFX, MAirBrakes;
var float u2mConv;
var float maxs, mins, fulls, tcs;

function AfterCreate()
{
   Super.AfterCreate();

   DesiredWidth = 220;
   DesiredHeight = 390;
}

function Created()
{
	u2mConv = class'SLHud'.default.u2m;

	MSlideFX = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 10, 10, 245, 1));
   MSlideFX.bNoSlidingNotify = True;
   MSlideFX.SetRange(0, 255, 2);
   MSlideFX.SetText("Sliding Effect");
	MSlideFX.SetValue(class'StrangeShell'.default.SlideFX);

	MAirBrakes = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 10, 30, 245, 1));
   MAirBrakes.bNoSlidingNotify = True;
   MAirBrakes.SetRange(0, 255, 2);
   MAirBrakes.SetText("Air Brakes");
	MAirBrakes.SetValue(class'StrangeShell'.default.AirBrakes);

	xMaxSpeed = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 60, 270, 1));
	xMaxSpeed.SetText("Max Speed in Afterburner mode (m/s)");
	xMaxSpeed.SetNumericOnly(True);
	xMaxSpeed.SetNumericFloat(False);
	xMaxSpeed.SetMaxLength(3);
	xMaxSpeed.Align = TA_Left;
	maxs = class'StrangeShell'.default.MaxSpeed * u2mConv;
	xMaxSpeed.SetValue(String(Int(maxs)));
	xMaxSpeed.EditBoxWidth = WinWidth / 8;

	xFullSpeed = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 80, 270, 1));
	xFullSpeed.SetText("Max Speed in normal mode (m/s)");
	xFullSpeed.SetNumericOnly(True);
	xFullSpeed.SetNumericFloat(False);
	xFullSpeed.SetMaxLength(3);
	xFullSpeed.Align = TA_Left;
	fulls = class'StrangeShell'.default.FullSpeed * u2mConv;
	xFullSpeed.SetValue(String(Int(fulls)));
	xFullSpeed.EditBoxWidth = WinWidth / 8;

	xMarchSpeed = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 100, 270, 1));
	xMarchSpeed.SetText("Total Commitment Max Speed (m/s)");
	xMarchSpeed.SetNumericOnly(True);
	xMarchSpeed.SetNumericFloat(False);
	xMarchSpeed.SetMaxLength(3);
	xMarchSpeed.Align = TA_Left;
	tcs = class'StrangeShell'.default.MarchMaxSpeed * u2mConv;
	xMarchSpeed.SetValue(String(Int(tcs)));
	xMarchSpeed.EditBoxWidth = WinWidth / 8;

	xMinSpeed = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 120, 270, 1));
	xMinSpeed.SetText("Minimum Speed (m/s)");
	xMinSpeed.SetNumericOnly(True);
	xMinSpeed.SetNumericFloat(False);
	xMinSpeed.SetMaxLength(3);
	xMinSpeed.Align = TA_Left;
	mins = class'StrangeShell'.default.minspeed * u2mConv;
	xMinSpeed.SetValue(String(Int(mins)));
	xMinSpeed.EditBoxWidth = WinWidth / 8;

	xMaxAccel = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 150, 270, 1));
	xMaxAccel.SetText("Max Acceleration");
	xMaxAccel.SetNumericOnly(True);
	xMaxAccel.SetNumericFloat(False);
	xMaxAccel.SetMaxLength(4);
	xMaxAccel.Align = TA_Left;
	xMaxAccel.SetValue(String(Int(class'StrangeShell'.default.AccelMax)));
	xMaxAccel.EditBoxWidth = WinWidth / 8;

	xAccel = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 170, 270, 1));
	xAccel.SetText("Acceleration Rate");
	xAccel.SetNumericOnly(True);
	xAccel.SetNumericFloat(True);
	xAccel.SetMaxLength(10);
	xAccel.Align = TA_Left;
	xAccel.SetValue(String(class'StrangeShell'.default.accel));
	xAccel.EditBoxWidth = WinWidth / 8;

	xThrottle = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 190, 270, 1));
	xThrottle.SetText("Throttle Rate");
	xThrottle.SetNumericOnly(True);
	xThrottle.SetNumericFloat(True);
	xThrottle.SetMaxLength(10);
	xThrottle.Align = TA_Left;
	xThrottle.SetValue(String(class'StrangeShell'.default.thrate));
	xThrottle.EditBoxWidth = WinWidth / 8;

	xFuel = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 220, 270, 1));
	xFuel.SetText("Starting Fuel");
	xFuel.SetNumericOnly(True);
	xFuel.SetNumericFloat(False);
	xFuel.SetMaxLength(3);
	xFuel.Align = TA_Left;
	xFuel.SetValue(String(Int(class'StrangeShell'.default.fuel)));
	xFuel.EditBoxWidth = WinWidth / 8;

	xBaseF = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 240, 270, 1));
	xBaseF.SetText("Normal Fuel Consumption Rate");
	xBaseF.SetNumericOnly(True);
	xBaseF.SetNumericFloat(True);
	xBaseF.SetMaxLength(10);
	xBaseF.Align = TA_Left;
	xBaseF.SetValue(String(class'StrangeShell'.default.baseFuelRate));
	xBaseF.EditBoxWidth = WinWidth / 8;

	xExtraF = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 260, 270, 1));
	xExtraF.SetText("Extra Fuel Consumption Rate on Afterburner");
	xExtraF.SetNumericOnly(True);
	xExtraF.SetNumericFloat(True);
	xExtraF.SetMaxLength(10);
	xExtraF.Align = TA_Left;
	xExtraF.SetValue(String(class'StrangeShell'.default.afterburnRate));
	xExtraF.EditBoxWidth = WinWidth / 8;

	xArmor = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 290, 270, 1));
	xArmor.SetText("Armor");
	xArmor.SetNumericOnly(True);
	xArmor.SetNumericFloat(False);
	xArmor.SetMaxLength(4);
	xArmor.Align = TA_Left;
	xArmor.SetValue(String(Int(class'StrangeShell'.default.armor)));
	xArmor.EditBoxWidth = WinWidth / 8;

	xMaxArmor = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 310, 270, 1));
	xMaxArmor.SetText("Max Armor");
	xMaxArmor.SetNumericOnly(True);
	xMaxArmor.SetNumericFloat(False);
	xMaxArmor.SetMaxLength(4);
	xMaxArmor.Align = TA_Left;
	xMaxArmor.SetValue(String(Int(class'StrangeShell'.default.MaxArmor)));
	xMaxArmor.EditBoxWidth = WinWidth / 8;

	bDamFX = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 340, 270, 1));
	bDamFX.SetText("Enable Damage FX");
	bDamFX.bChecked = class'StrangeShell'.default.DamageFX;
}



function Notify(UWindowDialogControl C, byte E)
{
	switch(E) 
	{
		case DE_Change: // the message sent by sliders and checkboxes
			switch(C) 
			{
				case bDamFX:
					class'StrangeShell'.default.DamageFX = bDamFX.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case MSlideFX:
					class'StrangeShell'.default.SlideFX = Byte(MSlideFX.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case MAirBrakes:
					class'StrangeShell'.default.AirBrakes = Byte(MAirBrakes.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xMaxSpeed:
					class'StrangeShell'.default.MaxSpeed = Int((Float(xMaxSpeed.GetValue()) + 0.75) / u2mConv);
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xFullSpeed:
					class'StrangeShell'.default.FullSpeed = Int((Float(xFullSpeed.GetValue()) + 0.75) / u2mConv);
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xMarchSpeed:
					class'StrangeShell'.default.MarchMaxSpeed = Int((Float(xMarchSpeed.GetValue()) + 0.75) / u2mConv);
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xMinSpeed:
					class'StrangeShell'.default.minspeed = Int((Float(xMinSpeed.GetValue()) + 0.75) / u2mConv);
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xMaxAccel:
					class'StrangeShell'.default.AccelMax = Int(xMaxAccel.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xAccel:
					class'StrangeShell'.default.Accel = Float(xAccel.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xThrottle:
					class'StrangeShell'.default.thrate = Float(xThrottle.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xFuel:
					class'StrangeShell'.default.fuel = Int(xFuel.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xBaseF:
					class'StrangeShell'.default.baseFuelRate = Float(xBaseF.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xExtraF:
					class'StrangeShell'.default.afterburnRate = Float(xExtraF.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xArmor:
					class'StrangeShell'.default.armor = Int(xArmor.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xMaxArmor:
					class'StrangeShell'.default.MaxArmor = Int(xMaxArmor.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
			}				
		break;
	}
}


