class NXMutatorMenuPage expands UMenuPageWindow;

var UWindowCheckBox bKongPlaceRand, bFuelPlaceRand, bRandESR;
var UWindowEditControl MaxSLSpawns, SLSpawnDist, SLFuelN;

function AfterCreate()
{
   Super.AfterCreate();

   DesiredWidth = 220;
   DesiredHeight = 180;
}

function Created()
{
	bKongPlaceRand = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 10, 270, 1));
	bKongPlaceRand.SetText("Enable Random Konglaunchers around the flag");
	bKongPlaceRand.bChecked = class'StrangeMutator'.default.bRandomPlacement;

	MaxSLSpawns = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 30, 270, 1));
	MaxSLSpawns.SetText("Max number of Konglauncher spawns per flag");
	MaxSLSpawns.SetNumericOnly(True);
	MaxSLSpawns.SetNumericFloat(False);
	MaxSLSpawns.SetMaxLength(2);
	MaxSLSpawns.Align = TA_Left;
	MaxSLSpawns.SetValue(String(class'StrangeMutator'.default.maxNumSLSpawns));
	MaxSLSpawns.EditBoxWidth = WinWidth / 8;

	SLSpawnDist = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 50, 270, 1));
	SLSpawnDist.SetText("Max Distance Konglaunchers spawning");
	SLSpawnDist.SetNumericOnly(True);
	SLSpawnDist.SetNumericFloat(False);
	SLSpawnDist.SetMaxLength(4);
	SLSpawnDist.Align = TA_Left;
	SLSpawnDist.SetValue(String(class'StrangeMutator'.default.randSpawnDist));
	SLSpawnDist.EditBoxWidth = WinWidth / 8;

	bFuelPlaceRand = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 80, 270, 1));
	bFuelPlaceRand.SetText("Enable Random Fuel Cores near to Konglaunchers");
	bFuelPlaceRand.bChecked = class'StrangeMutator'.default.bRandomFuelNearKong;

	SLFuelN = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 100, 270, 1));
	SLFuelN.SetText("Max number of Fuel Cores near to a Konglauncher");
	SLFuelN.SetNumericOnly(True);
	SLFuelN.SetNumericFloat(False);
	SLFuelN.SetMaxLength(2);
	SLFuelN.Align = TA_Left;
	SLFuelN.SetValue(String(class'StrangeMutator'.default.randFuelNearKong));
	SLFuelN.EditBoxWidth = WinWidth / 8;

	bRandESR = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 130, 270, 1));
	bRandESR.SetText("Enable Random placement of Enhanced Shock Rifles");
	bRandESR.bChecked = class'StrangeMutator'.default.bRandomPlacementESR;
}



function Notify(UWindowDialogControl C, byte E)
{
	switch(E) 
	{
		case DE_Change: // the message sent by sliders and checkboxes
			switch(C) 
			{
				case bKongPlaceRand:
					class'StrangeMutator'.default.bRandomPlacement = bKongPlaceRand.bChecked;
					class'StrangeMutator'.static.StaticSaveConfig();
					break;
				case bFuelPlaceRand:
					class'StrangeMutator'.default.bRandomFuelNearKong = bFuelPlaceRand.bChecked;
					class'StrangeMutator'.static.StaticSaveConfig();
					break;
				case bRandESR:
					class'StrangeMutator'.default.bRandomPlacementESR = bRandESR.bChecked;
					class'StrangeMutator'.static.StaticSaveConfig();
					break;
				case MaxSLSpawns:
					class'StrangeMutator'.default.maxNumSLSpawns = Int(MaxSLSpawns.GetValue());
					class'StrangeMutator'.static.StaticSaveConfig();
					break;
				case SLSpawnDist: 
					class'StrangeMutator'.default.randSpawnDist = Int(SLSpawnDist.GetValue());
					class'StrangeMutator'.static.StaticSaveConfig();
					break;
				case SLFuelN: 
					class'StrangeMutator'.default.randFuelNearKong = Int(SLFuelN.GetValue());
					class'StrangeMutator'.static.StaticSaveConfig();
					break;
			}				
		break;
	}
}


