class NXVXDialogClientWindow expands UWindowDialogClientWindow;

var UWindowSmallCloseButton CloseButton;
var UWindowPageControl GameSettings;

function Created()
{
	WinWidth=300;
	WinHeight=600;
	CloseButton = UWindowSmallCloseButton(CreateControl(class'UWindowSmallCloseButton', WinWidth-56, WinHeight-24, 48, 16));
	GameSettings = UWindowPageControl(CreateWindow(class'UWindowPageControl', 0, 0, WinWidth, WinHeight-48));
	GameSettings.SetMultiLine(True);
	GameSettings.AddPage("Client HUD", class'NXHUDMenuPageScroll');
	GameSettings.AddPage("Jet", class'NXJetMenuPageScroll');
	GameSettings.AddPage("Miscellaneous", class'NXMiscMenuPageScroll');
	GameSettings.AddPage("Mutator", class'NXMutatorMenuPageScroll');
	GameSettings.AddPage("Onboard Weaponry", class'NXWeaponsMenuPageScroll');
	GameSettings.AddPage("Team", class'NXTeamMenuPageScroll');
	Super.Created();
}

function Resized()
{
   GameSettings.WinWidth = WinWidth;
   GameSettings.WinHeight = WinHeight - 24;   // OK, Cancel area
   CloseButton.WinLeft = WinWidth-52;
   CloseButton.WinTop = WinHeight-20;
}

function Paint(Canvas C, float X, float Y)
{
   local Texture T;

   T = GetLookAndFeelTexture();
   DrawUpBevel( C, 0, LookAndFeel.TabUnselectedM.H, WinWidth, WinHeight-LookAndFeel.TabUnselectedM.H, T);
}

function GetDesiredDimensions(out float W, out float H)
{   
   Super(UWindowWindow).GetDesiredDimensions(W, H);
   H += 30;
}
