class NXWeaponsMenuPage expands UMenuPageWindow;

var UWindowCheckBox bMachineGuns, bNewWeapons, bSeekNk, bNormNk, bDropNk, bFlash, bNHeat, bRHeat, bMWSel, bAutoCannons;
var UWindowEditControl xCannonDam;
var UWindowHSliderControl NormM, SeekM, RearM;

function AfterCreate()
{
   Super.AfterCreate();

   DesiredWidth = 220;
   DesiredHeight = 350;
}

function Created()
{
	bMachineGuns = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 10, 270, 1));
	bMachineGuns.SetText("Use Machine Guns Style cannons");
	bMachineGuns.bChecked = class'NullWeapon'.default.UseMachineGunsCannonsStyle;

	xCannonDam = UWindowEditControl(CreateControl(class'UWindowEditControl', 10, 30, 270, 1));
	xCannonDam.SetText("Cannons Damage");
	xCannonDam.SetNumericOnly(True);
	xCannonDam.SetNumericFloat(False);
	xCannonDam.SetMaxLength(3);
	xCannonDam.Align = TA_Left;
	xCannonDam.SetValue(String(class'CannonPulseProj'.default.CannonDamage));
	xCannonDam.EditBoxWidth = WinWidth / 8;

	bNewWeapons = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 60, 270, 1));
	bNewWeapons.SetText("Enable Jet Weaponry System");
	bNewWeapons.bChecked = class'StrangeShell'.default.enable_NewWeaponrySystem;

	NormM = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 10, 80, 260, 1));
   NormM.bNoSlidingNotify = True;
   NormM.SetRange(0, 4, 1);
   NormM.SetText("Number of Normal Missiles");
	NormM.SetValue(class'StrangeShell'.default.NormMissilesN);

	SeekM = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 10, 100, 260, 1));
   SeekM.bNoSlidingNotify = True;
   SeekM.SetRange(0, 2, 1);
   SeekM.SetText("Number of Seeking Missiles");
	SeekM.SetValue(class'StrangeShell'.default.SeekMissilesN);

	RearM = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', 10, 120, 260, 1));
   RearM.bNoSlidingNotify = True;
   RearM.SetRange(0, 4, 1);
   RearM.SetText("Number of Rear Missiles");
	RearM.SetValue(class'StrangeShell'.default.RearMissilesN);

	bSeekNk = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 140, 270, 1));
	bSeekNk.SetText("Random Special: Enable Seeking Nuclear Missile");
	bSeekNk.bChecked = class'StrangeShell'.default.enable_SeekNuke;

	bNormNk = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 160, 270, 1));
	bNormNk.SetText("Random Special: Enable Normal Nuclear Missile");
	bNormNk.bChecked = class'StrangeShell'.default.enable_NormNuke;

	bDropNk = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 180, 270, 1));
	bDropNk.SetText("Random Special: Enable Droppable Nuclear Missile");
	bDropNk.bChecked = class'StrangeShell'.default.enable_DropNuke;

	bFlash = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 200, 270, 1));
	bFlash.SetText("Random Special: Enable Flash Blinding Device");
	bFlash.bChecked = class'StrangeShell'.default.enable_Flash;

	bNHeat = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 220, 270, 1));
	bNHeat.SetText("Random Special: Enable Droppable Heat Seeker");
	bNHeat.bChecked = class'StrangeShell'.default.enable_NormHeatTarget;

	bRHeat = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 240, 270, 1));
	bRHeat.SetText("Random Special: Enable Impulsed Heat Seeker");
	bRHeat.bChecked = class'StrangeShell'.default.enable_RearHeatTarget;

	bMWSel = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 270, 270, 1));
	bMWSel.SetText("Select weapons manually when unavailable");
	bMWSel.bChecked = class'StrangeShell'.default.bManualWSelect;

	bAutoCannons = UWindowCheckBox(CreateControl(class'UWindowCheckBox', 10, 300, 270, 1));
	bAutoCannons.SetText("Select to cannons when no ammo");
	bAutoCannons.bChecked = class'StrangeShell'.default.bAutoSelectToCannons;
}

function Notify(UWindowDialogControl C, byte E)
{
	switch(E) 
	{
		case DE_Change: // the message sent by sliders and checkboxes
			switch(C) 
			{
				case bMachineGuns:
					class'NullWeapon'.default.UseMachineGunsCannonsStyle = bMachineGuns.bChecked;
					class'NullWeapon'.static.StaticSaveConfig();
					break;
				case bNewWeapons:
					class'StrangeShell'.default.enable_NewWeaponrySystem = bNewWeapons.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bSeekNk:
					class'StrangeShell'.default.enable_SeekNuke = bSeekNk.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bNormNk:
					class'StrangeShell'.default.enable_NormNuke = bNormNk.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bDropNk:
					class'StrangeShell'.default.enable_DropNuke = bDropNk.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bFlash:
					class'StrangeShell'.default.enable_Flash = bFlash.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bNHeat:
					class'StrangeShell'.default.enable_NormHeatTarget = bNHeat.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bRHeat:
					class'StrangeShell'.default.enable_RearHeatTarget = bRHeat.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bMWSel:
					class'StrangeShell'.default.bManualWSelect = bMWSel.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case bAutoCannons:
					class'StrangeShell'.default.bAutoSelectToCannons = bAutoCannons.bChecked;
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case NormM:
					class'StrangeShell'.default.NormMissilesN = Byte(NormM.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case SeekM: 
					class'StrangeShell'.default.SeekMissilesN = Byte(SeekM.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case RearM: 
					class'StrangeShell'.default.RearMissilesN = Byte(RearM.GetValue());
					class'StrangeShell'.static.StaticSaveConfig();
					break;
				case xCannonDam: 
					class'CannonPulseProj'.default.CannonDamage = Int(xCannonDam.GetValue());
					class'CannonPulseProj'.static.StaticSaveConfig();
					break;
			}				
		break;
	}
}


