class NukeBurnLight expands Effects;

#exec TEXTURE IMPORT NAME=NukeBurnLight FILE=NukeBurnLight.bmp GROUP=Coronas FLAGS=2

var() vector PrePivotRel;

simulated function Tick(float DeltaTime)
{
	local vector X, Y, Z;

	if (Owner != None)
		GetAxes(Owner.Rotation, X, Y, Z);
	else
		Destroy();

	PrePivot = PrePivotRel.X*X + PrePivotRel.Y*Y + PrePivotRel.Z*Z;
}

defaultproperties
{
	DrawScale=0.108000
	bTrailerSameRotation=True
	bTrailerPrePivot=True
	PrePivotRel=(X=-22)
	SpriteProjForward=2.700000
	DrawType=DT_Sprite
	RemoteRole=ROLE_SimulatedProxy
	Texture=NukeBurnLight
	bUnlit=True
	Style=STY_Translucent
	Physics=PHYS_Trailer
}

