// Invisible weapon that makes is so the pilot can't shoot while steering, and intercepts fire/altfire commands.
class NullWeapon extends TournamentWeapon config (VMViper);

#exec OBJ LOAD FILE=..\Textures\SLV2Textures.utx PACKAGE=SLV2Textures
#exec OBJ LOAD FILE=..\System\NWSuperBoltRifleV3.u PACKAGE=NWSuperBoltRifleV3

#exec AUDIO IMPORT NAME="XNXCannonFire" FILE=SOUNDS\XNXCannonFire.wav GROUP="Cannons"
#exec AUDIO IMPORT NAME="CannonsWFire" FILE=SOUNDS\CannonsWFire.wav GROUP="Cannons"

var StrangeShell sl;                    // The controller.
var NullWeapon nw;

var Konglauncher kl;
var SLClip clip;                         // Current clip, if ammo().bClipped.
var bool bClipped;
var pawn pilot;
var bool bShowStatic;
var travel AntiSlv HoTT;
var travel ANTIEVERYTHING SHOTS;
var() config travel int Bombs;
var() config travel int NumRocketsRed;
var string StingMessage;
var string NukeMessage;
var int Count;
var() config int RadiusDamage;
var byte Team;
var() config bool bCanOverRideJETWeapons;

var() config bool UseMachineGunsCannonsStyle;
//var bool bRightSelected, bLeftSelected;

//JetWeapon switch
var() config enum EJetWeapon 
{
	WH_Cannons,
	WH_Rockets,
	WH_Nuker,
} 	jetweapon;


replication 
{
	unreliable if (role == ROLE_Authority)
		jetweapon, Team;
	// Updates the client
	unreliable if (role < ROLE_Authority && bNetOwner)
		NumRocketsRed, Bombs;
}

simulated function postBeginPlay() 
{
	// Use the Konglauncher defaults to tidy up the HUD. Is there a way to avoid this? FIX.
	autoSwitchPriority = 10;
	inventoryGroup = 10;
	statusIcon = Class'Konglauncher'.default.statusIcon;
	projectileClass = Class'Konglauncher'.default.projectileClass;
	altProjectileClass = Class'Konglauncher'.default.altProjectileClass;
	super.postBeginPlay();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
  	if ( RadiusDamage < 4096 )
		RadiusDamage = 33;
  	if (Other == Level)
  	{
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
		Spawn(Class'SBoltDecalFX',,, HitLocation + HitNormal, rotator(HitNormal));
		Spawn(class'SBoltSmokeGen',,, HitLocation + HitNormal);
// Maybe come back to this but it doesn't look right
//		Spawn(Class'SBoltWallParts',,, HitLocation + HitNormal, rotator(HitNormal));
		HurtRadius(RadiusDamage, Class'CannonPulseProj'.default.CannonDamage, 'mortared', 2000, HitLocation);
  	}
  	else if ( (Other != self) && (Other != Owner) && (Other != None) )
  	{
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		{
	  		spawn(class'ut_SpriteSmokePuff',,,HitLocation+HitNormal*9);
	  		Other.PlaySound(Sound'UnrealShare.Minigun.Impact2',, 4.0,,100);
		}
		else if ( Other.bIsPawn)
		{
	  		Other.PlaySound(Sound'ChunkHit',, 4.0,,100);
	  		//Other.TakeDamage(Class'CannonPulseProj'.default.CannonDamage, Pawn(Owner), HitLocation, 2000 * X, MyDamageType);
	  		Other.TakeDamage(Class'CannonPulseProj'.default.CannonDamage, Pawn(Owner), HitLocation, 2000 * X, 'TopGun');
		}
  	}
}

function TraceCannonsShot( out vector HitLocation, vector Start, vector End, vector X, vector Y, vector Z)
{
	local vector HitNormal;
	local actor A;

	do
	{
		Start += 50*X;
		A = Trace(HitLocation,HitNormal,End,Start,True);
	}
	until (A == None || (A != sl && A!=Pawn(Owner)))

	if (A != None)
		ProcessTraceHit( A, HitLocation, HitNormal, X, Y, Z);
	else
		HitLocation = End;
}

function Fire(float v)
{
	local Vector Start, X,Y,Z;
	local int NumPoints;
	local int diff;
	local RedPulseMuzzle PMuz1, PMuz2;
	local vector HitLocB, StartB, EndB, Xb, Yb, Zb;

	bPointing=true;
	bCanClientFire=true;
	Start = Start + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustToss(ProjectileSpeed, Start, AimError,true,bWarnTarget);

	GetAxes(sl.Rotation,X,Y,Z);

	if (sl.WeapSelected == 0)
	{
		GotoState('NormalFire');

		if (!UseMachineGunsCannonsStyle)
		{
			if (sl.IsA('rocket2x'))
			{
				PMuz1 = Spawn(Class'BluePulseMuzzle', sl);
				PMuz2 = Spawn(Class'BluePulseMuzzle', sl);
			}
			else if (sl.IsA('rocket3x'))
			{
				PMuz1 = Spawn(Class'GreenPulseMuzzle', sl);
				PMuz2 = Spawn(Class'GreenPulseMuzzle', sl);
			}
			else if (sl.IsA('rocket4x'))
			{
				PMuz1 = Spawn(Class'YellowPulseMuzzle', sl);
				PMuz2 = Spawn(Class'YellowPulseMuzzle', sl);
			}
			else
			{
				PMuz1 = Spawn(Class'RedPulseMuzzle', sl);
				PMuz2 = Spawn(Class'RedPulseMuzzle', sl);
			}

			PlaySound(Sound'XNXCannonFire', SLOT_None, 149.0);
			Spawn(Class'CannonPulseProj',,, sl.Location + 21*X - 17*Y + 17*Z, sl.Rotation);
			Spawn(Class'CannonPulseProj',,, sl.Location + 21*X + 17*Y + 17*Z, sl.Rotation);
		}
		else
		{
			PlaySound(Sound'CannonsWFire', SLOT_None, 149.0);
			PMuz1 = Spawn(Class'CannonsPulseMuzzle', sl);
			PMuz2 = Spawn(Class'CannonsPulseMuzzle', sl);

			//Corrected perfect aim
			GetAxes(Pawn(Owner).ViewRotation, Xb, Yb, Zb);
			StartB = Pawn(Owner).Location + Pawn(Owner).Eyeheight*Zb + 50*Xb;
			EndB = StartB + 20000*Xb;

			TraceCannonsShot( HitLocB, StartB, EndB, Xb, Yb, Zb);

			Spawn(Class'MTracerB',,, sl.Location + 21*X - 17*Y + 17*Z, rotator(HitLocB - (sl.Location + 21*X - 17*Y + 17*Z)));
			Spawn(Class'MTracerB',,, sl.Location + 21*X + 17*Y + 17*Z, rotator(HitLocB - (sl.Location + 21*X + 17*Y + 17*Z)));
		}

		PMuz1.PrePivotRel = vect(21,-17,17);
		PMuz2.PrePivotRel = vect(21,17,17);
	}
	else if (sl.WeapSelected == 1 && sl.NormCmcX > 0)
	{
		PlaySound(Sound'JetMissileSpawn', SLOT_None, 149.0);
		Spawn(Class'TMissile',,, sl.Location + sl.NormCmRelLoc[sl.NormCmcX-1].X*X
		+ sl.NormCmRelLoc[sl.NormCmcX-1].Y*Y + sl.NormCmRelLoc[sl.NormCmcX-1].Z*Z, sl.Rotation);
		sl.LaunchNormalMissile();
	}
	else if (sl.WeapSelected == 2 && sl.SeekCmcX > 0)
	{
		PlaySound(Sound'JetMissileSpawn', SLOT_None, 149.0);
		Spawn(Class'SeekCarriedMissile',,, sl.Location + sl.SeekCmRelLoc[sl.SeekCmcX-1].X*X
		+ sl.SeekCmRelLoc[sl.SeekCmcX-1].Y*Y + sl.SeekCmRelLoc[sl.SeekCmcX-1].Z*Z, sl.Rotation);
		sl.LaunchSeekMissile();
	}
	else if (sl.WeapSelected == 3 && sl.RearCmcX > 0)
	{
		PlaySound(Sound'JetMissileSpawn', SLOT_None, 149.0);
		Spawn(Class'CarriedMissile',,, sl.Location + sl.RearCmRelLoc[sl.RearCmcX-1].X*X
		+ sl.RearCmRelLoc[sl.RearCmcX-1].Y*Y + sl.RearCmRelLoc[sl.RearCmcX-1].Z*Z,rotator(-vector(sl.Rotation)));
		sl.LaunchRearMissile();
	}
	else if (sl.WeapSelected == 4 && sl.SpecialCount > 0)
	{
		if (sl.SpecialID == 1)
			Spawn(Class'AntiSlv',,, sl.Location - 10*X - 45*Z, sl.Rotation);
		else if (sl.SpecialID == 2)
			Spawn(Class'NNuke',,, sl.Location - 10*X - 45*Z, sl.Rotation);
		else if (sl.SpecialID == 3)
			Spawn(Class'DropNuke',,, sl.Location - 10*X - 45*Z, sl.Rotation);
		else if (sl.SpecialID == 4)
			Spawn(Class'FlashDevice',,, sl.Location - 9*X - 45*Z, sl.Rotation);
		else if (sl.SpecialID == 5)
			Spawn(Class'HeatSeeker',,, sl.Location - 9*X - 45*Z, sl.Rotation);
		else if (sl.SpecialID == 6)
			Spawn(Class'ThrownHeatSeeker',,, sl.Location - 9*X - 45*Z, sl.Rotation);

		sl.LaunchSpecial();
	}
}

function altFire(float v) 
{
	if (!owner.isA('Bot') && sl != none)
		GoToState('AltFiring');
}

state AltFiring 
{
Begin:
	sl.Afterburn();
		GoToState('');
}

state NormalFire 
{
Begin:
	if (Pawn(Owner) != None && Pawn(Owner).Weapon != self) GotoState('');
	  	Else sleep(0.175);
	Finish();
}

simulated function bool clientFire(float v) 
{
	return false;
}

simulated function renderOverlays(Canvas canvas) 
{
	// Nothing.
}

state ClientActive 
{
	simulated function beginState() 
	{
		// Nothing.
	}
}

state Idle 
{
	function bool putDown() 
	{
		return global.putDown();
	}
}

auto state Active 
{
	function bool putDown()
	{
		return global.putDown();
	}
	function fire(float v) 
	{
		global.fire(v);
	}
	function altFire(float v)
	{
		global.altfire(v);
	}
	function beginState() 
	{
		// Nothing.
	}
	function endState()
	{
		// Nothing.
	}
begin:
	// Nothing.
}

state DownWeapon 
{
	function bool putDown() 
	{
		return global.putDown();
	}
}

simulated function setHand(float hand) 
{
	// Nothing.
}

//For the switch fire on middle mouse button
function switchjetweapons()
{
	if (bCanOverrideJETWeapons)
	{
	  	switch (jetweapon)
	  	{
	  	case WH_Cannons:

			if ( NumRocketsRed > 3 )
			{
				Pawn(Owner).ClientMessage("***STINGER ROCKETS READY***");
			} 
			else if ( NumRocketsRed <= 0 )
			{
				Pawn(Owner).ClientMessage("***Empty***");
			}
		   jetweapon = WH_Rockets;
		   break;

	  	case WH_Rockets:
			jetweapon = WH_Nuker;
			if ( Bombs > 3 )
			{
				Pawn(Owner).ClientMessage("***NUCLEAR BOMBS READY***");
			} else if ( Bombs <= 0 )
			{
				Pawn(Owner).ClientMessage("***Empty***");
			}
			break;

	  	case WH_Nuker:
			jetweapon = WH_Cannons;
			Pawn(Owner).ClientMessage("***FIGHTER CANNONS READY***");
			break;
		}
	}
}

// These keep those accessed none warnings at bay.
simulated function playSelect() 
{
	// Nothing. No mesh. No ammo.
}

simulated function tweenToStill() 
{
	// No mesh. Nothing.
}

function bringUp() 
{
	// Nothing.
}

function bool putDown()
{
	sl.switchWarhead();
	bChangeWeapon = False;
	Pawn(owner).pendingWeapon = None;
	return True;
}

defaultproperties
{
   RadiusDamage=150
   bCanThrow=False
   bOwnsCrosshair=True
   shakemag=0.000000
   shaketime=0.000000
   shakevert=0.000000
   bAmbientGlow=False
   ItemName="'"
   bHidden=True
   DrawType=DT_None
   AmbientGlow=0
   CollisionRadius=0.000000
   CollisionHeight=0.000000
   bCollideActors=False
   UseMachineGunsCannonsStyle=True
   MyDamageType=TopGun
   DeathMessage="%o got some new holes from %k's Viper cannons!!"
}
