class PrimaryExhaust expands Effects;

#exec TEXTURE IMPORT NAME=NukeBurnLight FILE=NukeBurnLight.bmp GROUP=Coronas FLAGS=2

var vector PrePivotRel;
var StrangeShell XNXShell;
var float TimeFadeC;
var float TimePingCount;

replication
{
	reliable if (ROLE == Role_Authority)
		PrePivotRel;
}

simulated function Tick(float DeltaTime)
{
	local vector X, Y, Z;

	if (Owner != None)
		GetAxes(Owner.Rotation, X, Y, Z);

	PrePivot = PrePivotRel.X*X + PrePivotRel.Y*Y + PrePivotRel.Z*Z;

	XNXShell = StrangeShell(Owner);

	if (XNXShell != None)
	{
		TimePingCount = 0;
		if ((!XNXShell.bMarchPlaying && XNXShell.bAfterburn) || XNXShell.bNoFuel)
		{
			if (TimeFadeC >= 0)
				TimeFadeC -= DeltaTime;
			else
				TimeFadeC = 0;
		}
		else if (TimeFadeC < 1.5)
			TimeFadeC = 1.5;

		if ((TimeFadeC >= 1.5 && ScaleGlow != Default.ScaleGlow) || (TimeFadeC < 1.5 && ScaleGlow > 0))
			ScaleGlow = TimeFadeC * Default.ScaleGlow / 1.5;
	}
	//A max of a 250ms acceptable, otherwise the jet crashes will look funny
	else if (TimePingCount < 0.25)
		TimePingCount += DeltaTime;
	else if (TimePingCount >= 0.25)
		Destroy();
}

defaultproperties
{
	DrawScale=0.110000
	bTrailerSameRotation=True
	bTrailerPrePivot=True
	SpriteProjForward=10.000000
	DrawType=DT_Sprite
	RemoteRole=ROLE_SimulatedProxy
	Texture=NukeBurnLight
	bUnlit=True
	Style=STY_Translucent
	Physics=PHYS_Trailer
	bNetTemporary=False
}

