class SLAmmo extends TournamentAmmo abstract config (SLV2);

var() bool bClipped;
var() Class<SLClip> clipClass;
var SLClip clips[32];
var int clipnum;
var() int maxClips;

var() config int configMaxAmmo;
var() Class<SpentClip> spentClip;

var bool bStored;
var int storeAmmo, storeMax;

var Util u;

replication 
{
	reliable if (bNetOwner && role == ROLE_Authority)
		clipnum, clips;
}

function preBeginPlay() 
{
	super.preBeginPlay();

	u = spawn(Class'Util', self);
	u.setDebugLevel(DL_Verbose);

	if (configMaxAmmo > 0)
		maxAmmo = configMaxAmmo;
}

simulated function int getMaxAmmo() 
{
	return maxAmmo;
}

simulated function int getAmmo() 
{
	return ammoAmount;
}

simulated function int getClips() 
{
	return clipnum;
}

// Takes a clip off the back of the array and returns it to the weapon.
function SLClip reload() 
{
	local int i;
	local SLClip fresh;

	if (bClipped)
	 {
		if (clipnum > 0) 
		{
			// The last clip is the best one.
			i = clipnum - 1;
			fresh = clips[i];
			clips[i] = none;
			clipnum--;
		}
		return fresh;
	}
	return none;
}

// Make sure we don't use this on a clipped weapon.
function bool useAmmo(int num) 
{
	if (!bClipped)
		return super.useAmmo(num);

	return false;
}

function bool addAmmo(int count) 
{
	if (count > 0) 
	{
		if (bClipped) 
			addNewClips(clipClass, count);
		else
			return super.addAmmo(count);
	}
	return false;
}

function weaponSpawned() 
{
	ammoAmount = 0;
}

function SLClip defaultClip() 
{
	return newClip(clipClass);
}

function bool handlePickupQuery(Inventory i) 
{
	if (bClipped) 
	{
		if (class == i.class) 
		{
			if (clipnum < maxClips) 
			{
				pickupMessages(i, Pawn(owner));
				i.playSound(i.pickupSound);
				addNewClips(SLAmmo(i).clipClass, SLAmmo(i).ammoAmount);
				i.setRespawn();
			}
			return true;
		}
	}

	if (inventory == none)
		return false;

	return super.handlePickupQuery(i);
}

// This is used to add a clip. Non-full clips go to the beginning of	the array and will be used last.
function bool addClip(SLClip clip) 
{
	local int where;

	if (clipnum < maxClips && !clip.empty()) 
	{
		if (clip.full())
			where = clipnum;
		else
			where = 0;

		insertClip(clip, where);
		return true;
	}
	return false;
}

function insertClip(SLClip clip, int index) 
{
	local int i;

	for (i = (clipnum - 2); i >= index; i--) 
		clips[i + 1] = clips[i];

	clips[index] = clip;
	clipnum++;
}

function addNewClips(Class<SLClip> cc, int no) 
{
	local int i;

	while (i < no && clipnum < maxClips) 
	{
		addClip(newClip(cc));
		i++;
	}
}

function SLClip newClip(Class<SLClip> cc) 
{
	local SLClip clip;

	clip = spawn(cc, owner);
	clip.rounds = clip.getMaxRounds();

	ammoAmount += clip.getRounds();	
	clip.ammo = self;
	return clip;
}

function pickupMessages(Inventory item, Pawn p) 
{
	if (level.game.localLog != none)
		level.game.localLog.logPickup(item, p);
	if (level.game.worldLog != none)
		level.game.worldLog.logPickup(item, p);
	if (item.pickupMessageClass == none)
		p.clientMessage(item.pickupMessage, 'Pickup');
	else
		p.receiveLocalizedMessage(item.pickupMessageClass, 0, none, none, item.class);
}

defaultproperties
{
   AmmoAmount=1
   Physics=PHYS_Falling
}
