class SLMutator extends Mutator;

var PlayerPawn ho;					// HUD owner.

function postBeginPlay() 
{
	ho = PlayerPawn(owner);
	register();
}

function register() 
{
	local Mutator m;
	local bool move;

   if ( ho == none )
    	return;

	m = ho.myHUD.HUDMutator;

	if (m == self)
		return;

	if (m != none) 
	{
		while (getNext(m) != none) 
		{
			if (isRelic(getNext(m)))
				// We're lost. Put us at the front.
				break;

			if (getNext(m) == self)
				// We're in there. Return.
				return;

			m = getNext(m);
		}
	}
	// Put it in front.
	nextHUDMutator = ho.myHUD.HUDMutator;
	ho.myHUD.HUDMutator = self;
}

function bool isRelic(Mutator m) 
{
	return (m.isA('HUDMutator'));
}

function Mutator getNext(Mutator m) 
{
	if (m.isA('HUDMutator'))
		return m.nextHUDMutator;
	else
		return m.nextHUDMutator;
}

defaultproperties
{
}
