class SLVCannons expands Projectile config (VMViper);

#exec AUDIO IMPORT NAME="rpbflesha" FILE=SOUNDS\rpbflesha.wav

var bool bRing,bHitWater,bWaterStart;
var() config float Damage;

auto state Flying
{
	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;

		if (!NewZone.bWaterZone || bHitWater) 
			Return;

		bHitWater = True;
		if ( Level.NetMode != NM_DedicatedServer )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.2;
			w.RemoteRole = ROLE_None;
		}
		Velocity=0.6*Velocity;
	}

	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( (Other != Instigator) && !Other.IsA('Projectile') )
			Explode(HitLocation,Normal(HitLocation-Other.Location));
	}

	function BlowUp(vector HitLocation)
	{
		HurtRadius(Damage,80.0, MyDamageType, MomentumTransfer, HitLocation );
		MakeNoise(1.0);
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local UT_LightWallHitEffect s;

		s = Spawn(class'UT_LightWallHitEffect',,,HitLocation + HitNormal*16);
		s.RemoteRole = ROLE_None;
		BlowUp(HitLocation);
		Destroy();
	}

	function BeginState()
	{
		local vector Dir;

		Dir = vector(Rotation);
		Velocity = speed * Dir;
		Acceleration = Dir * 50;
		if (Region.Zone.bWaterZone)
		{
			bHitWater = True;
			Velocity=0.6*Velocity;
		}
	}
}

defaultproperties
{
   Damage=20.000000
   speed=6000.000000
   MaxSpeed=6000.000000
   MomentumTransfer=18000
   MyDamageType=RocketXCannonFire
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=3.000000
   AmbientSound=Sound'rpbflesha'
   Mesh=LodMesh'UnrealI.eplasma'
   DrawScale=0.700000
   AmbientGlow=136
   bUnlit=True
   bTravel=True
   SoundRadius=120
   SoundVolume=119
   SoundPitch=110
   CollisionRadius=7.000000
   CollisionHeight=5.000000
   LightType=LT_Steady
   LightEffect=LE_NonIncidence
   LightBrightness=250
   LightHue=255
   LightSaturation=227
   LightRadius=6
}
