class SLWallhit extends UT_WallHit;

var() Class<SLPockmark> pockClass;
var() Class<Effects> puffClass;
var() Class<Effects> chipClass;
var() Class<Effects> sparkClass;

simulated function spawnEffects() 
{
	local Actor fx;
	local Texture tex;
	local int i;
	local int n;

	spawnSound();

	if (level.bDropDetail)
		return;

	if (level.bHighDetailMode) 
		fx = spawn(pockClass);

	n = rand(maxChips / 2) + maxChips / 2;
	for (i = 0; i < n; i++) 
	{
		if (frand() < chipOdds) 
		{
			fx = spawn(chipClass);
			if (fx != none) 
			{
				fx.remoteRole = ROLE_None;
				fx.drawScale *= 0.75;
				n--;
			}
		}
	}

	if (level.bHighDetailMode) 
	{
		// If it's anything whose normal points up, use up. Anything down, use the hitnormal.
		if ((vector(rotation) dot vect(0, 0, 1)) < 0)
			fx = spawn(puffClass,,,, rotation);
		else
			fx = spawn(puffClass,,,, rotator(vect(0, 0, 1)));

		fx.remoteRole = ROLE_None;
	}
}

defaultproperties
{
   chipClass=Class'UnrealShare.Chip'
   MaxSparks=2
   ChipOdds=1.000000
   DrawType=DT_None
}
