//* Racing sidearm. AKA "yellow jacket".
class Sidearm extends SLWeapon;

#exec AUDIO IMPORT NAME="SidearmFire" FILE=SLV2SOUNDS\SidearmFire.wav
#exec AUDIO IMPORT NAME="WeaponReload" FILE=SLV2SOUNDS\WeaponReload.wav

var() string deathStr[5];

// Some of the sidearm anims don't return to zero. FIX this. Should	be included in SLWeapon?
simulated function tweenToStill() 
{
	tweenAnim('still', 0.3);
	if (slave != none)
		slave.tweenToStill();
}

// We randomize the death messages here. This is a little overkill. FIX.
function processTraceHit(Actor a, vector hl, vector hn, vector x, vector y, vector z)
{
	// Leave in the %k. Goddamn needs the default.
	super.processTraceHit(a, hl, hn, x, y, z);
}

defaultproperties
{
   deathStr(0)="%o was wasted by %ks %w."
   deathStr(1)="%o got capped by %ks %w."
   deathStr(2)="%o had a nice blast of %ks %w."
   deathStr(3)="%o was made into a blood puddle by %ks %w."
   deathStr(4)="%o was splashed against the floor by %ks %w."
   bFirearm=True
   hitdam=30
   fireMode=FM_Auto
   rpm=600
   bAkimbo=True
   slaveName="Dual Yellow Jackets"
   leftMesh="SLV2Models.sarmview"
   assFire=(arate=3.000000,tween=0.100000,Sound=Sound'SidearmFire')
   assAltFire=(arate=4.000000,tween=0.100000,Sound=Sound'SidearmFire')
   assSelect=(Sound=Sound'WeaponReload')
   assDown=(arate=2.500000)
   assReload=(Volume=1.000000)
   paSlide=1.750000
   paFlashY=0.045000
   paFlashO=0.006000
   mimicPriorityOf=enforcer
   WeaponDescription="Hmm."
   bInstantHit=True
   bOwnsCrosshair=False
   FiringSpeed=2.000000
   FireOffset=(X=4.000000,Y=-5.000000,Z=4.000000)
   MyDamageType=shot
   RefireRate=0.600000
   DeathMessage="%o was taken out by %ks %w."
   bDrawMuzzleFlash=True
   MuzzleScale=1.000000
   FlashY=0.275000
   FlashO=0.040000
   FlashLength=0.040000
   FlashS=256
   MFTexture=Texture'SLV2Textures.muzf.mf1'
   InventoryGroup=2
   PickupMessage="You picked up a Yellow Jacket."
   ItemName="Yellow Jacket"
   PlayerViewOffset=(X=9.000000,Y=-8.000000,Z=-6.500000)
   StatusIcon=Texture'SLV2Textures.SLHud.sidearmicon'
   Icon=Texture'SLV2Textures.SLHud.sidearmicon'
   Rotation=(Roll=-4600)
   CollisionRadius=16.000000
   CollisionHeight=4.000000
   Mass=15.000000
}
