class strangeMutator extends Mutator config (VMViper);

#exec OBJ LOAD FILE=..\System\SLV2Models.u PACKAGE=SLV2Models
#exec OBJ LOAD FILE=..\Textures\SLV2TexTures.utx PACKAGE=SLV2TexTures
#exec OBJ LOAD FILE=..\Textures\SLV2Fonts.utx PACKAGE=SLV2Fonts
//#exec OBJ LOAD FILE=..\Sounds\SLV2Sounds.uax PACKAGE=SLV2Sounds

// These are set in the client options window.
var() config bool bRandomPlacement;     // Enable random konglauncher around the flag.

var() config int maxNumSLSpawns; // Max number of RX spawn points around the flag
var() config bool bRandomFuelNearKong;
var() config bool bMaxAmmo;
var() config bool bRandomPlacementESR;
var() config int randSpawnDist;  // Max distance for Konglauncher to spawn around the flag.

var() config int randFuelNearKong;
var bool bExpired;
var Util u;
var() string NXPackName;

var(Special) config bool enableSpecialAnnouncer;
var(Special) config bool enableSpecialFragEvents;

var(Special) config bool bBurnOutEvent;
var(Special) config bool bCannonBallEvent;
var(Special) config bool bEagleEyeEvent;
var(Special) config bool bHitNRunEvent;
var(Special) config bool bInstagibEvent;
var(Special) config bool bLockOnEvent;
var(Special) config bool bOwnageEvent;
var(Special) config bool bTopGunEvent;
var(Special) config bool bComboEvent;
var(Special) config bool bDeniedEvent;
var(Special) config bool bSilencerEvent;

var(Special) config float EagleEyeMinDist;
var(Special) config float InstagibMinDist;
var(Special) config float LockOnMinDist;
var(Special) config float OwnageMaxDist;

var(Special) config byte BurnOutBonus;
var(Special) config byte CannonBallBonus;
var(Special) config byte EagleEyeBonus;
var(Special) config byte HitNRunBonus;
var(Special) config byte InstagibBonus;
var(Special) config byte LockOnBonus;
var(Special) config byte OwnageBonus;
var(Special) config byte TopGunBonus;
var(Special) config byte ComboBonus;
var(Special) config byte DeniedBonus;
var(Special) config byte SilencerBonus;

var(Special) config bool bLongRange;
var(Special) config float LongRangeDist;

var(Special) config byte HeadShotBonus;
var(Special) config bool bHeadShotEffect;
var(Special) config bool enableHeadShotMsg;

var(Special) config bool enableFragAkn;
var(Special) config int FragAknSlaughter;
var(Special) config int FragAknBloodbath;
var(Special) config int FragAknAnnhilation;
var(Special) config int FragAknErradication;
var(Special) config int FragAknExtermination;
var(Special) config int FragAkTermination;

function PreBeginPlay ()
{
	bExpired = Class'Util'.static.expiredBeta(Level);
	 Super.PreBeginPlay();
}

function PostBeginPlay ()
{
	if ( !bExpired )
	{
		Spawn(Class'ProjectileSN');
		SetTimer(0.10,False);
	}

   Level.Game.DeathMessageClass = class'vxDeathMessagePlus';
	Super.PostBeginPlay();
}

function timer() 
{
	if (bRandomPlacement)
		spawnRandSL(randSpawnDist);

	if (bRandomFuelNearKong)
		spawnFuelNearKong(randFuelNearKong);

	if (bRandomPlacementESR)
		spawnRandESR(randSpawnDist);
}

function spawnRandSL(int dist) 
{
	local FlagBase fb;
	local PathNode pn;
	local int i;

	foreach AllActors(Class'FlagBase', fb) 
	{
		// spawn it at all points within the radius
		i=1;
		foreach RadiusActors(Class'PathNode', pn, dist, fb.location)
		{
			spawn(Class'Konglauncher',,, pn.location);
			if (i==maxNumSLSpawns)
				break;
			i++;
		}
	}
}

// Radom ESR for Instagib
function SpawnRandESR(int dist)
{
	local FlagBase fb;
	local PathNode pn;
	local int Num, Spawnindex;

	foreach AllActors(Class'FlagBase', fb)
	{
		Num= 0;
		foreach RadiusActors(Class'PathNode', pn, dist, fb.location)
		{
			Num++;
		}

		// Pick a random node and Spawn it at that point.
		Spawnindex = rand(Num);
		Num= 0;
		foreach RadiusActors(Class'PathNode', pn, dist, fb.location)
		{
			if (Spawnindex == Num)
			{
				Spawn(Class'vxInstagib',,, pn.location);
				break;
			}
			Num++;
		}
	 	foreach AllActors(Class'FlagBase', fb)
		  	Num= 0;
		foreach RadiusActors(Class'PathNode', pn, dist, fb.location)
		{
			Num++;
		}

		// Pick a random node and Spawn it at that point.
		Spawnindex = rand(Num);
		Num= 0;
		foreach RadiusActors(Class'PathNode', pn, dist, fb.location)
		{
			if (Spawnindex == Num)
			{
				Spawn(Class'vxInstagib',,, pn.location);
				break;
			}
			Num++;
		}
	}
}

function spawnFuelNearKong(int dist)
{
	local Konglauncher kl;
	local PathNode pn;
	local int numk, spawnindex;

	foreach AllActors(Class'Konglauncher', kl)
	{
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			numk++;
		}

		// Pick a random node and spawn it at that point.
		spawnindex = rand(numk);
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location) 
		{
			if (spawnindex == numk) 
			{
				spawn(Class'Fuelcore',,, pn.location);
				break;
			}
			numk++;
		}
	}
	foreach AllActors(Class'Konglauncher', kl) 
	{
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location) 
		{
			numk++;
		}

		// Pick a random node and spawn it at that point.
		spawnindex = rand(numk);
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location) 
		{
			if (spawnindex == numk) 
			{
				spawn(Class'Fuelcore',,, pn.location);
				break;
			}
			numk++;
		}
	}
	foreach AllActors(Class'Konglauncher', kl) 
	{
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			numk++;
		}

		// Pick a random node and spawn it at that point.
		spawnindex = rand(numk);
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			if (spawnindex == numk)
			{
				spawn(Class'Fuelcore',,, pn.location);
				break;
			}
			numk++;
		}
	}
	foreach AllActors(Class'Konglauncher', kl) 
	{
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			numk++;
		}

		// Pick a random node and spawn it at that point.
		spawnindex = rand(numk);
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			if (spawnindex == numk) 
			{
				spawn(Class'Fuelcore',,, pn.location);
				break;
			}
			numk++;
		}
	}

	foreach AllActors(Class'Konglauncher', kl)
	{
		numk = 0;

		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			numk++;
		}

		// Pick a random node and spawn it at that point.
		spawnindex = rand(numk);
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location) 
		{
			   if (spawnindex == numk) 
				{
					spawn(Class'Fuelcore',,, pn.location);
					break;
			   }
			   numk++;
		}
	}
	foreach AllActors(Class'Konglauncher', kl)
	{
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			numk++;
		}

		// Pick a random node and spawn it at that point.
		spawnindex = rand(numk);
		numk = 0;
		foreach RadiusActors(Class'PathNode', pn, dist, kl.location)
		{
			if (spawnindex == numk) 
			{
				spawn(Class'Fuelcore',,, pn.location);
				break;
			}
			numk++;
		}
	}
}

function bool checkReplacement(Actor o, out byte bSuperRelevant) 
{
	if (bExpired)
		return true;

	if (o.isA('WarheadLauncher') )
	{
		replaceWith(o, NXPackName $ ".Konglauncher");
		return false;
	}
	else if (bInstagibEvent && o.isA('SuperShockRifle') && !o.isA('vxInstagib'))
	{
		replaceWith(o, NXPackName $ ".vxInstagib");
		return false;
	}
	else if (bComboEvent && o.isA('ShockRifle') && !o.isA('SuperShockRifle') && !o.isA('vxShockRifle'))
	{
		replaceWith(o, NXPackName $ ".vxShockRifle");
		return false;
	}
	else if (bSilencerEvent && o.isA('Enforcer') && Enforcer(o).MyDamageType == 'shot')
		Enforcer(o).MyDamageType = 'Silencing';

	return true;
}

function bool alwaysKeep(Actor o) 
{
	 if (bExpired)
		  return false;

	 if (bMaxAmmo && o.isA('SLWeapon'))
		  SLWeapon(o).maxOut();

		return super.alwaysKeep(o);
}

// Added rotation rate fix. Otherwise exactly the same as the super.
function bool ReplaceWith(actor Other, string aClassName) 
{
	local Actor A;
	local class<Actor> aClass;

	if ( Other.IsA('Inventory') && (Other.Location == vect(0,0,0)) )
		return false;

	aClass = class<Actor>(DynamicLoadObject(aClassName, class'Class'));
	if ( aClass != None )
		A = Spawn(aClass,,Other.tag,Other.Location, Other.Rotation);

	if (Inventory(A) != None && Inventory(Other) != None)
	{
		Inventory(A).bRotatingPickup = Inventory(Other).bRotatingPickup;
		A.SetPhysics(Other.Physics);
		A.bFixedRotationDir = Other.bFixedRotationDir;
	}

	if ( Other.IsA('Inventory') )
	{
		if ( Inventory(Other).MyMarker != None )
		{
			Inventory(Other).MyMarker.markedItem = Inventory(A);
			if ( Inventory(A) != None )
			{
				Inventory(A).MyMarker = Inventory(Other).MyMarker;
				A.SetLocation(A.Location + (A.CollisionHeight - Other.CollisionHeight) * vect(0,0,1));
			}
			Inventory(Other).MyMarker = None;
		}
		else if ( A.IsA('Inventory') )
		{
			Inventory(A).bHeldItem = true;
			Inventory(A).Respawntime = 0.0;
		}
	}
	if ( A != None )
	{
		A.event = Other.event;
		A.tag = Other.tag;

		// All that for this!
		A.rotationRate = Other.rotationRate;
		A.SetRotation(Other.Rotation);

		return true;
	}
	return false;
}

//Mutator function called by the game itself
function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	local StrangeShell vxShell;
	local bool bEagle;
	local Carcass MoreGore;
	local float KFrags;

	if (enableFragAkn && Killer != None)
		KFrags = Killer.killCount;

	if (Killer != None && damageType == 'Decapitated')
	{
		Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.HeadShotBonus;
		Killer.killCount += class'Strangemutator'.default.HeadShotBonus;
			
		if (bHeadShotEffect)
		{
			Spawn(Class'HeadShotExpl',,, HitLocation + vect(0,0,78), Rand(16384)*rot(0,1,0));

			MoreGore = Spawn(Class'SpecialGibA',,, HitLocation, RotRand());
			MoreGore.Velocity = 200*vect(0,0,1) + (Rand(100) - 50)*vect(1,0,0) + (Rand(100) - 50)*vect(0,1,0);
			MoreGore = Spawn(Class'SpecialGibB',,, HitLocation, RotRand());
			MoreGore.Velocity = 200*vect(0,0,1) + (Rand(100) - 50)*vect(1,0,0) + (Rand(100) - 50)*vect(0,1,0);
			MoreGore = Spawn(Class'SpecialGibB',,, HitLocation, RotRand());
			MoreGore.Velocity = 200*vect(0,0,1) + (Rand(100) - 50)*vect(1,0,0) + (Rand(100) - 50)*vect(0,1,0);
			MoreGore = Spawn(Class'SpecialGibC',,, HitLocation, RotRand());
			MoreGore.Velocity = 200*vect(0,0,1) + (Rand(100) - 50)*vect(1,0,0) + (Rand(100) - 50)*vect(0,1,0);
		}

		if (enableHeadShotMsg && TournamentPlayer(Killed) != None && Killer != Killed)
			TournamentPlayer(Killed).ReceiveLocalizedMessage( class'vxVictimHeadShot', 0);
	}
	
	if (bLongRange && Killer != None && TournamentPlayer(Killer) != None && VSize(HitLocation - Killer.Location) > LongRangeDist)
	{
		if (VSize(HitLocation - Killer.Location) > LongRangeDist * 5)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxLongRangeKill', 3);
		else if (VSize(HitLocation - Killer.Location) > LongRangeDist * 2.5)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxLongRangeKill', 2);
		else
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxLongRangeKill', 1);
	}

	if (Killer != None && TournamentPlayer(Killer) != None && damagetype != 'SpecialDamage' && damagetype != 'NoUpdate' && damagetype != 'Ram' && damagetype != 'HitWall' && damagetype != 'HitSL' && damagetype != 'SpecialDamage' && damagetype != 'RedeemerDeath' && damagetype != 'TopGun' && VSize(HitLocation - Killer.Location) > EagleEyeMinDist)
	{
		foreach visibleCollidingActors(Class'StrangeShell', vxShell, 512, HitLocation)
		{
			if (Killed == vxShell.pilot || Killed == vxShell.gunner)
			{
				TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 3); //EAGLE EYE
				Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.EagleEyeBonus;
				bEagle = True;
				break;
			}
		}
	}

	if (!bEagle && Killer != None && TournamentPlayer(Killer) != None && damagetype == 'GibbedTheHellOut' && VSize(HitLocation - Killer.Location) > InstagibMinDist)
	{
		TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 8); //INSTAGIB
		Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.InstagibBonus;
	}
	else if (!bEagle && Killer != None && TournamentPlayer(Killer) != None && damagetype == 'ShockCombo')
	{
		TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 13); //COMBO WHORE
		Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.ComboBonus;
	}
	else if (!bEagle && Killer != None && TournamentPlayer(Killer) != None && damagetype == 'Silencing')
	{
		TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 15); //SILENCER
		Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.SilencerBonus;
	}

	if (Killer != None && TournamentPlayer(Killer) != None && Killer != Killed && VSize(HitLocation - Killer.Location) < OwnageMaxDist && damagetype != 'SpecialDamage')
	{
		TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 11); //OWNAGE
		Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.OwnageBonus;
	}

	if (Killer != None && TournamentPlayer(Killer) != None && damageType == 'TopGun')
	{
		foreach visibleCollidingActors(Class'StrangeShell', vxShell, 512, HitLocation)
		{
			if (Killed == vxShell.pilot || Killed == vxShell.gunner)
			{
				TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxSpecialFragEvent', 12); //TOP GUN
				Killer.PlayerReplicationInfo.Score += class'Strangemutator'.default.TopGunBonus;
				break;
			}
		}
	}

	if (damagetype == 'SpecialDamage')
		useAnnouncer(Killed, Killer);

	if (enableFragAkn && TournamentPlayer(Killer) != None)
	{
		if (KFrags < FragAknSlaughter && Killer.killCount + 1 >= FragAknSlaughter)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxFragAknMessage', 1);
		else if (KFrags < FragAknBloodbath && Killer.killCount + 1 >= FragAknBloodbath)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxFragAknMessage', 2);
		else if (KFrags < FragAknAnnhilation && Killer.killCount + 1 >= FragAknAnnhilation)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxFragAknMessage', 3);
		else if (KFrags < FragAknErradication && Killer.killCount + 1 >= FragAknErradication)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxFragAknMessage', 4);
		else if (KFrags < FragAknExtermination && Killer.killCount + 1 >= FragAknExtermination)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxFragAknMessage', 5);
		else if (KFrags < FragAkTermination && Killer.killCount + 1 >= FragAkTermination)
			TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'vxFragAknMessage', 6);
	}
		
    if ( NextMutator != None )
        return NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation);

    return false;
}

function ScoreKill(pawn Killer, pawn Killed)
{
	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

//Standard Announcer
function useAnnouncer(Pawn Killed, Pawn Killer)
{
	if (Killer != Killed && Killer != None && TournamentPlayer(Killer) != None)
	{
		TournamentPlayer(Killer).ReceiveLocalizedMessage( Class'KillerMessagePlus', 0, Killer.PlayerReplicationInfo, Killed.PlayerReplicationInfo);

		if (TournamentPlayer(Killer).Level.TimeSeconds - TournamentPlayer(Killer).LastKillTime < 3)
      {
         TournamentPlayer(Killer).MultiLevel++;
	
			if (!enableSpecialAnnouncer)
            TournamentPlayer(Killer).ReceiveLocalizedMessage( class'MultiKillMessage', TournamentPlayer(Killer).MultiLevel );
			else
				TournamentPlayer(Killer).ReceiveLocalizedMessage( class'vxMultiKillMessage', TournamentPlayer(Killer).MultiLevel );
      }
      else
         TournamentPlayer(Killer).MultiLevel = 0;

		TournamentPlayer(Killer).LastKillTime = TournamentPlayer(Killer).Level.TimeSeconds;
	}
	if (TournamentPlayer(Killed) != None && Killer != Killed)
		TournamentPlayer(Killed).ReceiveLocalizedMessage( class'VictimMessage', 0, Killer.PlayerReplicationInfo);
}

defaultproperties
{
   bRandomPlacement=True
   maxNumSLSpawns=3
   randSpawnDist=1800
	randFuelNearKong=96
	NXPackName="VMViper"
	enableSpecialAnnouncer=True
	enableSpecialFragEvents=True
	bBurnOutEvent=True
	bCannonBallEvent=True
	bEagleEyeEvent=True
	bHitNRunEvent=True
	bInstagibEvent=True
	bLockOnEvent=True
	bOwnageEvent=True
	bTopGunEvent=True
	bComboEvent=True
	bDeniedEvent=True
	bSilencerEvent=True
	BurnOutBonus=3
	CannonBallBonus=4
	EagleEyeBonus=5
	HitNRunBonus=2
	InstagibBonus=2
	LockOnBonus=1
	OwnageBonus=3
	TopGunBonus=3
	ComboBonus=2
	DeniedBonus=7
	SilencerBonus=1
	EagleEyeMinDist=850.000000
	InstagibMinDist=1350.000000
	LockOnMinDist=2200.000000
	OwnageMaxDist=128.000000
	bLongRange=True
	LongRangeDist=1850.000000
	HeadShotBonus=1
	bHeadShotEffect=True
	enableHeadShotMsg=True
	enableFragAkn=True
	FragAknSlaughter=10
	FragAknBloodbath=20
	FragAknAnnhilation=35
	FragAknErradication=50
	FragAknExtermination=75
	FragAkTermination=100
}
